#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: matrix-transpose [--hard] -i infile -o outfile\n";
}


Argument myArgs [] = {
	Argument("hard",RUMBA::FLAG,'\0'),
	Argument()
};


int main(int argc,char** argv)
{
	std::string infile , outfile;
	ManifoldMatrix M,N;
	try {
		ArgHandler argh ( argc , argv , myArgs );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );
		M = manifoldMatrixReadHack ( infile.c_str() );
		if (argh.arg("hard"))
		{
			N = makeMatrix( M.cols(), M.rows() );
			for ( int i = 0; i < M.cols(); ++i )
				for ( int j = 0; j < M.rows(); ++j )
					N.element(i,j) = M.element(j,i);
		}
		else
		{
			N = M.transpose();
		}
	
		manifoldMatrixWriteHack( N, outfile.c_str() );
	
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

}
