/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef SXPathHIncl
#define SXPathHIncl

#include "sablot.h"

typedef void *SXP_Node;
typedef void *SXP_Document;
typedef void *SXP_NodeList;

typedef enum
{
    ELEMENT_NODE = 1,
    ATTRIBUTE_NODE = 2,
    TEXT_NODE = 3,
    PROCESSING_INSTRUCTION_NODE = 7,
    COMMENT_NODE = 8,
    DOCUMENT_NODE = 9,
    NAMESPACE_NODE = 13
} SXP_NodeType;

typedef enum
{
    SXP_NONE,
    SXP_NUMBER,
    SXP_STRING,
    SXP_BOOLEAN,
    SXP_NODESET
} SXP_ExpressionType;

typedef char SXP_char;

typedef SXP_Node NodeHandle;

typedef void *QueryContext;

/*
 *    DOM handler functions
 *    This handler is registered with the Situation rather than the Processor
 */
 
/*****************************************************************
DOMHandler

  Handler providing information about a DOM tree to the XPath 
  processor
*****************************************************************/

typedef SXP_NodeType     DOMH_getNodeType(SXP_Node n);
typedef const SXP_char*  DOMH_getNodeName(SXP_Node n);
typedef const SXP_char*  DOMH_getNodeNameURI(SXP_Node n);
typedef const SXP_char*  DOMH_getNodeNameLocal(SXP_Node n);
typedef const SXP_char*  DOMH_getNodeValue(SXP_Node n);
typedef SXP_Node         DOMH_getNextSibling(SXP_Node n);
typedef SXP_Node         DOMH_getPreviousSibling(SXP_Node n);
typedef SXP_Node         DOMH_getNextAttrNS(SXP_Node n);
typedef SXP_Node         DOMH_getPreviousAttrNS(SXP_Node n);
typedef int              DOMH_getChildCount(SXP_Node n);
typedef int              DOMH_getAttributeCount(SXP_Node n);
typedef int              DOMH_getNamespaceCount(SXP_Node n);
typedef SXP_Node         DOMH_getChildNo(SXP_Node n, int ndx);
typedef SXP_Node         DOMH_getAttributeNo(SXP_Node n, int ndx);
typedef SXP_Node         DOMH_getNamespaceNo(SXP_Node n, int ndx);
typedef SXP_Node         DOMH_getParent(SXP_Node n);
typedef SXP_Document     DOMH_getOwnerDocument(SXP_Node n);
typedef int              DOMH_compareNodes(SXP_Node n1, SXP_Node n2);
typedef SXP_Document     DOMH_retrieveDocument(const SXP_char* uri, 
					       void* udata);
typedef SXP_Node         DOMH_getNodeWithID(SXP_Document doc, const SXP_char* id);

typedef struct
{
    DOMH_getNodeType         *getNodeType;
    DOMH_getNodeName         *getNodeName;
    DOMH_getNodeNameURI      *getNodeNameURI;
    DOMH_getNodeNameLocal    *getNodeNameLocal;
    DOMH_getNodeValue        *getNodeValue;
    DOMH_getNextSibling      *getNextSibling;
    DOMH_getPreviousSibling  *getPreviousSibling;
    DOMH_getNextAttrNS       *getNextAttrNS;
    DOMH_getPreviousAttrNS   *getPreviousAttrNS;
    DOMH_getChildCount       *getChildCount;
    DOMH_getAttributeCount   *getAttributeCount;
    DOMH_getNamespaceCount   *getNamespaceCount;
    DOMH_getChildNo          *getChildNo;
    DOMH_getAttributeNo      *getAttributeNo;
    DOMH_getNamespaceNo      *getNamespaceNo;
    DOMH_getParent           *getParent;
    DOMH_getOwnerDocument    *getOwnerDocument;
    DOMH_compareNodes        *compareNodes;
    DOMH_retrieveDocument    *retrieveDocument;
    DOMH_getNodeWithID       *getNodeWithID;
} DOMHandler; 

Declare
(
    void SXP_registerDOMHandler(SablotSituation S, 
				DOMHandler *domh, void* udata);
)

Declare
(
    void SXP_unregisterDOMHandler(SablotSituation S);
)

/*
 *
 *    QueryContext functions
 *
 */

Declare
(
    int SXP_createQueryContext(SablotSituation S, QueryContext *Q);
)

Declare
(
    int SXP_addVariableBinding(QueryContext Q, 
        const SXP_char* name, QueryContext source);
)
    
Declare
(
    int SXP_addVariableNumber(QueryContext Q, 
        const SXP_char* name, double value);
)

Declare
(
    int SXP_addVariableString(QueryContext Q, 
        const SXP_char* name, const SXP_char* value);
)

Declare
(
    int SXP_addVariableBoolean(QueryContext Q, 
        const SXP_char* name, int value);
)
    
Declare
(
    int SXP_addNamespaceDeclaration(QueryContext Q, 
        const SXP_char* prefix, const SXP_char* uri);
)
    
Declare
(
    int SXP_query(QueryContext Q, 
        const SXP_char* query,
	    SXP_Node n,
	    int contextPosition,
	    int contextSize);
)

Declare
(
    int SXP_destroyQueryContext(QueryContext Q);
)

/*
 *
 *    Functions to retrieve the query result and its type
 *
 */

Declare
(
    int SXP_getResultType(QueryContext Q, SXP_ExpressionType *type);
)

Declare
(
    int SXP_getResultNumber(QueryContext Q, double *result);
)

Declare
(
    int SXP_getResultBool(QueryContext Q, int *result);
)

Declare
(
    int SXP_getResultString(QueryContext Q, const char **result);
)

Declare
(
    int SXP_getResultNodeset(QueryContext Q, SXP_NodeList *result);
)

/*
 *
 *    NodeList manipulation
 *
 */

Declare
(
    int SXP_getNodeListLength(SXP_NodeList l);
)

Declare
(
    SXP_Node SXP_getNodeListItem(SXP_NodeList l, int index);
)


#endif /* SXPathHIncl */


