%define orig_version 2.2.8a
%define ja_version 1.0
%define rel 1
%define ldap 0

%{!?ldap:%define ldap 0}

Summary: Samba SMB server.
Name: samba
Version: %{orig_version}.ja
%if %{ldap}
Release: %{rel}ldap
%else
Release: %{rel}
%endif
License: GNU GPL Version 2
Group: System Environment/Daemons
URL: http://www.samba.gr.jp/
Source0: samba-%{orig_version}-ja-%{ja_version}.tar.bz2
Patch0:  samba-2.2.2-buildroot.patch
Patch1:  samba-ldaptools.patch

Requires: pam >= 0.64
%if %{ldap}
Requires: perl >= 5.6, openldap
%endif

BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prereq: fileutils sed chkconfig
BuildRequires: pam-devel, readline-devel, ncurses-devel, fileutils
Obsoletes: samba-client, samba-common, samba-debugtools, samba-swat, smbfs
Provides: samba-client, samba-common, samba-debugtools, samba-swat, smbfs

%description
Samba provides an SMB server which can be used to provide network
services to SMB (sometimes called "Lan Manager") clients, including
various versions of MS Windows, OS/2, and other Linux machines. Samba
uses NetBIOS over TCP/IP (NetBT) protocols and does NOT need NetBEUI
(Microsoft Raw NetBIOS frame) protocol.

Samba-2 features an almost working NT Domain Control capability and
includes the new SWAT (Samba Web Administration Tool) that allows
samba's smb.conf file to be remotely managed using your favourite web
browser. For the time being this is being enabled on TCP port 901 via
xinetd.

%description(ja)
SambaMS WindowsOS/2LinuxȤäSMB饤Ȥ
SMBФ󶡤ͥåȥӥǽ󶡤ޤ
SambaNetBIOS over TCP/IP(NetBT)ץȥѤ
NetBEUI(Microsoft Raw NetBIOS frame)ץȥϻѤޤ

Samba-2ħNTɥᥤ󥳥ȥΤۤȤɤεǽƯ
smb.confWeb֥饦ͳǥ⡼Ȥ齤Ǥ뿷SWAT
(Samba Webġ)ޤǤ뤳ȤǤ

%prep
%setup -q -n samba-%{orig_version}-ja-%{ja_version}

%patch0 -p1

%if %{ldap}
%patch1 -p1
%endif


%build
pushd source

autoconf
RPM_OPT_FLAGS="$RPM_OPT_FLAGS -D_FILE_OFFSET_BITS=64"

%configure \
	--libdir=/etc/samba \
	--with-fhs \
	--with-privatedir=/etc/samba \
	--with-lockdir=/var/cache/samba \
	--with-piddir=/var/run \
	--with-swatdir=%{_datadir}/swat \
	--with-codepagedir=%{_datadir}/samba/codepages \
	--with-automount \
	--with-smbmount \
	--with-pam \
	--with-pam_smbpass \
	--with-quotas \
	--without-smbwrapper \
	--with-msdfs \
	--with-utmp \
%if %{ldap}
	--with-ldapsam \
%endif
        --with-i18n-swat


make  CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE"
make  nsswitch/libnss_wins.so
make  nsswitch/pam_winbind.so
popd

## VFS SUPPORT
pushd examples/VFS
%configure
make
popd

## LDAP SUPPORT
%if %{ldap}
pushd examples/LDAP/smbldap-tools/mkntpwd
make
popd
%endif

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/usr/{sbin,bin}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/{pam.d,logrotate.d}
mkdir -p $RPM_BUILD_ROOT/var/{lock,log,spool,cache,run}/samba
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/swat/using_samba
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/samba/codepages 

cd source

%makeinstall \
	BINDIR=$RPM_BUILD_ROOT%{_bindir} \
	BASEDIR=$RPM_BUILD_ROOT%{_prefix} \
	SBINDIR=$RPM_BUILD_ROOT%{_sbindir} \
	DATADIR=$RPM_BUILD_ROOT%{_datadir} \
	LOCKDIR=$RPM_BUILD_ROOT/var/cache/samba \
	PRIVATEDIR=$RPM_BUILD_ROOT/etc/samba \
	LIBDIR=$RPM_BUILD_ROOT/etc/samba \
	CONFIGDIR=$RPM_BUILD_ROOT/etc/samba \
	MANDIR=$RPM_BUILD_ROOT%{_mandir} \
	VARDIR=$RPM_BUILD_ROOT/var/log/samba \
	CODEPAGEDIR=$RPM_BUILD_ROOT%{_datadir}/samba/codepages \
	SWATDIR=$RPM_BUILD_ROOT%{_datadir}/swat \
	SAMBABOOK=$RPM_BUILD_ROOT%{_datadir}/swat/using_samba \
	PIDDIR=$RPM_BUILD_ROOT/var/run 

cd ..

# Move PAM Module
mkdir -p $RPM_BUILD_ROOT/lib/security
mv $RPM_BUILD_ROOT/usr/bin/pam_smbpass.so $RPM_BUILD_ROOT/lib/security/
install -m755 source/nsswitch/pam_winbind.so $RPM_BUILD_ROOT/lib/security/pam_winbind.so 
# Install winbind
mkdir -p $RPM_BUILD_ROOT/lib
install -m755 source/nsswitch/libnss_winbind.so $RPM_BUILD_ROOT/lib/libnss_winbind.so
install -m755 source/nsswitch/libnss_wins.so $RPM_BUILD_ROOT/lib/libnss_wins.so
ln -s libnss_wins.so  $RPM_BUILD_ROOT/lib/libnss_wins.so.2
ln -s libnss_winbind.so  $RPM_BUILD_ROOT/lib/libnss_winbind.so.2

# samba default share directory
mkdir -p $RPM_BUILD_ROOT/var/samba
mkdir -p $RPM_BUILD_ROOT/var/samba/netlogon
mkdir -p $RPM_BUILD_ROOT/var/samba/printer
mkdir -p $RPM_BUILD_ROOT/var/samba/public
mkdir -p $RPM_BUILD_ROOT/var/samba/printer/W32X86
mkdir -p $RPM_BUILD_ROOT/var/samba/printer/WIN40

# Install other stuff
install -m644 packaging/SambaJP/smb.conf $RPM_BUILD_ROOT/etc/samba/smb.conf
install -m600 packaging/SambaJP/smbpasswd $RPM_BUILD_ROOT/etc/samba/smbpasswd
install -m644 packaging/SambaJP/smbusers $RPM_BUILD_ROOT/etc/samba/smbusers
install -m755 packaging/SambaJP/smb.init $RPM_BUILD_ROOT/etc/rc.d/init.d/smb
install -m644 packaging/SambaJP/samba.pamd $RPM_BUILD_ROOT/etc/pam.d/samba
install -m755 packaging/SambaJP/findsmb $RPM_BUILD_ROOT/%{_bindir}/findsmb
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT/etc/samba/lmhosts
ln -s ..%{_bindir}/smbmount $RPM_BUILD_ROOT/sbin/mount.smbfs
ln -s ..%{_bindir}/smbmount $RPM_BUILD_ROOT/sbin/mount.smb
install -m755 packaging/SambaJP/winbind.init $RPM_BUILD_ROOT/etc/rc.d/init.d/winbind

# Remove Documents for RPM package
rm -rf docs/docbook
rm -rf docs/htmldocs
rm -rf docs/textdocs
rm -rf docs/yodldocs
rm -rf docs/manpages
rm -rf docs/ja
rm -rf $RPM_BUILD_ROOT/usr/share/swat/ja/help/using_samba
rm -rf $RPM_BUILD_ROOT/usr/share/swat/using_samba/ja/figs
ln -s ../figs $RPM_BUILD_ROOT/usr/share/swat/using_samba/ja/figs

### VFS SUPPORT
mkdir -p $RPM_BUILD_ROOT%{_libdir}/samba/vfs/
pushd examples/VFS/
install -m 755 audit.so $RPM_BUILD_ROOT%{_libdir}/samba/vfs/
pushd recycle
mv README README.vfs-recycle
install -m 755 recycle.so $RPM_BUILD_ROOT%{_libdir}/samba/vfs/
install -m 644 recycle.conf $RPM_BUILD_ROOT/etc/samba/
popd
popd

### LDAP SUPPORT
%if %{ldap}
pushd examples/LDAP
mkdir -p $RPM_BUILD_ROOT/etc/openldap/schema/
mkdir -p $RPM_BUILD_ROOT/%{perl_sitearch}/
install -m644 samba.schema $RPM_BUILD_ROOT/etc/openldap/schema/samba.schema

pushd smbldap-tools
install -m 550 smbldap-groupadd.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-groupadd.pl
install -m 550 smbldap-groupdel.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-groupdel.pl
install -m 550 smbldap-groupmod.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-groupmod.pl
install -m 555 smbldap-groupshow.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-groupshow.pl
install -m 555 smbldap-passwd.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-passwd.pl
install -m 550 smbldap-useradd.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-useradd.pl
install -m 550 smbldap-userdel.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-userdel.pl
install -m 550 smbldap-usermod.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-usermod.pl
install -m 555 smbldap-usershow.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-usershow.pl
install -m 550 smbldap-populate.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-populate.pl
install -m 640 smbldap_conf.pm $RPM_BUILD_ROOT/%{perl_sitearch}/smbldap_conf.pm
install -m 444 smbldap_tools.pm $RPM_BUILD_ROOT/%{perl_sitearch}/smbldap_tools.pm
install -m 550 smbldap-migrate-accounts.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-migrate-accounts.pl
install -m 550 smbldap-migrate-groups.pl $RPM_BUILD_ROOT/%{_prefix}/sbin/smbldap-migrate-groups.pl
pushd mkntpwd
make PREFIX=$RPM_BUILD_ROOT/%{_prefix} install
popd
popd
popd
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post
# Add swat entry to /etc/services if not already there
if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
        echo 'swat              901/tcp                         # Add swat service used via inetd' >> /etc/services
fi

if [ -d /etc/xinetd.d -a ! -f /etc/xinetd.d/swat ]; then
   cat > /etc/xinetd.d/swat <<EOF
service swat
{
        port    = 901
        socket_type     = stream
        wait    = no
	only_from = 127.0.0.1
        user    = root
        server  = /usr/sbin/swat
        log_on_failure  += USERID
	disable = yes
}
EOF
fi

%if %{ldap}
    if [ ! -e /etc/samba/smbldap_conf.pm ]; then
	ln -s %{perl_sitearch}/smbldap_conf.pm /etc/samba/smbldap_conf.pm
    fi
    chgrp 512 %{_prefix}/sbin/smbldap-useradd.pl
    chgrp 512 %{perl_sitearch}/smbldap_conf.pm
%endif

%preun
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del smb
    /sbin/chkconfig --del winbind
    /etc/rc.d/init.d/smb stop >/dev/null 2>&1
    /etc/rc.d/init.d/winbind stop > /dev/null 2>&1
    rm -rf /var/log/samba/* /var/lock/samba/*
%if %{ldap}
    rm -f /etc/samba/smbldap_conf.pm
%endif
fi
exit 0

%postun
# Remove swat entries from /etc/services
cd /etc
tmpfile=/tmp/tmp.$$
sed -e '/^[:space:]*swat.*$/d' /etc/services > $tmpfile
mv $tmpfile /etc/services

%files
%defattr(-,root,root)
%doc README COPYING Manifest Read-Manifest-Now
%doc WHATSNEW.txt Roadmap
%doc docs
%doc examples/autofs examples/misc examples/printer-accounting examples/printing
%doc examples/VFS/recycle/README.vfs-recycle
%{_sbindir}/smbd
%{_sbindir}/nmbd
%{_sbindir}/winbindd
%{_sbindir}/swat
%{_bindir}/findsmb
%{_bindir}/smbstatus
%{_bindir}/smbpasswd
%{_bindir}/smbmount
%{_bindir}/smbmnt
%{_bindir}/smbumount
%{_bindir}/nmblookup
%{_bindir}/smbclient
%{_bindir}/smbspool
%{_bindir}/smbtar
%{_bindir}/smbcontrol
%{_bindir}/smbcacls
%{_bindir}/rpcclient
%{_bindir}/wbinfo
%{_bindir}/tdbbackup
%{_bindir}/make_smbcodepage
%{_bindir}/testparm
%{_bindir}/testprns
%{_bindir}/make_printerdef
/sbin/mount.smbfs
/sbin/mount.smb

%config(noreplace) /etc/samba/smbusers
%attr(755,root,root) %config /etc/rc.d/init.d/smb
%attr(755,root,root) %config /etc/rc.d/init.d/winbind
%config(noreplace) /etc/pam.d/samba
%{_prefix}/share/locale/en/LC_MESSAGES/samba.mo
%{_prefix}/share/locale/ja/LC_MESSAGES/samba.mo

%dir /var/lock/samba
%dir /var/run/samba
%dir /var/cache/samba
%attr(1777,root,root) %dir /var/spool/samba
%attr(0700, root, root) %dir /var/log/samba

/lib/security/pam_smbpass.so
/lib/security/pam_winbind.so
/lib/libnss_wins.so
/lib/libnss_wins.so.2
/lib/libnss_winbind.so
/lib/libnss_winbind.so.2

%{_prefix}/share/locale/en/LC_MESSAGES/samba_swat.mo
%{_prefix}/share/locale/ja/LC_MESSAGES/samba_swat.mo

%config(noreplace) /etc/samba/smb.conf
%config(noreplace) /etc/samba/lmhosts
%config(noreplace) /etc/samba/smbpasswd
%dir %{_datadir}/samba
%dir %{_datadir}/samba/codepages
%{_datadir}/swat
%{_datadir}/samba/codepages/*
%dir /etc/samba
%dir /var/samba
%dir /var/samba/netlogon
%attr(755, root, root) %dir /var/samba/printer
%dir /var/samba/printer/W32X86
%dir /var/samba/printer/WIN40
%attr(1777, root, nobody) %dir /var/samba/public

# VFS SUPPORT
%{_libdir}/samba/vfs/audit.so
%{_libdir}/samba/vfs/recycle.so
%config(noreplace) /etc/samba/recycle.conf

%{_mandir}/man1/findsmb.1*
%{_mandir}/man1/make_smbcodepage.1*
%{_mandir}/man1/make_unicodemap.1*
%{_mandir}/man1/nmblookup.1*
%{_mandir}/man1/rpcclient.1*
%{_mandir}/man1/smbcacls.1*
%{_mandir}/man1/smbclient.1*
%{_mandir}/man1/smbcontrol.1*
%{_mandir}/man1/smbsh.1*
%{_mandir}/man1/smbstatus.1*
%{_mandir}/man1/smbtar.1*
%{_mandir}/man1/testparm.1*
%{_mandir}/man1/testprns.1*
%{_mandir}/man1/wbinfo.1*
%{_mandir}/man5/smb.conf.5*
%{_mandir}/man5/lmhosts.5*
%{_mandir}/man5/smbpasswd.5*
%{_mandir}/man7/samba.7*
%{_mandir}/man8/nmbd.8*
%{_mandir}/man8/smbd.8*
%{_mandir}/man8/smbmnt.8*
%{_mandir}/man8/smbmount.8*
%{_mandir}/man8/smbpasswd.8*
%{_mandir}/man8/smbspool.8*
%{_mandir}/man8/smbumount.8*
%{_mandir}/man8/swat.8*
%{_mandir}/man8/winbindd.8*
%{_mandir}/man8/pdbedit.8*

#Japanese man page
%{_mandir}/ja/man1/findsmb.1*
%{_mandir}/ja/man1/make_smbcodepage.1*
%{_mandir}/ja/man1/make_unicodemap.1*
%{_mandir}/ja/man1/nmblookup.1*
%{_mandir}/ja/man1/rpcclient.1*
%{_mandir}/ja/man1/smbcacls.1*
%{_mandir}/ja/man1/smbclient.1*
%{_mandir}/ja/man1/smbcontrol.1*
%{_mandir}/ja/man1/smbsh.1*
%{_mandir}/ja/man1/smbstatus.1*
%{_mandir}/ja/man1/smbtar.1*
%{_mandir}/ja/man1/testparm.1*
%{_mandir}/ja/man1/testprns.1*
%{_mandir}/ja/man1/wbinfo.1*
%{_mandir}/ja/man5/lmhosts.5*
%{_mandir}/ja/man5/smb.conf.5*
%{_mandir}/ja/man5/smbpasswd.5*
%{_mandir}/ja/man7/samba.7*
%{_mandir}/ja/man8/nmbd.8*
%{_mandir}/ja/man8/smbd.8*
%{_mandir}/ja/man8/smbmnt.8*
#%{_mandir}/ja/man8/smbmount.8*  This file is included in man-pages-ja 
%{_mandir}/ja/man8/smbpasswd.8*
#%{_mandir}/ja/man8/smbumount.8* This file is included in man-pages-ja 
%{_mandir}/ja/man8/smbspool.8*
%{_mandir}/ja/man8/swat.8*
%{_mandir}/ja/man8/winbindd.8*
%{_mandir}/ja/man8/pdbedit.8*

## LDAP SUPPORT
%if %{ldap}
/etc/openldap/schema/samba.schema
%{_prefix}/sbin/smbldap-groupadd.pl
%{_prefix}/sbin/smbldap-groupdel.pl
%{_prefix}/sbin/smbldap-groupmod.pl
%{_prefix}/sbin/smbldap-groupshow.pl
%{_prefix}/sbin/smbldap-passwd.pl
%{_prefix}/sbin/smbldap-useradd.pl
%{_prefix}/sbin/smbldap-userdel.pl
%{_prefix}/sbin/smbldap-usermod.pl
%{_prefix}/sbin/smbldap-usershow.pl
%{_prefix}/sbin/smbldap-populate.pl
%{_prefix}/sbin/smbldap-migrate-accounts.pl
%{_prefix}/sbin/smbldap-migrate-groups.pl
%{_prefix}/sbin/mkntpwd
%config %{perl_sitearch}/smbldap_conf.pm
%config %{perl_sitearch}/smbldap_tools.pm
%endif

%changelog
* Tue May  9 2003 Takashi SHIRAI <shirai@unixusers.net>
- Update samba-2.2.8b-ja-1.0 for security fix

* Tue Apr  8 2003 Yasuma Takeda <yasuma@miraclelinux.com>
- Update samba-2.2.7b-ja-1.0 for security fix

* Mon Mar 17 2003 Yasuma Takeda <yasuma@miraclelinux.com>
- Update samba-2.2.7a-ja-1.1 for security fix

* Wed Feb 19 2003 Yasuma Takeda <yasuma@miraclelinux.com>
- refine file location of LDAP support

* Fri Nov 22 2002 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to samba-2.2.7-ja-1.0beta1

* Fri Sep 13 2002 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to samba-2.2.5-ja-1.0beta3
- Enable to build LDAP support  
- Added VFS support

* Sun Jun 30 2002 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to samba-2.2.4-ja-1.0beta3

* Sat Jun 22 2002 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to samba-2.2.4-ja-1.0beta2 

* Tue Feb 26 2002 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to samba-2.2.2-ja-1.1
- Fixed smbmount link
- Added /var/log/samba 
- Removed duplicate documents

* Tue Jan 9 2002 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to 1.0

* Tue Dec 11 2001 Yasuma Takeda <yasuma@miraclelinux.com>
- version up to 0.6 and add some documents.

* Fri Nov 9 2001 Yasuma Takeda <yasuma@miraclelinux.com>
- make package with samba-2.2.2-ja-0.5 + some patches
