/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_krb5pac.h"

#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_samr.h"
static enum ndr_err_code ndr_push_PAC_LOGON_NAME(struct ndr_push *ndr, int ndr_flags, const struct PAC_LOGON_NAME *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->logon_time));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 2 * strlen_m(r->account_name)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, 2 * strlen_m(r->account_name), sizeof(uint8_t), CH_UTF16));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_LOGON_NAME(struct ndr_pull *ndr, int ndr_flags, struct PAC_LOGON_NAME *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->logon_time));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, r->size, sizeof(uint8_t), CH_UTF16));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_LOGON_NAME(struct ndr_print *ndr, const char *name, const struct PAC_LOGON_NAME *r)
{
	ndr_print_struct(ndr, name, "PAC_LOGON_NAME");
	ndr->depth++;
	ndr_print_NTTIME(ndr, "logon_time", r->logon_time);
	ndr_print_uint16(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->account_name):r->size);
	ndr_print_string(ndr, "account_name", r->account_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_SIGNATURE_DATA(struct ndr_push *ndr, int ndr_flags, const struct PAC_SIGNATURE_DATA *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->type));
			{
				uint32_t _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->signature));
				ndr->flags = _flags_save_DATA_BLOB;
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_SIGNATURE_DATA(struct ndr_pull *ndr, int ndr_flags, struct PAC_SIGNATURE_DATA *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->type));
			{
				uint32_t _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->signature));
				ndr->flags = _flags_save_DATA_BLOB;
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_SIGNATURE_DATA(struct ndr_print *ndr, const char *name, const struct PAC_SIGNATURE_DATA *r)
{
	ndr_print_struct(ndr, name, "PAC_SIGNATURE_DATA");
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "type", r->type);
		ndr_print_DATA_BLOB(ndr, "signature", r->signature);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_PAC_LOGON_INFO(struct ndr_push *ndr, int ndr_flags, const struct PAC_LOGON_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->res_group_dom_sid));
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->res_groups));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
		if (r->res_group_dom_sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->res_group_dom_sid));
		}
		NDR_CHECK(ndr_push_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->res_groups));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PAC_LOGON_INFO(struct ndr_pull *ndr, int ndr_flags, struct PAC_LOGON_INFO *r)
{
	uint32_t _ptr_res_group_dom_sid;
	TALLOC_CTX *_mem_save_res_group_dom_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_res_group_dom_sid));
		if (_ptr_res_group_dom_sid) {
			NDR_PULL_ALLOC(ndr, r->res_group_dom_sid);
		} else {
			r->res_group_dom_sid = NULL;
		}
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_SCALARS, &r->res_groups));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
		if (r->res_group_dom_sid) {
			_mem_save_res_group_dom_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->res_group_dom_sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->res_group_dom_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_res_group_dom_sid_0, 0);
		}
		NDR_CHECK(ndr_pull_samr_RidWithAttributeArray(ndr, NDR_BUFFERS, &r->res_groups));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_LOGON_INFO(struct ndr_print *ndr, const char *name, const struct PAC_LOGON_INFO *r)
{
	ndr_print_struct(ndr, name, "PAC_LOGON_INFO");
	ndr->depth++;
	ndr_print_netr_SamInfo3(ndr, "info3", &r->info3);
	ndr_print_ptr(ndr, "res_group_dom_sid", r->res_group_dom_sid);
	ndr->depth++;
	if (r->res_group_dom_sid) {
		ndr_print_dom_sid2(ndr, "res_group_dom_sid", r->res_group_dom_sid);
	}
	ndr->depth--;
	ndr_print_samr_RidWithAttributeArray(ndr, "res_groups", &r->res_groups);
	ndr->depth--;
}

static size_t ndr_size_PAC_LOGON_INFO(const struct PAC_LOGON_INFO *r, int flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_PAC_LOGON_INFO);
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_LOGON_INFO_CTR(struct ndr_push *ndr, int ndr_flags, const struct PAC_LOGON_INFO_CTR *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00081001));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0xCCCCCCCC));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, NDR_ROUND(ndr_size_PAC_LOGON_INFO(r->info, ndr->flags) + 4, 8)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000000));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_PAC_LOGON_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_LOGON_INFO_CTR(struct ndr_pull *ndr, int ndr_flags, struct PAC_LOGON_INFO_CTR *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown3));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_PAC_LOGON_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_LOGON_INFO_CTR(struct ndr_print *ndr, const char *name, const struct PAC_LOGON_INFO_CTR *r)
{
	ndr_print_struct(ndr, name, "PAC_LOGON_INFO_CTR");
	ndr->depth++;
	ndr_print_uint32(ndr, "unknown1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00081001:r->unknown1);
	ndr_print_uint32(ndr, "unknown2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0xCCCCCCCC:r->unknown2);
	ndr_print_uint32(ndr, "_ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NDR_ROUND(ndr_size_PAC_LOGON_INFO(r->info, ndr->flags) + 4, 8):r->_ndr_size);
	ndr_print_uint32(ndr, "unknown3", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000000:r->unknown3);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_PAC_LOGON_INFO(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_TYPE(struct ndr_push *ndr, int ndr_flags, enum PAC_TYPE r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_TYPE(struct ndr_pull *ndr, int ndr_flags, enum PAC_TYPE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_TYPE(struct ndr_print *ndr, const char *name, enum PAC_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case PAC_TYPE_LOGON_INFO: val = "PAC_TYPE_LOGON_INFO"; break;
		case PAC_TYPE_SRV_CHECKSUM: val = "PAC_TYPE_SRV_CHECKSUM"; break;
		case PAC_TYPE_KDC_CHECKSUM: val = "PAC_TYPE_KDC_CHECKSUM"; break;
		case PAC_TYPE_LOGON_NAME: val = "PAC_TYPE_LOGON_NAME"; break;
		case PAC_TYPE_CONSTRAINED_DELEGATION: val = "PAC_TYPE_CONSTRAINED_DELEGATION"; break;
		case PAC_TYPE_UNKNOWN_12: val = "PAC_TYPE_UNKNOWN_12"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DATA_BLOB_REM(struct ndr_push *ndr, int ndr_flags, const struct DATA_BLOB_REM *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DATA_BLOB_REM(struct ndr_pull *ndr, int ndr_flags, struct DATA_BLOB_REM *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			uint32_t _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DATA_BLOB_REM(struct ndr_print *ndr, const char *name, const struct DATA_BLOB_REM *r)
{
	ndr_print_struct(ndr, name, "DATA_BLOB_REM");
	ndr->depth++;
	ndr_print_DATA_BLOB(ndr, "remaining", r->remaining);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_INFO(struct ndr_push *ndr, int ndr_flags, const union PAC_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case PAC_TYPE_LOGON_INFO: {
				NDR_CHECK(ndr_push_PAC_LOGON_INFO_CTR(ndr, NDR_SCALARS, &r->logon_info));
			break; }

			case PAC_TYPE_SRV_CHECKSUM: {
				NDR_CHECK(ndr_push_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->srv_cksum));
			break; }

			case PAC_TYPE_KDC_CHECKSUM: {
				NDR_CHECK(ndr_push_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->kdc_cksum));
			break; }

			case PAC_TYPE_LOGON_NAME: {
				NDR_CHECK(ndr_push_PAC_LOGON_NAME(ndr, NDR_SCALARS, &r->logon_name));
			break; }

			default: {
				{
					struct ndr_push *_ndr_unknown;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_unknown, 0, -1));
					NDR_CHECK(ndr_push_DATA_BLOB_REM(_ndr_unknown, NDR_SCALARS, &r->unknown));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_unknown, 0, -1));
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		int level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case PAC_TYPE_LOGON_INFO:
				NDR_CHECK(ndr_push_PAC_LOGON_INFO_CTR(ndr, NDR_BUFFERS, &r->logon_info));
			break;

			case PAC_TYPE_SRV_CHECKSUM:
			break;

			case PAC_TYPE_KDC_CHECKSUM:
			break;

			case PAC_TYPE_LOGON_NAME:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_INFO(struct ndr_pull *ndr, int ndr_flags, union PAC_INFO *r)
{
	int level;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		switch (level) {
			case PAC_TYPE_LOGON_INFO: {
				NDR_CHECK(ndr_pull_PAC_LOGON_INFO_CTR(ndr, NDR_SCALARS, &r->logon_info));
			break; }

			case PAC_TYPE_SRV_CHECKSUM: {
				NDR_CHECK(ndr_pull_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->srv_cksum));
			break; }

			case PAC_TYPE_KDC_CHECKSUM: {
				NDR_CHECK(ndr_pull_PAC_SIGNATURE_DATA(ndr, NDR_SCALARS, &r->kdc_cksum));
			break; }

			case PAC_TYPE_LOGON_NAME: {
				NDR_CHECK(ndr_pull_PAC_LOGON_NAME(ndr, NDR_SCALARS, &r->logon_name));
			break; }

			default: {
				{
					struct ndr_pull *_ndr_unknown;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_unknown, 0, -1));
					NDR_CHECK(ndr_pull_DATA_BLOB_REM(_ndr_unknown, NDR_SCALARS, &r->unknown));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_unknown, 0, -1));
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case PAC_TYPE_LOGON_INFO:
				NDR_CHECK(ndr_pull_PAC_LOGON_INFO_CTR(ndr, NDR_BUFFERS, &r->logon_info));
			break;

			case PAC_TYPE_SRV_CHECKSUM:
			break;

			case PAC_TYPE_KDC_CHECKSUM:
			break;

			case PAC_TYPE_LOGON_NAME:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_INFO(struct ndr_print *ndr, const char *name, const union PAC_INFO *r)
{
	int level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "PAC_INFO");
	switch (level) {
		case PAC_TYPE_LOGON_INFO:
			ndr_print_PAC_LOGON_INFO_CTR(ndr, "logon_info", &r->logon_info);
		break;

		case PAC_TYPE_SRV_CHECKSUM:
			ndr_print_PAC_SIGNATURE_DATA(ndr, "srv_cksum", &r->srv_cksum);
		break;

		case PAC_TYPE_KDC_CHECKSUM:
			ndr_print_PAC_SIGNATURE_DATA(ndr, "kdc_cksum", &r->kdc_cksum);
		break;

		case PAC_TYPE_LOGON_NAME:
			ndr_print_PAC_LOGON_NAME(ndr, "logon_name", &r->logon_name);
		break;

		default:
			ndr_print_DATA_BLOB_REM(ndr, "unknown", &r->unknown);
		break;

	}
}

_PUBLIC_ size_t ndr_size_PAC_INFO(const union PAC_INFO *r, uint32_t level, int flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_PAC_INFO);
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_DATA(struct ndr_push *ndr, int ndr_flags, const struct PAC_DATA *r)
{
	uint32_t cntr_buffers_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_buffers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_DATA(struct ndr_pull *ndr, int ndr_flags, struct PAC_DATA *r)
{
	uint32_t cntr_buffers_0;
	TALLOC_CTX *_mem_save_buffers_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_buffers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_PULL_ALLOC_N(ndr, r->buffers, r->num_buffers);
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_DATA(struct ndr_print *ndr, const char *name, const struct PAC_DATA *r)
{
	uint32_t cntr_buffers_0;
	ndr_print_struct(ndr, name, "PAC_DATA");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_buffers", r->num_buffers);
	ndr_print_uint32(ndr, "version", r->version);
	ndr->print(ndr, "%s: ARRAY(%d)", "buffers", (int)r->num_buffers);
	ndr->depth++;
	for (cntr_buffers_0=0;cntr_buffers_0<r->num_buffers;cntr_buffers_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_buffers_0) != -1) {
			ndr_print_PAC_BUFFER(ndr, "buffers", &r->buffers[cntr_buffers_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_BUFFER_RAW(struct ndr_push *ndr, int ndr_flags, const struct PAC_BUFFER_RAW *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_PAC_TYPE(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ndr_size));
		{
			uint32_t _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->info));
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			if (r->info) {
				NDR_CHECK(ndr_push_relative_ptr2(ndr, r->info));
				{
					struct ndr_push *_ndr_info;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_info, 0, NDR_ROUND(r->ndr_size, 8)));
					NDR_CHECK(ndr_push_DATA_BLOB_REM(_ndr_info, NDR_SCALARS, r->info));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_info, 0, NDR_ROUND(r->ndr_size, 8)));
				}
			}
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_BUFFER_RAW(struct ndr_pull *ndr, int ndr_flags, struct PAC_BUFFER_RAW *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_PAC_TYPE(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ndr_size));
		{
			uint32_t _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
			if (_ptr_info) {
				NDR_PULL_ALLOC(ndr, r->info);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->info, _ptr_info));
			} else {
				r->info = NULL;
			}
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			uint32_t _flags_save_DATA_BLOB_REM = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
			if (r->info) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->info));
				_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
				{
					struct ndr_pull *_ndr_info;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_info, 0, NDR_ROUND(r->ndr_size, 8)));
					NDR_CHECK(ndr_pull_DATA_BLOB_REM(_ndr_info, NDR_SCALARS, r->info));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_info, 0, NDR_ROUND(r->ndr_size, 8)));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_DATA_BLOB_REM;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_BUFFER_RAW(struct ndr_print *ndr, const char *name, const struct PAC_BUFFER_RAW *r)
{
	ndr_print_struct(ndr, name, "PAC_BUFFER_RAW");
	ndr->depth++;
	ndr_print_PAC_TYPE(ndr, "type", r->type);
	ndr_print_uint32(ndr, "ndr_size", r->ndr_size);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_DATA_BLOB_REM(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "_pad", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->_pad);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_PAC_DATA_RAW(struct ndr_push *ndr, int ndr_flags, const struct PAC_DATA_RAW *r)
{
	uint32_t cntr_buffers_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_buffers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER_RAW(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_push_PAC_BUFFER_RAW(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_PAC_DATA_RAW(struct ndr_pull *ndr, int ndr_flags, struct PAC_DATA_RAW *r)
{
	uint32_t cntr_buffers_0;
	TALLOC_CTX *_mem_save_buffers_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_buffers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_PULL_ALLOC_N(ndr, r->buffers, r->num_buffers);
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER_RAW(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
		for (cntr_buffers_0 = 0; cntr_buffers_0 < r->num_buffers; cntr_buffers_0++) {
			NDR_CHECK(ndr_pull_PAC_BUFFER_RAW(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PAC_DATA_RAW(struct ndr_print *ndr, const char *name, const struct PAC_DATA_RAW *r)
{
	uint32_t cntr_buffers_0;
	ndr_print_struct(ndr, name, "PAC_DATA_RAW");
	ndr->depth++;
	ndr_print_uint32(ndr, "num_buffers", r->num_buffers);
	ndr_print_uint32(ndr, "version", r->version);
	ndr->print(ndr, "%s: ARRAY(%d)", "buffers", (int)r->num_buffers);
	ndr->depth++;
	for (cntr_buffers_0=0;cntr_buffers_0<r->num_buffers;cntr_buffers_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_buffers_0) != -1) {
			ndr_print_PAC_BUFFER_RAW(ndr, "buffers", &r->buffers[cntr_buffers_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netsamlogoncache_entry(struct ndr_push *ndr, int ndr_flags, const struct netsamlogoncache_entry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->timestamp));
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netsamlogoncache_entry(struct ndr_pull *ndr, int ndr_flags, struct netsamlogoncache_entry *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->timestamp));
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_SCALARS, &r->info3));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_netr_SamInfo3(ndr, NDR_BUFFERS, &r->info3));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netsamlogoncache_entry(struct ndr_print *ndr, const char *name, const struct netsamlogoncache_entry *r)
{
	ndr_print_struct(ndr, name, "netsamlogoncache_entry");
	ndr->depth++;
	ndr_print_time_t(ndr, "timestamp", r->timestamp);
	ndr_print_netr_SamInfo3(ndr, "info3", &r->info3);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_decode_pac(struct ndr_push *ndr, int flags, const struct decode_pac *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_PAC_DATA(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pac));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_decode_pac(struct ndr_pull *ndr, int flags, struct decode_pac *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_PAC_DATA(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pac));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_decode_pac(struct ndr_print *ndr, const char *name, int flags, const struct decode_pac *r)
{
	ndr_print_struct(ndr, name, "decode_pac");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "decode_pac");
		ndr->depth++;
		ndr_print_PAC_DATA(ndr, "pac", &r->in.pac);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "decode_pac");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_decode_pac_raw(struct ndr_push *ndr, int flags, const struct decode_pac_raw *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_PAC_DATA_RAW(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pac));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_decode_pac_raw(struct ndr_pull *ndr, int flags, struct decode_pac_raw *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_PAC_DATA_RAW(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pac));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_decode_pac_raw(struct ndr_print *ndr, const char *name, int flags, const struct decode_pac_raw *r)
{
	ndr_print_struct(ndr, name, "decode_pac_raw");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "decode_pac_raw");
		ndr->depth++;
		ndr_print_PAC_DATA_RAW(ndr, "pac", &r->in.pac);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "decode_pac_raw");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_decode_login_info(struct ndr_push *ndr, int flags, const struct decode_login_info *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_PAC_LOGON_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.logon_info));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_decode_login_info(struct ndr_pull *ndr, int flags, struct decode_login_info *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_PAC_LOGON_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.logon_info));
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_decode_login_info(struct ndr_print *ndr, const char *name, int flags, const struct decode_login_info *r)
{
	ndr_print_struct(ndr, name, "decode_login_info");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "decode_login_info");
		ndr->depth++;
		ndr_print_PAC_LOGON_INFO(ndr, "logon_info", &r->in.logon_info);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "decode_login_info");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call krb5pac_calls[] = {
	{
		"decode_pac",
		sizeof(struct decode_pac),
		(ndr_push_flags_fn_t) ndr_push_decode_pac,
		(ndr_pull_flags_fn_t) ndr_pull_decode_pac,
		(ndr_print_function_t) ndr_print_decode_pac,
		false,
	},
	{
		"decode_pac_raw",
		sizeof(struct decode_pac_raw),
		(ndr_push_flags_fn_t) ndr_push_decode_pac_raw,
		(ndr_pull_flags_fn_t) ndr_pull_decode_pac_raw,
		(ndr_print_function_t) ndr_print_decode_pac_raw,
		false,
	},
	{
		"decode_login_info",
		sizeof(struct decode_login_info),
		(ndr_push_flags_fn_t) ndr_push_decode_login_info,
		(ndr_pull_flags_fn_t) ndr_pull_decode_login_info,
		(ndr_print_function_t) ndr_print_decode_login_info,
		false,
	},
	{ NULL, 0, NULL, NULL, NULL, false }
};

static const char * const krb5pac_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\krb5pac]", 
};

static const struct ndr_interface_string_array krb5pac_endpoints = {
	.count	= 1,
	.names	= krb5pac_endpoint_strings
};

static const char * const krb5pac_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array krb5pac_authservices = {
	.count	= 1,
	.names	= krb5pac_authservice_strings
};


const struct ndr_interface_table ndr_table_krb5pac = {
	.name		= "krb5pac",
	.syntax_id	= {
		{0x12345778,0x1234,0xabcd,{0x00,0x00},{0x00,0x00,0x00,0x00}},
		NDR_KRB5PAC_VERSION
	},
	.helpstring	= NDR_KRB5PAC_HELPSTRING,
	.num_calls	= 3,
	.calls		= krb5pac_calls,
	.endpoints	= &krb5pac_endpoints,
	.authservices	= &krb5pac_authservices
};

