/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_browser.h"

#include "librpc/gen_ndr/ndr_srvsvc.h"
static enum ndr_err_code ndr_push_BrowserrSrvInfo100Ctr(struct ndr_push *ndr, int ndr_flags, const struct BrowserrSrvInfo100Ctr *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries_read));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->entries_read));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->entries_read; cntr_entries_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSrvInfo100(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->entries_read; cntr_entries_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSrvInfo100(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrSrvInfo100Ctr(struct ndr_pull *ndr, int ndr_flags, struct BrowserrSrvInfo100Ctr *r)
{
	uint32_t _ptr_entries;
	uint32_t size_entries_1 = 0;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->entries_read));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			size_entries_1 = ndr_get_array_size(ndr, &r->entries);
			NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_1);
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < size_entries_1; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo100(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < size_entries_1; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo100(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->entries_read));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrSrvInfo100Ctr(struct ndr_print *ndr, const char *name, const struct BrowserrSrvInfo100Ctr *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "BrowserrSrvInfo100Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "entries_read", r->entries_read);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->entries_read);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->entries_read;cntr_entries_1++) {
			ndr_print_srvsvc_NetSrvInfo100(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrSrvInfo101Ctr(struct ndr_push *ndr, int ndr_flags, const struct BrowserrSrvInfo101Ctr *r)
{
	uint32_t cntr_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->entries_read));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->entries_read));
			for (cntr_entries_1 = 0; cntr_entries_1 < r->entries_read; cntr_entries_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSrvInfo101(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < r->entries_read; cntr_entries_1++) {
				NDR_CHECK(ndr_push_srvsvc_NetSrvInfo101(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrSrvInfo101Ctr(struct ndr_pull *ndr, int ndr_flags, struct BrowserrSrvInfo101Ctr *r)
{
	uint32_t _ptr_entries;
	uint32_t size_entries_1 = 0;
	uint32_t cntr_entries_1;
	TALLOC_CTX *_mem_save_entries_0;
	TALLOC_CTX *_mem_save_entries_1;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->entries_read));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_entries));
		if (_ptr_entries) {
			NDR_PULL_ALLOC(ndr, r->entries);
		} else {
			r->entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->entries) {
			_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->entries));
			size_entries_1 = ndr_get_array_size(ndr, &r->entries);
			NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_1);
			_mem_save_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
			for (cntr_entries_1 = 0; cntr_entries_1 < size_entries_1; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo101(ndr, NDR_SCALARS, &r->entries[cntr_entries_1]));
			}
			for (cntr_entries_1 = 0; cntr_entries_1 < size_entries_1; cntr_entries_1++) {
				NDR_CHECK(ndr_pull_srvsvc_NetSrvInfo101(ndr, NDR_BUFFERS, &r->entries[cntr_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		}
		if (r->entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->entries, r->entries_read));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrSrvInfo101Ctr(struct ndr_print *ndr, const char *name, const struct BrowserrSrvInfo101Ctr *r)
{
	uint32_t cntr_entries_1;
	ndr_print_struct(ndr, name, "BrowserrSrvInfo101Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "entries_read", r->entries_read);
	ndr_print_ptr(ndr, "entries", r->entries);
	ndr->depth++;
	if (r->entries) {
		ndr->print(ndr, "%s: ARRAY(%d)", "entries", (int)r->entries_read);
		ndr->depth++;
		for (cntr_entries_1=0;cntr_entries_1<r->entries_read;cntr_entries_1++) {
			ndr_print_srvsvc_NetSrvInfo101(ndr, "entries", &r->entries[cntr_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrSrvInfoUnion(struct ndr_push *ndr, int ndr_flags, const union BrowserrSrvInfoUnion *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 100: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info100));
			break; }

			case 101: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info101));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		uint32_t level = ndr_push_get_switch_value(ndr, r);
		switch (level) {
			case 100:
				if (r->info100) {
					NDR_CHECK(ndr_push_BrowserrSrvInfo100Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
				}
			break;

			case 101:
				if (r->info101) {
					NDR_CHECK(ndr_push_BrowserrSrvInfo101Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->info101));
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrSrvInfoUnion(struct ndr_pull *ndr, int ndr_flags, union BrowserrSrvInfoUnion *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_info100_0;
	uint32_t _ptr_info100;
	TALLOC_CTX *_mem_save_info101_0;
	uint32_t _ptr_info101;
	level = ndr_pull_get_switch_value(ndr, r);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %u for r at %s", _level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 100: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info100));
				if (_ptr_info100) {
					NDR_PULL_ALLOC(ndr, r->info100);
				} else {
					r->info100 = NULL;
				}
			break; }

			case 101: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info101));
				if (_ptr_info101) {
					NDR_PULL_ALLOC(ndr, r->info101);
				} else {
					r->info101 = NULL;
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		switch (level) {
			case 100:
				if (r->info100) {
					_mem_save_info100_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info100, 0);
					NDR_CHECK(ndr_pull_BrowserrSrvInfo100Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->info100));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info100_0, 0);
				}
			break;

			case 101:
				if (r->info101) {
					_mem_save_info101_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info101, 0);
					NDR_CHECK(ndr_pull_BrowserrSrvInfo101Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->info101));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info101_0, 0);
				}
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrSrvInfoUnion(struct ndr_print *ndr, const char *name, const union BrowserrSrvInfoUnion *r)
{
	uint32_t level;
	level = ndr_print_get_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "BrowserrSrvInfoUnion");
	switch (level) {
		case 100:
			ndr_print_ptr(ndr, "info100", r->info100);
			ndr->depth++;
			if (r->info100) {
				ndr_print_BrowserrSrvInfo100Ctr(ndr, "info100", r->info100);
			}
			ndr->depth--;
		break;

		case 101:
			ndr_print_ptr(ndr, "info101", r->info101);
			ndr->depth++;
			if (r->info101) {
				ndr_print_BrowserrSrvInfo101Ctr(ndr, "info101", r->info101);
			}
			ndr->depth--;
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_BrowserrSrvInfo(struct ndr_push *ndr, int ndr_flags, const struct BrowserrSrvInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_push_BrowserrSrvInfoUnion(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_BrowserrSrvInfoUnion(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrSrvInfo(struct ndr_pull *ndr, int ndr_flags, struct BrowserrSrvInfo *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->level));
		NDR_CHECK(ndr_pull_BrowserrSrvInfoUnion(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_BrowserrSrvInfoUnion(ndr, NDR_BUFFERS, &r->info));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrSrvInfo(struct ndr_print *ndr, const char *name, const struct BrowserrSrvInfo *r)
{
	ndr_print_struct(ndr, name, "BrowserrSrvInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_set_switch_value(ndr, &r->info, r->level);
	ndr_print_BrowserrSrvInfoUnion(ndr, "info", &r->info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrServerEnum(struct ndr_push *ndr, int flags, const struct BrowserrServerEnum *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrServerEnum(struct ndr_pull *ndr, int flags, struct BrowserrServerEnum *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrServerEnum(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrServerEnum *r)
{
	ndr_print_struct(ndr, name, "BrowserrServerEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrServerEnum");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrServerEnum");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrDebugCall(struct ndr_push *ndr, int flags, const struct BrowserrDebugCall *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrDebugCall(struct ndr_pull *ndr, int flags, struct BrowserrDebugCall *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrDebugCall(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrDebugCall *r)
{
	ndr_print_struct(ndr, name, "BrowserrDebugCall");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrDebugCall");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrDebugCall");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrQueryOtherDomains(struct ndr_push *ndr, int flags, const struct BrowserrQueryOtherDomains *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.server_unc));
		if (r->in.server_unc) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.server_unc, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.server_unc, ndr_charset_length(r->in.server_unc, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_BrowserrSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_BrowserrSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		if (r->out.total_entries == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.total_entries));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrQueryOtherDomains(struct ndr_pull *ndr, int flags, struct BrowserrQueryOtherDomains *r)
{
	uint32_t _ptr_server_unc;
	uint32_t size_server_unc_1 = 0;
	uint32_t length_server_unc_1 = 0;
	TALLOC_CTX *_mem_save_server_unc_0;
	TALLOC_CTX *_mem_save_info_0;
	TALLOC_CTX *_mem_save_total_entries_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_unc));
		if (_ptr_server_unc) {
			NDR_PULL_ALLOC(ndr, r->in.server_unc);
		} else {
			r->in.server_unc = NULL;
		}
		if (r->in.server_unc) {
			_mem_save_server_unc_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.server_unc, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.server_unc));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.server_unc));
			size_server_unc_1 = ndr_get_array_size(ndr, &r->in.server_unc);
			length_server_unc_1 = ndr_get_array_length(ndr, &r->in.server_unc);
			if (length_server_unc_1 > size_server_unc_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_server_unc_1, length_server_unc_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_unc_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.server_unc, length_server_unc_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_unc_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_BrowserrSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.info);
		*r->out.info = *r->in.info;
		NDR_PULL_ALLOC(ndr, r->out.total_entries);
		ZERO_STRUCTP(r->out.total_entries);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_BrowserrSrvInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.total_entries);
		}
		_mem_save_total_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.total_entries, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.total_entries));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_total_entries_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrQueryOtherDomains(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrQueryOtherDomains *r)
{
	ndr_print_struct(ndr, name, "BrowserrQueryOtherDomains");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrQueryOtherDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_unc", r->in.server_unc);
		ndr->depth++;
		if (r->in.server_unc) {
			ndr_print_string(ndr, "server_unc", r->in.server_unc);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_BrowserrSrvInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrQueryOtherDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_BrowserrSrvInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrResetNetlogonState(struct ndr_push *ndr, int flags, const struct BrowserrResetNetlogonState *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrResetNetlogonState(struct ndr_pull *ndr, int flags, struct BrowserrResetNetlogonState *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrResetNetlogonState(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrResetNetlogonState *r)
{
	ndr_print_struct(ndr, name, "BrowserrResetNetlogonState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrResetNetlogonState");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrResetNetlogonState");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrDebugTrace(struct ndr_push *ndr, int flags, const struct BrowserrDebugTrace *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrDebugTrace(struct ndr_pull *ndr, int flags, struct BrowserrDebugTrace *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrDebugTrace(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrDebugTrace *r)
{
	ndr_print_struct(ndr, name, "BrowserrDebugTrace");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrDebugTrace");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrDebugTrace");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrQueryStatistics(struct ndr_push *ndr, int flags, const struct BrowserrQueryStatistics *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrQueryStatistics(struct ndr_pull *ndr, int flags, struct BrowserrQueryStatistics *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrQueryStatistics(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrQueryStatistics *r)
{
	ndr_print_struct(ndr, name, "BrowserrQueryStatistics");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrQueryStatistics");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrQueryStatistics");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserResetStatistics(struct ndr_push *ndr, int flags, const struct BrowserResetStatistics *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserResetStatistics(struct ndr_pull *ndr, int flags, struct BrowserResetStatistics *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserResetStatistics(struct ndr_print *ndr, const char *name, int flags, const struct BrowserResetStatistics *r)
{
	ndr_print_struct(ndr, name, "BrowserResetStatistics");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserResetStatistics");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserResetStatistics");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NetrBrowserStatisticsClear(struct ndr_push *ndr, int flags, const struct NetrBrowserStatisticsClear *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NetrBrowserStatisticsClear(struct ndr_pull *ndr, int flags, struct NetrBrowserStatisticsClear *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NetrBrowserStatisticsClear(struct ndr_print *ndr, const char *name, int flags, const struct NetrBrowserStatisticsClear *r)
{
	ndr_print_struct(ndr, name, "NetrBrowserStatisticsClear");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetrBrowserStatisticsClear");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetrBrowserStatisticsClear");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NetrBrowserStatisticsGet(struct ndr_push *ndr, int flags, const struct NetrBrowserStatisticsGet *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NetrBrowserStatisticsGet(struct ndr_pull *ndr, int flags, struct NetrBrowserStatisticsGet *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NetrBrowserStatisticsGet(struct ndr_print *ndr, const char *name, int flags, const struct NetrBrowserStatisticsGet *r)
{
	ndr_print_struct(ndr, name, "NetrBrowserStatisticsGet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetrBrowserStatisticsGet");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetrBrowserStatisticsGet");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrSetNetlogonState(struct ndr_push *ndr, int flags, const struct BrowserrSetNetlogonState *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrSetNetlogonState(struct ndr_pull *ndr, int flags, struct BrowserrSetNetlogonState *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrSetNetlogonState(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrSetNetlogonState *r)
{
	ndr_print_struct(ndr, name, "BrowserrSetNetlogonState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrSetNetlogonState");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrSetNetlogonState");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrQueryEmulatedDomains(struct ndr_push *ndr, int flags, const struct BrowserrQueryEmulatedDomains *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrQueryEmulatedDomains(struct ndr_pull *ndr, int flags, struct BrowserrQueryEmulatedDomains *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrQueryEmulatedDomains(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrQueryEmulatedDomains *r)
{
	ndr_print_struct(ndr, name, "BrowserrQueryEmulatedDomains");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrQueryEmulatedDomains");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrQueryEmulatedDomains");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_BrowserrServerEnumEx(struct ndr_push *ndr, int flags, const struct BrowserrServerEnumEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_BrowserrServerEnumEx(struct ndr_pull *ndr, int flags, struct BrowserrServerEnumEx *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_BrowserrServerEnumEx(struct ndr_print *ndr, const char *name, int flags, const struct BrowserrServerEnumEx *r)
{
	ndr_print_struct(ndr, name, "BrowserrServerEnumEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "BrowserrServerEnumEx");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "BrowserrServerEnumEx");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call browser_calls[] = {
	{
		"BrowserrServerEnum",
		sizeof(struct BrowserrServerEnum),
		(ndr_push_flags_fn_t) ndr_push_BrowserrServerEnum,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrServerEnum,
		(ndr_print_function_t) ndr_print_BrowserrServerEnum,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrDebugCall",
		sizeof(struct BrowserrDebugCall),
		(ndr_push_flags_fn_t) ndr_push_BrowserrDebugCall,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrDebugCall,
		(ndr_print_function_t) ndr_print_BrowserrDebugCall,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrQueryOtherDomains",
		sizeof(struct BrowserrQueryOtherDomains),
		(ndr_push_flags_fn_t) ndr_push_BrowserrQueryOtherDomains,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrQueryOtherDomains,
		(ndr_print_function_t) ndr_print_BrowserrQueryOtherDomains,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrResetNetlogonState",
		sizeof(struct BrowserrResetNetlogonState),
		(ndr_push_flags_fn_t) ndr_push_BrowserrResetNetlogonState,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrResetNetlogonState,
		(ndr_print_function_t) ndr_print_BrowserrResetNetlogonState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrDebugTrace",
		sizeof(struct BrowserrDebugTrace),
		(ndr_push_flags_fn_t) ndr_push_BrowserrDebugTrace,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrDebugTrace,
		(ndr_print_function_t) ndr_print_BrowserrDebugTrace,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrQueryStatistics",
		sizeof(struct BrowserrQueryStatistics),
		(ndr_push_flags_fn_t) ndr_push_BrowserrQueryStatistics,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrQueryStatistics,
		(ndr_print_function_t) ndr_print_BrowserrQueryStatistics,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserResetStatistics",
		sizeof(struct BrowserResetStatistics),
		(ndr_push_flags_fn_t) ndr_push_BrowserResetStatistics,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserResetStatistics,
		(ndr_print_function_t) ndr_print_BrowserResetStatistics,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"NetrBrowserStatisticsClear",
		sizeof(struct NetrBrowserStatisticsClear),
		(ndr_push_flags_fn_t) ndr_push_NetrBrowserStatisticsClear,
		(ndr_pull_flags_fn_t) ndr_pull_NetrBrowserStatisticsClear,
		(ndr_print_function_t) ndr_print_NetrBrowserStatisticsClear,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"NetrBrowserStatisticsGet",
		sizeof(struct NetrBrowserStatisticsGet),
		(ndr_push_flags_fn_t) ndr_push_NetrBrowserStatisticsGet,
		(ndr_pull_flags_fn_t) ndr_pull_NetrBrowserStatisticsGet,
		(ndr_print_function_t) ndr_print_NetrBrowserStatisticsGet,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrSetNetlogonState",
		sizeof(struct BrowserrSetNetlogonState),
		(ndr_push_flags_fn_t) ndr_push_BrowserrSetNetlogonState,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrSetNetlogonState,
		(ndr_print_function_t) ndr_print_BrowserrSetNetlogonState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrQueryEmulatedDomains",
		sizeof(struct BrowserrQueryEmulatedDomains),
		(ndr_push_flags_fn_t) ndr_push_BrowserrQueryEmulatedDomains,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrQueryEmulatedDomains,
		(ndr_print_function_t) ndr_print_BrowserrQueryEmulatedDomains,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"BrowserrServerEnumEx",
		sizeof(struct BrowserrServerEnumEx),
		(ndr_push_flags_fn_t) ndr_push_BrowserrServerEnumEx,
		(ndr_pull_flags_fn_t) ndr_pull_BrowserrServerEnumEx,
		(ndr_print_function_t) ndr_print_BrowserrServerEnumEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const browser_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\browser]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array browser_endpoints = {
	.count	= 3,
	.names	= browser_endpoint_strings
};

static const char * const browser_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array browser_authservices = {
	.count	= 1,
	.names	= browser_authservice_strings
};


const struct ndr_interface_table ndr_table_browser = {
	.name		= "browser",
	.syntax_id	= {
		{0x6bffd098,0xa112,0x3610,{0x98,0x33},{0x01,0x28,0x92,0x02,0x01,0x62}},
		NDR_BROWSER_VERSION
	},
	.helpstring	= NDR_BROWSER_HELPSTRING,
	.num_calls	= 12,
	.calls		= browser_calls,
	.endpoints	= &browser_endpoints,
	.authservices	= &browser_authservices
};

