#!/usr/local/bin/python

from saml1 import *

class CyclotomicClass:

  def __init__(self, literal):
    self.dict = {}
    self.X = literal

  def __getitem__(self, number):
    # Already computed ?
    if self.dict.has_key(number):
      return self.dict[number]

    # No, compute it
    result = self.X.pow(number) - 1
    for i in range(1,number):
      if (number % i) == 0:
        result = result / self[i]

    # Memoize the result
    self.dict[number] = result
    return result

def test(list):
  model = Mathnode(ST_INTEGER,'0').cast(ST_APOLY)
  X = model.parse('X')
  CCX = CyclotomicClass(X)
  for n in list:
    print `n` + '\t' + `CCX[n]`

if __name__ == '__main__':
  test((1,2,3,4,5,6,20,30,60,100))
  print MnAllocStats()
