// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __text_h__
#define __text_h__

#include "marker.h"

class Text : public Marker {
 private:
  Matrix flip;        // non iis needs a flip in Y

 private:
  void render(Drawable, const Matrix&, double, RenderMode);
  void drawText(Drawable, const Matrix&);
  void drawRotText(Drawable, const Matrix&);

 public:
  Text(const Text&);
  Text(FrameBase* parent, const Vector& ctr, double a,
       const char* clr, int w, const char* f, 
       const char* t, unsigned short prop, const char* c, 
       const List<Tag>& tag);

  Marker* dup() {return new Text(*this);}
  void updateBBox();

  void editBegin(int) {}
  void edit(const Vector& v, int h) {}
  void editEnd() {}

  void ps(int);
  void draw(Drawable);
  void drawXOR();
  void drawMagnifier(const Matrix&);
  void listProperties(ostream&, char);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
