// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

%{
#define YYPARSE_PARAM pn
#define PN ((Panner*)pn)
#define YYDEBUG 1

#include <stdlib.h>
#include "panner.h"

extern int pnlex(void);
extern void pnerror(const char*);

%}

%union {
  float real;
  int integer;
  char str[256];
}

%type <real> numeric
%type <integer> yesno

%token <integer> INT
%token <real> REAL
%token <str> STRING

%token BBOX_
%token BEGIN_
%token CLEAR_
%token COMPASS_
%token DEBUG_
%token END_
%token FALSE_
%token GET_
%token HEIGHT_
%token HIDE_
%token HIGHLITE_
%token IMAGE_
%token INVALID_
%token MOTION_
%token N_
%token NO_
%token OFF_
%token ON_
%token PAN_
%token POINT_
%token RESET_
%token SHOW_
%token SIZE_
%token TRUE_
%token TO_
%token UPDATE_
%token VERSION_
%token WARP_
%token WCS_
%token WIDTH_
%token Y_
%token YES_

%%

command : DEBUG_ debug

	| BBOX_ bbox
	| CLEAR_ {PN->updateCmd(0);}
	| IMAGE_ COMPASS_ yesno {PN->setImageCompassCmd($3);}
	| GET_ get
	| HIDE_ {PN->hideCmd();}
	| HIGHLITE_ highLite
	| PAN_ pan
	| RESET_ {PN->resetCmd();}
	| SHOW_ {PN->showCmd();}
	| UPDATE_ update
	| VERSION_ {PN->msg("Panner 1.0");}
	| WARP_ numeric numeric {PN->warpCmd(Vector($2, $3));}
	| WCS_ COMPASS_ yesno {PN->setWCSCompassCmd($3);}
	;

numeric	: REAL {$$=$1;}
	| INT {$$=$1;}
	;

yesno	: INT {$$=($1 ? 1 : 0);}

	| YES_ {$$=1;}
	| Y_ {$$=1;}
	| ON_ {$$=1;}
	| TRUE_ {$$=1;}

	| NO_ {$$=0;}
	| N_ {$$=0;}
	| OFF_ {$$=0;}
	| FALSE_ {$$=0;}
	;

debug	: ON_ {yydebug=1;}
	| OFF_ {yydebug=0;}
	;

bbox	: ON_ {PN->setBBoxCmd(1);}
	| OFF_ {PN->setBBoxCmd(0);}
	;

get	: BBOX_ {PN->getBBoxCmd();}
	| HEIGHT_ {PN->getHeightCmd();}
	| SIZE_ {PN->getSizeCmd();}
	| WIDTH_ {PN->getWidthCmd();}
	;

highLite: numeric numeric {PN->highLiteCmd(Vector($1,$2));}
	| OFF_ {PN->highLiteCmd(0);}
	| ON_ {PN->highLiteCmd(1);}
	;

pan	: BEGIN_ numeric numeric {PN->panBeginCmd(Vector($2,$3));}
	| MOTION_ numeric numeric {PN->panMotionCmd(Vector($2,$3));}
	| END_ numeric numeric {PN->panEndCmd(Vector($2,$3));}
	| TO_ numeric numeric {PN->panToCmd(Vector($2,$3));}
	;

update	: INT {PN->updateCmd($1);}
	| BBOX_ numeric numeric numeric numeric 
	  {PN->updateBBoxCmd(BBox($2,$3,$4,$5));}
	| IMAGE_ COMPASS_ numeric numeric numeric numeric
	  {PN->updateImageCompassCmd(Rotate($3,$4,$5,$6));}
	| WCS_ COMPASS_ updateWCSCompass
	;

updateWCSCompass : numeric numeric numeric numeric 
	  {PN->updateWCSCompassCmd(Vector($1,$2),Vector($3,$4));}
	| INVALID_ {PN->updateWCSCompassCmd();}
	;

%%


