// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue8.h"
#include "util.h"

ColorScaleTrueColor8::ColorScaleTrueColor8(int s,
					   unsigned long red,
					   unsigned long green,
					   unsigned long blue)
  : ColorScale(s)
{
  colors_ = new unsigned char[s];

  int rs,gs,bs;
  unsigned char rm = decodeMask((unsigned char)red, &rs);
  unsigned char gm = decodeMask((unsigned char)green, &gs);
  unsigned char bm = decodeMask((unsigned char)blue, &bs);

  for (int i=0; i<s; i++)
    colors_[i] =
      ((psColors_[i*3]   & bm) >> bs) |  // blue
      ((psColors_[i*3+1] & gm) >> gs) |  // green
      ((psColors_[i*3+2] & rm) >> rs);   // red
}

ColorScaleTrueColor8::~ColorScaleTrueColor8()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor8::LinearScaleTrueColor8(int s, 
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count,
					     unsigned long red,
					     unsigned long green,
					     unsigned long blue) 
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, red, green, blue),
    ColorScale(s) {}

LogScaleTrueColor8::LogScaleTrueColor8(int s,
				       unsigned short* indexCells,
				       unsigned char* colorCells,
				       int count,
				       unsigned long red,
				       unsigned long green,
				       unsigned long blue) 
  : LogScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, red, green, blue),
    ColorScale(s) {}

SquaredScaleTrueColor8::SquaredScaleTrueColor8(int s,
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count,
					       unsigned long red,
					       unsigned long green,
					       unsigned long blue) 
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, red, green, blue),
    ColorScale(s) {}

SqrtScaleTrueColor8::SqrtScaleTrueColor8(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count,
					 unsigned long red,
					 unsigned long green,
					 unsigned long blue) 
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor8(s, red, green, blue),
    ColorScale(s) {}

IISScaleTrueColor8::IISScaleTrueColor8(unsigned short* indexCells,
				       unsigned char* colorCells,
				       int count,
				       unsigned long red,
				       unsigned long green,
				       unsigned long blue) 
  : IISScale(indexCells, colorCells, count), 
    ColorScaleTrueColor8(IISSIZE, red, green, blue),
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor8::HistEquScaleTrueColor8(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count,
					       double* hist, int histsize,
					       unsigned long red,
					       unsigned long green,
					       unsigned long blue) 
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor8(s, red, green, blue),
    ColorScale(s) {}


