// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __projection_h__
#define __projection_h__

#include "baseline.h"

class Projection : public BaseLine {
 public:
  enum Method {SUM,AVERAGE};

 private:
  double width;
  Method method;
  CoordSystem system;
  SkyFrame skyframe;

  void render(Drawable, const Matrix&, RenderMode);

 public:
  Projection(const Projection&);
  Projection(FrameBase* p, const Vector& ptr1, const Vector& ptr2, 
	     double wd,
	     const char* mvcb, const char* delcb,
	     const char* clr, int wth, 
	     const char* fnt, const char* txt, 
	     unsigned short prop, const char* cmt,
	     const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Projection(*this);}

  void updateBBox();

  void edit(const Vector&, int);

  void ps(int);
  int isIn(const Vector&);
  Vector getCenter() {return p1;}

  void set(const Vector&, const Vector&, double, int);
  void setWidth(double);
  double getWidth() {return width;}
  int getMethod() {return method;}

  CoordSystem getSystem() {return system;}
  SkyFrame getSkyFrame() {return skyframe;}
  void setSystem(CoordSystem sys, SkyFrame sky) 
    {system = sys; skyframe = sky;}

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listPost(ostream&, int, int);
};

#endif
