.TH SAOIMAGE 1 "7 July 1998"
.SH NAME
SAOimage 1.23 \- X11 window based, interactive, color or halftone image display
program for astronomical images
.SH SYNOPSIS
.B saoimage
[ \fB-display \fInodename:0.0 \fR]
[ \fB-geometry | -gd \fIgeometry \fR]
.ti +0.5i
[ \fB-pros | +/-imtool | -fits | -dfits | -oif \fR]
.ti +0.5i
[ \fB-u1 | -u2 | -i2 | -i4 | -r4 | -r8 [ \fIwidth height \fR] ] 
.ti +0.5i
[ \fB-byteswap \fR]
[ \fB-skip \fIbytes \fR]
.ti +0.5i
[ \fB-upperleft | -lowerleft \fR]
[ \fB-one | -zero \fR]
[ \fB-rotate \fIcode \fR]
.ti +0.5i
[ \fB-linear \fR| \fB-wrap \fR[ \fIwraps \fR] |
\fB-log \fR[ \fIexponent \fR] | \fB-sqrt \fR[ \fIpower \fR] | \fB-histeq \fR]
.ti +0.5i
[ \fB-min \fIval \fR]
[ \fB-max \fIval \fR]
[ \fB-rmin \fIval \fR]
[ \fB-rmax \fIval \fR]
[ \fB-scalebias \fIscale bias \fR]
.ti +0.5i
[ \fB-palette \fIval \fR]
[ \fB-red | -green | -blue \fR]
.ti +0.5i
[ \fB-vertgraph | -horizgraph \fR]
.ti +0.5i
[ \fB+/-coord \fR]
[ \fB+/-magnifier \fR]
[ \fB-mag \fIval \fR]
.ti +0.5i
[ \fB-panboxav | -panboxsum | -panboxsample | -panboxmax \fR]
.ti +0.5i
[ \fB-idev \fIpipename \fR]
[ \fB-odev \fIpipename \fR]
[ \fB-fbconfig \fIfilename \fR]
.ti +0.5i
[ \fB+/-verbose \fR]
[ \fB-quiet \fR]
[ \fB-lprbuttons \fR]
[ \fB-mtf \fR]
[ \fB-bordercolor \fIcolor \fR]
[ \fB-lfrac \fIhistogram fraction \fR]
[ \fB-wcscom \fIWCS command \fR]
[ \fB-gal | -fk4 | -fk5 \fR]
[ \fB-zf \fIzoom factor\fR]
.ti +0.5i
[ \fIfilename\fR | \fB-name \fIfilename \fR] 
.SH DESCRIPTION
\fISAOimage\fR
is a utility for displaying astronomical images which runs under the
X11 window environment.  Image files can be read directly, or image data
may be passed through a named pipe (Unix) or a mailbox (VMS) from
IRAF display tasks.  \fISAOimage\fR
provides a large selection of options for zooming, panning, scaling,
coloring, pixel readback, display blinking, and region specification.
User interactions are generally performed with the mouse.
.LP
The \fISAOimage\fR
desktop includes, a main image display window, a button menu panel, a
display magnifier, a pan and zoom reference image, and a color bar.
A color table graph window can be brought up by clicking on the color
bar.
.SH WORLD COORDINATE SYSTEMS
\fBsaoimage\fR tracks world coordinate systems as well
as pixel coordinates within the image, if WCS information is present.
Several single character keyboard commands have been added.  \fBc\fR prints
the world coordinate (RA and Dec as hh:mm:ss.sss dd:mm:ss.ss and Lat
Long as dd.ddddd dd.ddddd) and image pixel coordinate, along with the
value of that pixel to standard output.  \fBw\fR executes the command
set by \fB-wcscom\fR, substituting that same world coordinate string for %s.
\fBb\fR prints the world coordinate RA and Dec in the FK4/B1950 system.
\fBj\fR prints the world coordinate RA and Dec in the FK5/J2000 system.
\fBg\fR prints the world coordinates as galactic longitude and latitude.
\fBe\fR prints the world coordinates as ecliptic longitude and latitude.
\fBi\fR prints the world coordinates as the image header defines them.
\fBh\fR toggles between degrees and sexigesimal units for RA and Dec.
.SH OPTIONS
.TP 0.6i
.B -blue
Set the color of all graphics to be blue.
Some inexpensive systems use a monochrome monitor connected to
one of the three color outputs on the computer.  That color must
be specified to make the graphics visible.
.TP 0.6i
\fB-bordercolor \fIcolorname\fR
Specify the color of all subwindow borders.  The color name must be a
recognized X color (there are many).  This is a style issue.
\fB-bc\fR may be used instead of \fB-bordercolor\fR.
.TP 0.6i
.B -byteswap
Switch the bytes order between big-endian and little-endian
order.  This may be needed where data has been copied from
another machine or if there is some confusion about the FITS
file format.  This switch toggles the previous setting.
\fB-bswap\fR may be used instead of \fB-byteswap\fR.
.TP 0.6i
.B +/-coord
Set the coordinate tracking state initially on or off.  In coordinate
tracking, the coordinates of the mouse and value of the pixel under it
are printed in the upper-left text area, above the main display window.
\fB+/-ct\fR can be used instead of \fB+/-coord\fR.
.TP 0.6i
\fB-display \fInodename:0.0\fR
Specify the name of the X display server.  This makes it
possible to run the \fISAOimage\fR program on a machine other than
the one connected to your display screen, with no difference
in appearance or use.  By default, \fISAOimage\fR gets the server name from
the \fBDISPLAY\fR environment variable.  See the \fIxhost\fR manual page
for more details.  The display server cannot be changed once
\fISAOimage\fR is running.
\fB-display\fR may be abbreviated \fB-d\fR.
.TP 0.6i
.B -dfits
Image file is a FITS file (see \fB-fits\fR), but in unexpected byteswapped
order.  The FITS standard is not swapped, but some naive VAX
applications may swap it (see \fB-bswap\fR).
.TP 0.6i
\fB-fbconfig \fIfilename\fR
Specify an alternate frame buffer configuration file for use with IRAF.
By default, the file installed with \fISAOimage\fR (/usr/local/lib/imtoolrc)
is used.
.TP 0.6i
.B -fits
Image file is a FITS file.  If the image filename ends in \fI.fits\fR,
this switch is not necessary.  Only T=SIMPLE array types are
supported.  The header BITPIX card must be 8 (unsigned byte), 16
(signed short), 32 (signed int), -32 (float), -64 (double), or
-16 (unsigned short).  (The last two are not recognized standards).
IEEE floats are not converted if that is not the machine format.
.TP 0.6i
\fB-fk4\fR
If WCS information is available in the image header, track the cursor
in FK4/B1950 right ascension and declination as well as pixel coordinates.
These coordinates, followed by \fIB1950\fR will be fed to an external
program if the \fBw\fR command is used.
.TP 0.6i
\fB-fk5\fR
If WCS information is available in the image header, track the cursor
in FK5/J2000 right ascension and declination as well as pixel coordinates.
These coordinates, followed by \fIJ2000\fR will be fed to an external
program if the \fBw\fR command is used.
.TP 0.6i
\fB-gal\fR
If WCS information is available in the image header, track the cursor
in galactic longitude and latitude as well as pixel coordinates.
These coordinates, followed by \fIgalactic\fR will be fed to an external
program if the \fBw\fR command is used.
.TP 0.6i
\fB-gd \fIgeometry\fR
Specify the size of the image display subwindow and/or the
screen position of \fISAOimage\fR.  The format is a standard X
geometry statement.  This switch works like \fB-geometry\fR, except
that width and height (if given) are applied to the display
subwindow.  The overall \fISAOimage\fR window is sized accordingly.
.TP 0.6i
\fB-geometry \fIgeometry\fR
Specify the size and/or the screen position of \fISAOimage\fR.
The format is a standard X geometry statement.  Both size and
position may be specified, or only the size or the position.
Width and height refer to the dimensions of \fISAOimage\fR's
desktop window (see \fB-gd\fR for sizing just the image display window).
\fI+x\fR and \fI+y\fR refer to the upper left corner in screen coordinates.
\fI-x\fR positions the right edge from the right edge of the screen.
\fI-y\fR would positions the lower edge from the bottom of the screen.
Width and height below a minimum size are defaulted to the minimum.
Specifying the default minimum size (\fB-geometry 0x0\fR) also triggers
\fISAOimage\fR to use smaller dimensions for its internal windows.
Once \fISAOimage\fR is running, use the window
manager's normal size and move mechanisms to make adjustments
to \fISAOimage\fR's main window.
\fB-geometry\fR may be abbreviated \fB-g\fR.
.TP 0.6i
.B -green
Set the color of all graphics to be green.  See \fB-blue\fR.
.TP 0.6i
\fB-histeq\fR may be abbreviated \fB-hi\fR.
Set the scaling mode for histogram equalization.
.TP 0.6i
.B -horizgraph
Use a horizontal auxiliary color graph window, with a color
bar along the bottom.  See \fB-vertgraph\fR.
\fB-hg\fR can be used as a shorthand for \fB-horizgraph\fR.
.TP 0.6i
\fB-i2 \fIwidth height\fR
Image file is a signed short integer array file of the given
dimensions.  If the file is square and has no added padding, the
dimensions are not necessary.
\fB-shortarray \fIwidth height\fR has the same function.
.TP 0.6i
\fB-i4 \fIwidth height\fR
Image file is a signed long integer array file of the given
dimensions.  If the file is square and has no added padding, the
dimensions are not necessary.
\fB-longarray \fIwidth height\fR has the same function.
.TP 0.6i
\fB-idev \fIpipename\fR
Specify the name of the named pipe used for listening.  The
default is /dev/imt1o, which is the default used by IRAF.
See \fB-odev\fR.
.TP 0.6i
.B +/-imtool
Open/close the named input pipe connection and wait for input from IRAF.
When open, \fISAOimage\fR emulates IRAF's \fIimtool\fR.
IRAF's image loading and cursor read-back functions are supported.
Unlike \fIimtool\fR, \fISAOimage\fR has only one frame buffer; IRAF's
frame buffer numbers are ignored.  Listening on the pipe is possible
even while reading image files directly.  The connection may be opened,
closed, or re-opened at any time.  When supported, the default mode is
commonly to start with the IRAF connection open.  See \fB-idev\fR,
\fB-odev\fR, and \fB-pros\fR.
.TP 0.6i
\fB-lfrac \fR[\fIfraction of histogram numerical peak\fR]
Set the linear scaling limits to the values where the pixel
value distribution is at a given fraction of its peak
.TP 0.6i
.B -linear
Set the scaling mode to linear.
.TP 0.6i
\fB-log \fR[\fIexponent for exponential curve\fR]
Set the scaling mode to log (exponential), and set the exponent
for the curve function
.EQ
e sup n
.EN
if given.
.TP 0.6i
.B -lowerleft
First pixel in file represents the lower left of the image,
assuming the lines of input run left to right on the screen.
This is the IRAF standard and the \fISAOimage\fR default.
See \fB-rotate\fR, \fB-upperleft\fR, and \fB-zero\fR.
\fB-lowerleft\fR may be abbreviated \fB-ll\fR.
.TP 0.6i
.B -lprbuttons
Include the button menu in the hardcopy image (only on color
workstations).  The default on color workstations includes the
area above the button panel, but excludes the buttons.
.TP 0.6i
\fB-mag \fImagnification\fR
Set the magnification factor of the magnifier.  This
factor relates the magnifier to the magnification of the
display window.  The default is 4; the magnifier magnifies
the image to 4 times the magnification of the main display
window (but never less than zoom 1 of the original data).
.TP 0.6i
.B +/-magnifier
Set the magnifier tracking state initially on or off.  With magnifier
tracking, the magnifier window is continuously updated to show
a magnification of the image the image under the mouse.
\fB+/-mt\fR can be used instead of \fB+/-magnifier\fR.
.TP 0.6i
\fB-max \fR[\fImax val\fR]
Set the maximum for the image value range used to compute
scaling.  The default is to take the maximum from the image
shown in the display window.
\fB-max\fR with no value resets the
default.  If the maximum value in the displayed image is
lower than the given maximum, the image's maximum vale is
used for the scaling range.
.TP 0.6i
\fB-min \fR[\fImin val\fR]
Set the minimum for the image value range used to compute
scaling.  The default is to take the minimum from the image
shown in the display window. 
\fB-min\fR with no value resets the
default.  If the minimum value in the displayed image is
higher than the given minimum, the image's minimum vale is
used for the scaling range.
.TP 0.6i
.B -mtf
Give the button panel a chiseled look popularized by HP's widget
set.  This appearance may contrast less with other applications
being used at the same time.
.TP 0.6i
\fB-name \fIfilename\fR
This switch is only needed if the filename starts with a number
or might otherwise be recognized as a switch.
.TP 0.6i
\fB-odev \fIpipename\fR
Specify the name of the named pipe used for sending feedback.
The default is /dev/imt1i, which is the default used by IRAF.
See \fB-idev\fR.
.TP 0.6i
.B -oif
Image file is an IRAF image header file in OIF format.  If the
image filename ends in \fI.imh\fR, this switch is not necessary.
IRAF STF and QPOE formats are not supported.  Complex data cannot be
handled.  The data must have at least 2 dimensions.  Only the first
plane of multidimensional images is read.  The data file is read
directly by \fISAOimage\fR (see \fB-imtool\fR and \fB-pros\fR).
.TP 0.6i
.B -one
The file coordinate of the first pixel is (1,1).  The real coordinates
of the center of the first pixel are (1.0,1.0).  This is
the IRAF standard and the default for \fISAOimage\fR.
The second pixel is (2,1).  See \fB-zero\fR.
.TP 0.6i
\fB-palette \fInumber\fR
Specify the number of read/write color cells to reserve.  On
color workstations, \fISAOimage\fR
reserves color cells in the default colormap for its own use. 
\fISAOimage\fR reserves as many color cells as it can get, up to the number
given (the default is 200).  If the number given is negative,
\fISAOimage\fR comes up in overlay mode, using 1/2 + 2 of the color
cells for overlays and graphics.  In verbose mode (see \fB-verbose\fR),
\fISAOimage\fR tells you how many cells it is able to use for display
colors.  This number can be re-entered at run-time, unless
\fB-palette 1\fR is given, in which case \fISAOimage\fR stays in halftone mode.
\fB-p\fR is an acceptable shorthand for \fB-palette\fR.
.TP 0.6i
\fB-panboxav | -panboxsum | -panboxsamp | -panboxmax\fR
These switches select the kind of image reduction used to fit
a picture of the entire image into the pan window.  Each pixel
is computed from a block of image pixels by averaging, summing,
sampling, or taking the maximum.  The default is to show the
maximum from each block.  When zooming in the main display
involves reduction, subsampling is always used.
.TP 0.6i
.B -pros
Virtually identical to the \fB+imtool\fR switch.
The difference occurs when the user writes the saved
regions to a disk file.  \fIimtool\fR emulation includes writing
only an IRAF list file giving center coordinates only.  With
\fB-pros\fR, \fISAOimage\fR's normal region descriptor file will be
written in place of the simpler list file.  One may switch between
this mode and \fB+imtool\fR, or close the IRAF connection with
\fB-imtool\fR.
.TP 0.6i
.B -quiet
Disable verbose mode;\fB-q\fR may also be used.  See \fB-verbose\fR.
.TP 0.6i
\fB-r4 \fIwidth height\fR
Image file is a real*4 array file of the given dimensions.
If the file is square and has no added padding, the dimensions
are not necessary.
\fB-floatarray \fIwidth height\fR has the same function.
.TP 0.6i
\fB-r8 \fIwidth height\fR
Image file is a real*8 array file of the given dimensions.
If the file is square and has no added padding, the dimensions
are not necessary.
\fB-doublearray \fIwidth height\fR has the same function.
.TP 0.6i
.B -red
Set the color of all graphics to be red.  See \fB-blue\fR.
.TP 0.6i
\fB-rmax \fR[\fImax val\fR]
Set maximum value for reading from the image file.  This value
is used as the maximum value when images are pre-scaled to fit
the 16 bit (signed short) working buffer.
.TP 0.6i
\fB-rmin \fR[\fImin val\fR]
Set minimum value for reading from the image file.  This value
is used as the minimum value when images are pre-scaled to fit
the 16 bit (signed short) working buffer.
.TP 0.6i
\fB-rotate \fI1,2,or 3\fR
Rotate the image 90, 180, or 270 degrees (respectively) before
displaying it.  Rotation is applied after conversion to a lower
left coordinate system (\fB-ll\fR) if such conversion is also requested.
This is useful for images when the CCD was not mounted North-up.
\fB-rot\fR can be used as a shorthand for \fB-rotate\fR.
.TP 0.6i
\fB-scalebias \fIscale bias\fR
The data in the image file should be scaled and biased to get
the true image value (TrueValue = (scale * FileValue) + bias).
This cannot be used with the
\fB-fits\fR image type (scale and bias
are in the FITS header), nor with
\fB-imtool\fR or \fB-pros\fR (they are passed by IRAF).
\fB-sb\fR is a shorthand for \fB-scalebias\fR.
.TP 0.6i
\fB-skip \fIbytes\fR
Skip over the given number of bytes at the head of the file before
reading	data.  This is used to skip header information or the first
image if two images are stored in one file.
\fB-header\fR and \fB-sk\fR are aliases for \fB-skip\fR.
.TP 0.6i
\fB-sqrt \fR[\fIinverse of exponent for geometric curve\fR]
Set the scaling function to square root (geometric), and set the
inverse of the exponent for the
.EQ
x sup {1/n}
.EN
curve, if given.
.TP 0.6i
\fB-u1 \fIwidth height\fR
Image file is an unsigned byte array file of the given dimensions.
If the file is square and has no added padding, the dimensions
are not necessary.
\fB-chararray \fIwidth height\fR has the same function.
.TP 0.6i
\fB-u2 \fIwidth height\fR
Image file is a unsigned short integer array file of the given
dimensions.  If the file is square and has no added padding, the
dimensions are not necessary.
\fB-ushortarray \fIwidth height\fR has the same function.
.TP 0.6i
.B -upperleft
First pixel in file represents the upper left of the image,
assuming the lines of input run left to right on the screen
(see \fB-rotate\fR and \fB-lowerleft\fR).
This switch does not override IRAF WCS image coordinates.
\fB-upperleft\fR may be abbreviated \fB-ul\fR.
.TP 0.6i
.B +/-verbose
Set \fIverbose\fR mode on or off.  In verbose mode,
informative statements are
printed to the terminal window when various actions are taken.
The default mode is to be verbose.
\fB+/-v\fR can be used instead of \fB+/-verbose\fR.
.TP 0.6i
.B -vertgraph
Use a vertical auxiliary color graph window, with a color bar
along the left side.  See \fB-horizgraph\fR.
\fB-vg\fR can be used as a shorthand for \fB-vertgraph\fR.
.TP 0.6i
\fB-wcscom \fR[\fIformat for command to be executed\fR]
Set the command to be executed when the \fBw\fR key is struck, where
the world coordinates are substituted for %s in the string.  Underscores
should be used instead of spaces.
.TP 0.6i
\fB-wrap \fR[\fInumber of wraps within scaling range\fR]
Set the scaling mode to wrapped linear, and set the number of
wraps for this mode, if given.
.TP 0.6i
.B -zero
The file coordinate of the first pixel is (0,0).  The real coordinates
of the center of the first pixel are (0.5,0.5) which makes the
very edge (0,0).  This is the standard coordinate system for image
displays, but not the default for \fISAOimage\fR.
The second pixel is indexed (1,0).  See \fB-one\fR.
.TP 0.6i
.B -zf \fIzoom factor\fR
Zoom the initial display of the image by \fIzoom factor\fR.  A number
larger than one makes the image larger by that factor, using that many
display pixels per image pixel.  A fractional \fIzoom factor\fR
displays that the image with that fraction of a display pixel per image
pixel.
.SH USAGE
Refer to the \fISAOimage User Manual\fR
for detailed descriptions of all functions.
.LP
Most control actions take place within the context of a mode.  Modes
are selected by clicking on menu buttons in the top row of the button
panel.  Each menu mode brings up its own submenu buttons (the lower
row in the button panel) for mode specific selections.  Actions and
submodes are selected by clicking on buttons in the submenu row of
the menu panel.
.LP
The mouse controls specific functions in both the main display
window and the pan/zoom window.  In the main display window, the
function of the mouse is determined by the mode and submode
selections from the button menu.  The function can also be recognized
by the appearance of the mouse pointer icon.
.LP
The button interface is designed to be user friendly.  The user
is encouraged to try any and all buttons to become familiar with
their functions.  To exit, use the
\fIQUIT\fR button in the
\fIetc\fR submenu (click on \fIetc\fR, then click on \fIQUIT\fR).
.SS Reading images
To read an image directly from a file, give its name anywhere on the
command line.  The
.B -name
switch is needed only when the image file name could be mistaken for a
number or switch.  \fISAOimage\fR recognizes the \fI.fits\fR and \fI.imh\fR
filename suffixes as belonging to FITS and IRAF OIF
files.  All other file types must be specified by an appropriate file type
switch.
.LP
Raw array file types must be specified by an array data type switch
(\fB-u1\fR, \fB-u2\fR, \fB-i2\fR, \fB-i4\fR, \fB-r4\fR, \fB-r8\fR)
followed by width and height dimensions.
To skip over a file header, use the \fB-sk\fR
switch followed by the number of bytes.  This can also be used to skip
over entire images, if more than one are stored in the same file.
.SS Use with IRAF
To emulate \fIimtool\fR
and communicate with IRAF tasks, use either the \fB-imtool\fR or \fB-pros\fR
switch.  The two switches indicate which file format to use in recording
saved cursors or regions.  With \fB-imtool\fR,
an IRAF list file containing only center coordinates is used (like
that of \fIimtool\fR).  With \fB-pros\fR,
a file containing a full description of the saved cursors and their
dimensions is used.  The latter file can be read by tasks in the
IRAF PROS
spatial package for making image masks and performing image analyses.
Both file types are ASCII and can be read and edited by the user.
In either case, the file is not actually written until the user
clicks on the \fIwrite\fR button in the \fIregion\fR
submenu.  Both file types can be read back to reproduce the saved
cursors.
.SS New command input
A new command line can be entered at any time, by selecting the
\fInew\fR button in the \fIetc\fR submenu or striking the
\fIN\fR key on the keyboard.  This allows the user to read in new images,
change in and out of \fB-imtool\fR or \fBpros\fR
mode, set new scaling parameters, or change the number of reserved
display color cells.  Most command line switches (except
\fB-d\fR, \fB-g\fR, \fB-gd\fR, \fB-red\fR, \fB-green\fR, \fB-blue\fR,
and \fB-vertgraph\fR) will be accepted at any
time.
.LP
When a new command line is requested, the previous command line is
presented in an emacs-like popup editor for editing.
Ctrl-N clears the previous line.  Striking the RETURN
key enters the line in the popup window as the new command.
Ctrl-C returns with no action taken.
.SS Using the mouse
Most mouse interactions are based on mouse dragging (holding a button
down while moving the mouse).  The user should try clicking and/or
dragging the mouse in each subwindow to become familiar with its
functions.  Modes selected in the button panel determine the
response to the mouse buttons in the main display window.
.LP
In
.B Scale
mode, the mouse buttons control blinking of displays (saved by
clicking with the same mouse button in the \fIblink\fR submenu button).
.LP
In
.B Color
mode, mouse dragging stretches and shifts the color map as per
the \fIcontrast/bias, threshold/saturation,\fR and \fIgamma\fR
submenu selections.
.LP
In the
.B color graph window,
color table vertexes may be added or moved by clicking or dragging
with the LEFT (red), MIDDLE (green), or RIGHT (blue) mouse buttons.
The graph will update continuously only if \fItracking\fR is turned on.
.LP
In
.B Cursor
mode, the mouse controls the size and locations of cursors.  The
rule is: LEFT button for position, MIDDLE button for size, and
RIGHT button for angle or deletion (depending on the cursor).
.SS Cursors
For \fIbox\fR and \fIellipse\fR
cursors, MIDDLE button sizing is restricted depending on whether
dragging started on a side or near a corner.
.LP
With the \fIpoint\fR
cursor, the LEFT and MIDDLE buttons save the current mouse pointer
position with a + or - indication, while the RIGHT button deletes
saved points.
.LP
For the \fIpolygon\fR
cursor, the MIDDLE button adds or moves a single vertex, while
the RIGHT button will delete vertexes.  The LEFT button moves the
whole polygon.
.LP
When \fIannuli\fR is set for a \fIbox, circle,\fR or \fIellipse\fR cursor,
the MIDDLE button adds or resizes an annulus, while the RIGHT
button deletes annuli.
.LP
For manipulating cursors, the \fIovlay\fR selection in the \fIColor\fR
submenu, enables the cursor to track smoothly as an overlay
graphic.  The \fIregion\fR
submenu button brings up another submenu with selections to
display, review, and edit the saved regions, and read from or
write to disk files.
.SS Pan and zoom
In \fIPan\fR
mode, and in the pan window (regardless of mode), the LEFT button
selects the center of the image, while the MIDDLE button selects
the edge of the display, zoomed from the given center.  When either
function is dragged, the rectangle in the pan window shows the
area that would appear in the display when the button is released.
.SS Keys
In the cursor mode, the \fIS\fR and \fIE\fR
keys, save the current cursor in a region list, while the \fID\fR
and DELETE keys can be used to forget a region.
At any time, with the pointer in the display or pan windows, the
\fIT\fR key prints a table of pixel values at the pointer position to
\fIstdout\fR.  The 4 arrow keys can be used for fine movement of the
pointer in any window.  The SHIFT and SHIFT LOCK keys will
reverse the magnifier window, color graph window and coordinate
tracking status.  The \fIN\fR
key summons the pop-up editor for new command input.  The \fIA\fR
key raises and redraws all of \fISAOimage\fR's windows.
.SH BUGS
\fISAOimage\fR does not allocate its own colormap and thus fails with static
color (i.e. NeWS) window managers.  X resource settings of a
user's default preferences are not read.
.SH ONLINE HELP
Additional information about \fISAOimage\fR is available on the World-Wide
Web at http://tdc-www.harvard.edu/software/saoimage.html
