
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_Comment.cc,v 1.2 1999/03/09 20:49:02 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_Comment.hh"
#include "savant.hh"
#include <stdlib.h>
#include "error_func.hh"
#include <strstream.h>
#include "IIR_Comment.hh"

IIRBase_Comment::IIRBase_Comment(){
  text = NULL;
  text_length = 0;
}

IIRBase_Comment::~IIRBase_Comment(){
  delete text;
}


IIR_Comment *
IIRBase_Comment::get( IIR_Char *text, IIR_Int32 text_length){
  ASSERT( text_length >= 0 );
  
  IIRBase_Comment *retval = new IIR_Comment();
  retval->text = new IIR_Char[ text_length ];
  
  int i;
  for( i = 0; i < text_length; i++ ){
    retval->text[i] = text[i];
  }
  
  retval->text_length = text_length;

  return (IIR_Comment *)retval;
}

IIR_Char *
IIRBase_Comment::get_text(){
  return text;
}

IIR_Int32 
IIRBase_Comment::get_text_length(){
  return text_length;
}

void 
IIRBase_Comment::set_element( IIR_Int32 subscript, IIR_Char value){
  _check_bounds( subscript );
  text[ subscript ] = value;
}

IIR_Char 
IIRBase_Comment::operator[]( IIR_Int32 subscript ){
  _check_bounds( subscript );
  return text[ subscript ];
}

void 
IIRBase_Comment::release(){
  delete this;
}

void 
IIRBase_Comment::_check_bounds( IIR_Int32 subscript ){
  if( subscript < 0 || subscript > text_length ){
    ostrstream err;
    err << "Error! IIRBase_Comment array subscript out of bounds!"
	<< ends;
    
    report_error( this, err );

    abort();
  }  
}

void
IIRBase_Comment::set_text( IIR_Char *txt, IIR_Int32 text_len) {
  text = txt;
  text_length = text_len;
}


