// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ConcurrentSelectedSignalAssignment.cc,v 1.2 1999/03/09 20:49:14 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ConcurrentSelectedSignalAssignment.hh"
#include "savant.hh"

IIRBase_ConcurrentSelectedSignalAssignment::IIRBase_ConcurrentSelectedSignalAssignment(){
  set_postponed( FALSE );
  set_target( NULL );
  set_expression( NULL );
  set_guarded( FALSE );
  set_delay_mechanism( IIR_INERTIAL_DELAY );
  set_reject_time_expression( NULL );
}


IIRBase_ConcurrentSelectedSignalAssignment::~IIRBase_ConcurrentSelectedSignalAssignment() {}


void 
IIRBase_ConcurrentSelectedSignalAssignment::set_postponed( IIR_Boolean postponed ){
  this->postponed = postponed;
}

IIR_Boolean   
IIRBase_ConcurrentSelectedSignalAssignment::get_postponed(){
  return postponed;
}

void 
IIRBase_ConcurrentSelectedSignalAssignment::set_target(IIR *target ){
  this->target = target;
}

IIR * 
IIRBase_ConcurrentSelectedSignalAssignment::get_target(){
  return target;
}

void 
IIRBase_ConcurrentSelectedSignalAssignment::set_expression(IIR *expr ){
  expression = expr;
}

IIR * 
IIRBase_ConcurrentSelectedSignalAssignment::get_expression(){
  return expression;
}

void 
IIRBase_ConcurrentSelectedSignalAssignment::set_guarded( IIR_Boolean guarded ){
  this->guarded = guarded;
}

IIR_Boolean 
IIRBase_ConcurrentSelectedSignalAssignment::get_guarded(){
  return guarded;
}

void  
IIRBase_ConcurrentSelectedSignalAssignment::set_delay_mechanism( IIR_DelayMechanism delay_mechanism ){
  this->delay_mechanism = delay_mechanism;
}

IIR_DelayMechanism  
IIRBase_ConcurrentSelectedSignalAssignment::get_delay_mechanism(){
  return delay_mechanism;
}

void 
IIRBase_ConcurrentSelectedSignalAssignment::set_reject_time_expression( IIR *reject_time_expression ){
  this->reject_time_expression = reject_time_expression;
}

IIR *
IIRBase_ConcurrentSelectedSignalAssignment::get_reject_time_expression(){
  return reject_time_expression;
}
