
#ifndef IIRBASE_FLOATING_POINT_LITERAL_HH
#define IIRBASE_FLOATING_POINT_LITERAL_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_FloatingPointLiteral.hh,v 1.2 1999/03/09 20:50:05 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Literal.hh"

class IIR_FloatingPointLiteral;

class IIRBase_FloatingPointLiteral : public IIR_Literal {
  friend class VHDLParser;

public:
  IIR_Kind get_kind() { return IIR_FLOATING_POINT_LITERAL; }
  IIR_Char *get_kind_text() { return "IIR_FloatingPointLiteral"; }

  static IIR_FloatingPointLiteral* get(IIR_Int32, IIR_Char*,  IIR_Int32,
				       IIR_Char*, IIR_Int32);
  void release();

  IIR_Char* print(IIR_Int32);

  void _set_base(IIR_Int32);
  IIR_Int32 _get_base();
  void _set_mantissa(IIR_Char*, IIR_Int32);
  IIR_Char* _get_mantissa();
  IIR_Int32 _get_mantissa_length();
  void _set_exponent(IIR_Char*, IIR_Int32);
  IIR_Char* _get_exponent();
  IIR_Int32 _get_exponent_length();

protected:
  IIRBase_FloatingPointLiteral();
  virtual ~IIRBase_FloatingPointLiteral() = 0;
    
private:
  IIR_Int32 base;
  IIR_Char *mantissa;
  IIR_Int32 mantissa_length;
  IIR_Char *exponent;
  IIR_Int32 exponent_length;
};
#endif
