
#ifndef IIRBASE_VARIABLE_DECLARATION_HH
#define IIRBASE_VARIABLE_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_VariableDeclaration.hh,v 1.2 1999/03/09 20:52:26 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_ObjectDeclaration.hh"

class IIRBase_VariableDeclaration : public IIR_ObjectDeclaration {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  IIR_Kind get_kind() {
    return IIR_VARIABLE_DECLARATION;
  }
  IIR_Char *get_kind_text() {
    return "IIR_VariableDeclaration";
  }

  void set_value(IIR* value);
  IIR* get_value();

protected:
  
  IIRBase_VariableDeclaration();
  virtual ~IIRBase_VariableDeclaration() = 0;
    
private:
  
  IIR* value;

};

#endif
