// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ChoiceList.cc,v 1.2 1999/03/09 20:53:22 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ChoiceList.hh"
#include "IIR_Choice.hh"

IIRScram_ChoiceList::~IIRScram_ChoiceList() {}


void 
IIRScram_ChoiceList::_publish_vhdl(ostream &_vhdl_out) {
  register int numberOfChoices = 1;
  IIR_Choice *choice = first();
  choice->_publish_vhdl(_vhdl_out);
  choice = successor(choice);
  while(numberOfChoices < num_elements()){
    _vhdl_out << " | ";
    choice->_publish_vhdl(_vhdl_out);
    numberOfChoices++;
    choice = successor(choice);
  }
}

void
IIRScram_ChoiceList::_publish_cc(){
  register int numberOfChoices = 1;
  IIR_Choice *choice = first();
  if(choice->get_value()->_is_subtype()){
    _cc_out << "else if ((SAVANT_BOOLEAN_TRUE == ";
  }
  else {
     _cc_out << "else if ((SAVANT_BOOLEAN_TRUE == savantEqual(";
     _current_publish_node->_publish_cc();
     _cc_out << ", ";
  }
  choice->_publish_cc();
  if(choice->get_value()->_is_subtype()){
    // don't do anything
  }
  else {
    _cc_out << "))";
  }
  choice = successor(choice);
  while(numberOfChoices < num_elements()){
    if(choice->get_value()->_is_subtype()){
      _cc_out << " || (SAVANT_BOOLEAN_TRUE == ";
    }
    else {
      _cc_out << " || (SAVANT_BOOLEAN_TRUE == savantEqual(";
      _current_publish_node->_publish_cc();
      _cc_out << ", ";
    }
    choice->_publish_cc();
    if(choice->get_value()->_is_subtype()){
      // don't do anything
    }
    else {
      _cc_out << "))";
    }
    numberOfChoices++;
    choice = successor(choice);
  }
}



void
IIRScram_ChoiceList::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  IIR_Choice* choice;
  choice = first();
  while(choice != NULL) {
    choice->_build_sensitivity_list(sensitivity_list);
    choice = this->successor(choice);
  }
}


