// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ComponentDeclaration.cc,v 1.4 1999/07/23 21:07:56 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ComponentDeclaration.hh"
#include <strstream.h>
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_Identifier.hh"
#include "resolution_func.hh"
#include "symbol_table.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_InterfaceList.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_AttributeSpecification.hh"

IIRScram_ComponentDeclaration::~IIRScram_ComponentDeclaration() {}


set<IIR_Declaration> *
IIRScram_ComponentDeclaration::_find_declarations( IIR_Name *to_find ){
  set<IIR_Declaration> *retval = new set<IIR_Declaration>;

  set<IIR_Declaration> *current_set = local_generic_clause._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
  }
  
  current_set = local_port_clause._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
  }
  
  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }
  
  return retval;
}


void 
IIRScram_ComponentDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " component ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";

  if(local_generic_clause.num_elements() != 0) {
    _vhdl_out << " generic( ";
    local_generic_clause._publish_vhdl(_vhdl_out);
    _vhdl_out << " );\n";
  }

  if(local_port_clause.num_elements() != 0) {
    _vhdl_out << " port( ";
    local_port_clause._publish_vhdl(_vhdl_out);
    _vhdl_out << " );\n";
  }

  _vhdl_out << " end component ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}


IIR_PortList *
IIRScram_ComponentDeclaration::_get_port_list(){
  return &local_port_clause;
}

IIR_TypeDefinition *
IIRScram_ComponentDeclaration::_get_port_type( int port_num ){
  ASSERT( port_num < local_port_clause.num_elements() );
  IIR_Declaration *port_element 
    = (IIR_Declaration *)local_port_clause.get_nth_element( port_num );

  ASSERT( port_element->_is_iir_declaration() == TRUE );

  return port_element->_get_subtype();
}


IIR_GenericList *
IIRScram_ComponentDeclaration::_get_generic_list(){
  return &local_generic_clause;
}


void 
IIRScram_ComponentDeclaration::_make_interface_visible( symbol_table *sym_tab ){
  sym_tab->make_visible( &local_generic_clause );
  sym_tab->make_visible( &local_port_clause );
}


IIRScram_Declaration::declaration_type 
IIRScram_ComponentDeclaration::_get_type(){
   return COMPONENT;
}

void
IIRScram_ComponentDeclaration::_publish_cc_binding_name(ostream& outstream) {
  outstream << "SCOM";
  _get_declarator()->_print(outstream);
}


void
IIRScram_ComponentDeclaration::_publish_cc_elaborate() {
  _publish_cc_headerfile();
  _publish_cc_ccfile();
}


void
IIRScram_ComponentDeclaration::_publish_cc_headerfile() {

  ostrstream filename;

  filename << "SCOM";
  _get_declarator()->_print(filename);
  filename << "_elab" << ends;
  _cc_out.set_file(TRUE, filename.str(), ".hh");
  _cc_out <<"#ifndef" << "  __" << filename.str() << "__HH__" <<endl;
  _cc_out <<"#define" << "  __" << filename.str() << "__HH__" <<endl;
  _cc_out <<"#include \"_savant_entity_elab.hh\"" << endl;
  _cc_out <<"#include \"SignalNetinfo.hh\"" << endl;
  _cc_out << "#include \"standard.hh\"" << endl;

  if(local_generic_clause.num_elements() > 0) {
    local_generic_clause._publish_cc_headers();
  }
  if(local_port_clause.num_elements() > 0) {
    local_port_clause._publish_cc_headers();
  }
  
  _publish_cc_class();
  _cc_out << "#endif" << endl;
}

void
IIRScram_ComponentDeclaration::_publish_cc_class() {

  _cc_out <<"class ";
  this->_publish_cc_binding_name();
  _cc_out << "_elab : public ";
  _cc_out <<"_savant_entity_elab {\n" ;
  _cc_out << "public:\n";

  _cc_out << "\n\n";

  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";

  if(local_generic_clause.num_elements() > 0) {
    this->_publish_cc_binding_name();    
    _cc_out << "_elab(\n";
    local_generic_clause._publish_generic_parameter_list();
    _cc_out << " );\n";
  }

  _cc_out << "~";
  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";

  _cc_out << "\n\n";

  local_generic_clause._publish_cc_elaborate();
  local_port_clause._publish_cc_elaborate();
  _cc_out << " _savant_entity_elab* boundedEntity;\n";
  _cc_out << "\n\n";

  _cc_out << "void instantiate();\n";
  _cc_out << "void createNetInfo();\n";
  _cc_out << "void connect(int, int, ...);\n";
  _cc_out << "void partition() {}\n";
  _cc_out << "void getBoundEntityInfo();" << endl;
  _cc_out << "};\n";
}

void
IIRScram_ComponentDeclaration::_publish_cc_ccfile() {

  ostrstream filename;
  PublishedUnit oldUnit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(DUMMY_ENTITY_DECL);
  
  filename << "SCOM";
  _get_declarator()->_print(filename);
  filename << "_elab" << ends;
  _cc_out.set_file(TRUE, filename.str(), ".cc");

  _cc_out << "#include \"" << filename.str() << ".hh\"\n";
  _cc_out << "extern OBJTYPE* proc_array[];\n";
  _publish_cc_constructor();
  _publish_cc_destructor();
  _publish_cc_instantiate();
  _publish_cc_createNetInfo();
  _publish_cc_connect();
  //  _publish_cc_partition();
  _publish_cc_getboundentityinfo();

  _set_currently_publishing_unit(oldUnit);
}

void
IIRScram_ComponentDeclaration::_publish_cc_constructor() {

  _publish_cc_constructor_with_no_arguments();
  if (local_generic_clause.num_elements() > 0) {
    _publish_cc_constructor_with_arguments();
  }
}

void 
IIRScram_ComponentDeclaration::_publish_cc_constructor_with_no_arguments() {
  int numPortClause = local_port_clause.num_elements();

  this->_publish_cc_binding_name();
  _cc_out << "_elab::";
  this->_publish_cc_binding_name();
  _cc_out << "_elab()";

  if((numPortClause > 0) || (local_generic_clause.num_elements() > 0 )) {
    _cc_out << ":\n";
  }
  local_generic_clause._publish_generic_init();
  if(local_generic_clause.num_elements() > 0 ) {
    if(local_port_clause.num_elements() > 0){
      _cc_out << ",\n";
    }
  }

  local_port_clause._publish_cc_port_init();
  _cc_out << " {" << endl
	  << "  boundedEntity = NULL;" << endl
	  << "}\n";
}


void 
IIRScram_ComponentDeclaration::_publish_cc_constructor_with_arguments() {
  int numPortClause = local_port_clause.num_elements();

  this->_publish_cc_binding_name();
  _cc_out << "_elab::";
  this->_publish_cc_binding_name();
  _cc_out << "_elab(\n";
  local_generic_clause._publish_generic_parameter_list();
  _cc_out << " )";

  _cc_out << ":\n";
  local_generic_clause._publish_generic_init_by_arguments();
  if(numPortClause > 0) {
    _cc_out << ",\n";
    local_port_clause._publish_cc_port_init();
  }

  _cc_out << " {"
	  << "  boundedEntity = NULL;" << endl
	  << "}\n";
}


void
IIRScram_ComponentDeclaration::_publish_cc_destructor() {

  this->_publish_cc_binding_name();
  _cc_out << "_elab ";
  _cc_out << "::~";
  this->_publish_cc_binding_name();
  _cc_out << "_elab() {\n";
  _cc_out << "delete boundedEntity;\n";
  _cc_out << "}\n";
}


void
IIRScram_ComponentDeclaration::_publish_cc_instantiate() {

  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::instantiate() {\n";
  _cc_out << "if(boundedEntity != NULL) {" << endl;
  _cc_out << "  boundedEntity->instantiate();\n";
  _cc_out << "}" << endl;
  _cc_out << "}\n";
}


void
IIRScram_ComponentDeclaration::_publish_cc_createNetInfo() {

  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::createNetInfo() {\n";
  _cc_out << "if(boundedEntity != NULL) {" << endl;
  _cc_out << "  boundedEntity->createNetInfo();\n";
  _cc_out << "}" << endl;
  _cc_out << "}\n";
}


void
IIRScram_ComponentDeclaration::_publish_cc_connect() {
  ostrstream connectparams;

  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::connect(int inputsignals, int outputsignals, ...) {\n";
  _cc_out << "  int NoofSignals = inputsignals + outputsignals;\n";
  _cc_out << "  va_list ap;\n";
  _cc_out << "  opFanoutinfo = (VHDLType**)new char[NoofSignals * sizeof(VHDLType*)];\n";
  _cc_out << "  int currentSignal = 0;\n\n";
  
  _cc_out << "va_start(ap, outputsignals);\n";
  _cc_out << "for(int i=0; i <NoofSignals; i++) {\n";
  _cc_out << "  opFanoutinfo[i] = va_arg(ap, VHDLType*);\n";
  _cc_out << "}\n";
  _cc_out << "va_end(ap);\n\n";

  IIR_SignalInterfaceDeclaration* portelement;
  IIR_Mode mode;
  int index = 0;
  int first = 0;

  _cc_out << " if (inputsignals > 0) {\n";
  
  portelement = local_port_clause.first();
  for(; portelement != NULL; ) {
    mode = portelement->get_mode();
    if((mode == IIR_IN_MODE)) {
      first = 1;
      _cc_out << "  currentSignal = checkSetSourceInfo(";
      portelement->_publish_cc_elaborate();
      _cc_out << ", currentSignal, opFanoutinfo);\n";
      index++;
    }
    portelement = local_port_clause.successor(portelement);
  }
  
  _cc_out << "}\n";

  _cc_out << "  if(outputsignals > 0) {\n";

  portelement = local_port_clause.first();
  for(; portelement != NULL; ) {
    mode = portelement->get_mode();
    if (mode == IIR_INOUT_MODE) {
      first = 1;
      _cc_out << "  checkAdd(";
      portelement->_publish_cc_elaborate(); 
      _cc_out << ", currentSignal, opFanoutinfo);";
      
      _cc_out << "  currentSignal = checkSetSourceInfo(";
      portelement->_publish_cc_elaborate(); 
      _cc_out << ", currentSignal, opFanoutinfo);\n";
      
      index++;
    } else if ( mode == IIR_OUT_MODE ){
      first = 1;
      _cc_out << "  currentSignal = checkAdd(";
      portelement->_publish_cc_elaborate(); 
      _cc_out << ", currentSignal, opFanoutinfo);\n";
      index++;
    } else if ( mode != IIR_IN_MODE ){
      cerr << "IIRScramComponentDeclaration::_publish_cc_connect Invalid mode in the port " << endl;
    }
    portelement = local_port_clause.successor(portelement);
  }
  
  _cc_out << "}\n";
  
  //###Assumes binding entity and component has same # of o/io ports
  
  _cc_out << "if(boundedEntity != NULL) {" << endl;
  _cc_out << "boundedEntity->connect(inputsignals, outputsignals";
  if(first == 1) {
    portelement = local_port_clause.first();
    for(; portelement != NULL; ) {
      mode = portelement->get_mode();
      if((mode == IIR_IN_MODE )) {
	_cc_out << ", &";
	portelement->_publish_cc_elaborate();
      }
      portelement = local_port_clause.successor(portelement);
    }
    
    portelement = local_port_clause.first();
    for(; portelement != NULL; ) {
      mode = portelement->get_mode();
      if((mode == IIR_OUT_MODE ) || (mode == IIR_INOUT_MODE)) {
	_cc_out << ", &";
	portelement->_publish_cc_elaborate();
      }
      portelement = local_port_clause.successor(portelement);
    }
  }
  _cc_out << ");\n";
  _cc_out << "}" << endl;
  _cc_out << "}\n";
}

void
IIRScram_ComponentDeclaration::_publish_cc_getboundentityinfo() {
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::getBoundEntityInfo() {\n";
  _cc_out << "if(boundedEntity != NULL) {" << endl
	  << "  boundedEntity->getBoundEntityInfo();" << endl
	  << "}" << endl;
  _cc_out << "}" << endl;
}


#ifdef PROCESS_COMBINATION
void
IIRScram_ComponentDeclaration::
_static_elaborate(IIR_ArchitectureDeclaration *arch,
		  IIR_DeclarationList *cfglist,
		  char *hier_location) {
  IIR_SignalInterfaceDeclaration *port;

#ifdef DEBUG_ELAB
  cout << "Now checking component declaration at \"" << hier_location 
       << "\"\n";
#endif

  // component declaration generics aren't yet supported.
  if (local_generic_clause.num_elements() != 0) {
    cout << "ERROR:  Sorry, generics in component declarations "
	 << "not supported durign static elaboration yet\n";
    exit(1);
  }
  // attributes of components aren't yet supported.
  if (attributes.num_elements() != 0) {
    cout << "ERROR:  Sorry, attributes of component declarations "
	 << "not supported during static elaboration yet\n";
    abort();
  }

  // resolved signals aren't yet supported.
  port = local_port_clause.first();
  while (port != NULL) {
    IIR_Kind type = port->get_subtype()->get_kind();
    if (type == IIR_ENUMERATION_SUBTYPE_DEFINITION ||
	type == IIR_INTEGER_SUBTYPE_DEFINITION ||
	type == IIR_FLOATING_SUBTYPE_DEFINITION ||
	type == IIR_PHYSICAL_SUBTYPE_DEFINITION ||
	type == IIR_ARRAY_SUBTYPE_DEFINITION ||
	type == IIR_ACCESS_SUBTYPE_DEFINITION) {
      
      IIRScram_TypeDefinition *port_subtype;
      port_subtype = port->get_subtype();
      if (port_subtype->_get_resolution_function() != NULL) {
	cout << "ERROR: resolved signals in component declarations "
	     << "not supported during static elaboration yet\n";
	exit(1);
      }
    }
    port = local_port_clause.successor(port);
  }

#ifdef DEBUG_ELAB
  cout << "component declaration is clean--no generics, attributes, or resolved ports.\n";
#endif
}
#endif



