#ifndef IIRSCRAM_DECLARATION_LIST_HH
#define IIRSCRAM_DECLARATION_LIST_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DeclarationList.hh,v 1.3 1999/05/25 17:37:41 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_DeclarationList.hh"

class IIR_Name;
class IIR_StatementList;
class symbol_table;

class IIRScram_DeclarationList : public IIRBase_DeclarationList {

public:

  void _publish_cc();
  void _publish_cc_decl();
  void _publish_cc_package_declarations();
  void _publish_cc_decl_subprograms_and_types();
  void _publish_cc_prototype();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
  void _publish_vhdl_decl(ostream&);
  void _publish_vhdl(ostream&);

  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  set<IIR_Declaration> *_find_declarations( IIR_TextLiteral * );

  // This method walks through the list of declarations and publishes
  // initializations for constants declared here. This method is called
  // from process statement only as of now.
  void _publish_cc_constants();
  IIR_Boolean _publish_cc_constants_init(IIR_Boolean first = TRUE);
  void _publish_cc_global_constants_assignments();

  void _publish_cc_file_objects();
  void _publish_cc_file_objects_init();
  
  // This method looks through the list, finds the configuration
  // specifications, and does the appropriate type checking on them.  The
  // statement list passed in is so that labels can be found if needed.
  void _type_check_configuration_specifications( IIR_List &statement_list );

  // This method looks through the list, finds the disconnection
  // specifications, and does the appropriate type checking on them.
  void _type_check_disconnection_specifications( );

  // This method looks through the list, finds the attribute
  // specifications, and does the appropriate type checking on them.  The
  // statement list passed in is so that labels can be found if needed.
  void _type_check_attribute_specifications( IIR_List &statement_list );

  // This method assumes this list is a list of context items (use clauses
  // and library clauses) and makes the appropriate stuff visible in the
  // symbol table passed in.
  void _make_visible_as_context_list( symbol_table * );

  // This method applies the method passed in to each element, and
  // builds a newly allocated list of the members that returned true.
  IIR_DeclarationList *_build_constrained_list( IIR_Boolean (IIR::*constraint_function)() );

  IIR *_clone();

protected:
  IIRScram_DeclarationList() {}
  virtual ~IIRScram_DeclarationList() = 0;
    
private:
};
#endif
