// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajaesek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DesignatorExplicit.cc,v 1.2 1999/03/09 20:54:01 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_DesignatorExplicit.hh"
#include "IIR_Signature.hh"
#include "set.hh"
#include "resolution_func.hh"

IIRScram_DesignatorExplicit::~IIRScram_DesignatorExplicit() {}


void 
IIRScram_DesignatorExplicit::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_name()->_is_resolved() == TRUE);
  get_name()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_DesignatorExplicit::_publish_vhdl_entity_class(ostream &_vhdl_out) {
  IIR_Declaration *decl = NULL;

  ASSERT(get_name()->_is_resolved() == TRUE);
  ASSERT(get_name()->_is_iir_declaration());

  decl = (IIR_Declaration*)get_name();
  switch (decl->_get_type()) {
  case IIRScram_Declaration::VARIABLE:
  case IIRScram_Declaration::SHARED_VARIABLE:
  case IIRScram_Declaration::INTERFACE_VARIABLE:
    _vhdl_out << "variable";
    break;
  case IIRScram_Declaration::TYPE:
    _vhdl_out << "type";
    break;
  case IIRScram_Declaration::SUBTYPE:
    _vhdl_out << "subtype";
    break;
  case IIRScram_Declaration::SIGNAL:
  case IIRScram_Declaration::INTERFACE_SIGNAL:
    _vhdl_out << "signal";
    break;
  case IIRScram_Declaration::PROCEDURE:
    _vhdl_out << "procedure";
    break;
  case IIRScram_Declaration::FUNCTION:
    _vhdl_out << "function";
    break;
  case IIRScram_Declaration::S_FILE:
  case IIRScram_Declaration::INTERFACE_FILE:
    _vhdl_out << "file";
    break;
  case IIRScram_Declaration::ENTITY:
    _vhdl_out << "entity";
    break;
  case IIRScram_Declaration::CONSTANT:
  case IIRScram_Declaration::INTERFACE_CONSTANT:
    _vhdl_out << "constant";
    break;
  case IIRScram_Declaration::CONFIGURATION:
    _vhdl_out << "configuration";
    break;
  case IIRScram_Declaration::COMPONENT:
    _vhdl_out << "component";
    break;
  case IIRScram_Declaration::ARCHITECTURE:
    _vhdl_out << "architecture";
    break;
  case IIRScram_Declaration::PACKAGE:
    _vhdl_out << "package";
    break;
  case IIRScram_Declaration::LABEL:
    _vhdl_out << "label";
    break;
  case IIRScram_Declaration::LITERAL:
    _vhdl_out << "literal";
    break;
  case IIRScram_Declaration::UNITS:
    _vhdl_out << "units";
    break;
  case IIRScram_Declaration::GROUP:
    _vhdl_out << "group";
    break;
  default:
    cerr << "Oops!  Unsopported entity class in "
	 << "IIRScram_DesignatorExplicit::_publish_vhdl_entity_class" << endl;
    abort();
  }
}

void 
IIRScram_DesignatorExplicit::_publish_cc_entity_class() {
  IIR_Declaration *decl = NULL;
  ASSERT(get_name()->_is_resolved() == TRUE);
  ASSERT(get_name()->_is_iir_declaration() == TRUE);

  decl = (IIR_Declaration*)get_name();
  switch (decl->_get_type()) {
  case IIRScram_Declaration::VARIABLE:
  case IIRScram_Declaration::SHARED_VARIABLE:
  case IIRScram_Declaration::INTERFACE_VARIABLE:
    _cc_out << "variable";
    break;
  case IIRScram_Declaration::TYPE:
    _cc_out << "type";
    break;
  case IIRScram_Declaration::SUBTYPE:
    _cc_out << "subtype";
    break;
  case IIRScram_Declaration::SIGNAL:
  case IIRScram_Declaration::INTERFACE_SIGNAL:
    _cc_out << "signal";
    break;
  case IIRScram_Declaration::PROCEDURE:
    _cc_out << "procedure";
    break;
  case IIRScram_Declaration::FUNCTION:
    _cc_out << "function";
    break;
  case IIRScram_Declaration::S_FILE:
  case IIRScram_Declaration::INTERFACE_FILE:
    _cc_out << "file";
    break;
  case IIRScram_Declaration::ENTITY:
    _cc_out << "entity";
    break;
  case IIRScram_Declaration::CONSTANT:
  case IIRScram_Declaration::INTERFACE_CONSTANT:
    _cc_out << "constant";
    break;
  case IIRScram_Declaration::CONFIGURATION:
    _cc_out << "configuration";
    break;
  case IIRScram_Declaration::COMPONENT:
    _cc_out << "component";
    break;
  case IIRScram_Declaration::ARCHITECTURE:
    _cc_out << "architecture";
    break;
  case IIRScram_Declaration::PACKAGE:
    _cc_out << "package";
    break;
  case IIRScram_Declaration::LABEL:
    _cc_out << "label";
    break;
  case IIRScram_Declaration::LITERAL:
    _cc_out << "literal";
    break;
  case IIRScram_Declaration::UNITS:
    _cc_out << "units";
    break;
  case IIRScram_Declaration::GROUP:
    _cc_out << "group";
    break;
  default:
    cerr << "Oops!  Unsopported entity class in "
	 << "IIRScram_DesignatorExplicit::_publish_cc_entity_class" << endl;
    abort();
  }
}

IIR *
IIRScram_DesignatorExplicit::_get_name() {
  return get_name();
}

void
IIRScram_DesignatorExplicit::_publish_cc_elaborate() {
  get_name()->_publish_cc_elaborate();
}

void
IIRScram_DesignatorExplicit::_publish_cc() {
  get_name()->_publish_cc();
}

void
IIRScram_DesignatorExplicit::_publish_cc_designator() {
  get_name()->_publish_cc_declarator();
}


void 
IIRScram_DesignatorExplicit::_add_decl_into_cgen_symbol_table() {
  ASSERT(get_name() != NULL);
  ASSERT(get_name()->_is_resolved() == TRUE);
  get_name()->_add_decl_into_cgen_symbol_table();
}

void
IIRScram_DesignatorExplicit::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  switch(get_name()->get_kind()) {
  case IIR_SIGNAL_DECLARATION:
  case  IIR_SIGNAL_INTERFACE_DECLARATION:
    list->add((IIR_Declaration*)this->get_name());
    break;
  }
}

set<IIR_TypeDefinition> *
IIRScram_DesignatorExplicit::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval = NULL;

  if( get_signature() == NULL ){
    retval = get_name()->_get_rval_set(constraint_function);
  }
  else{
    set<IIR_Declaration> *possible_decls;
    possible_decls = get_name()->_symbol_lookup();

    resolve_subprogram_decls( possible_decls,
			      get_signature() );

    if( possible_decls->num_elements() != 0 ){
      retval = new set<IIR_TypeDefinition>;
      IIR_Declaration *current_decl = possible_decls->get_element();
      while( current_decl != NULL ){
	retval->add( current_decl->_get_subtype() );
	current_decl = possible_decls->get_next_element();
      }
    }
    
  }

  return retval;
}

set<IIR_Declaration> *
IIRScram_DesignatorExplicit::_symbol_lookup(){
  set<IIR_Declaration> *retval = NULL;

  if( get_signature() == NULL ){
    retval = get_name()->_symbol_lookup();
  }
  else{
    set<IIR_Declaration> *possible_decls;
    possible_decls = get_name()->_symbol_lookup();

    resolve_subprogram_decls( possible_decls,
			      get_signature() );

    if( possible_decls->num_elements() != 0 ){
      retval = new set<IIR_Declaration>;
      IIR_Declaration *current_decl = possible_decls->get_element();
      while( current_decl != NULL ){
	retval->add( current_decl );
	current_decl = possible_decls->get_next_element();
      }
    }
    
  }

  return retval;
}

IIR*
IIRScram_DesignatorExplicit::_clone() {
  IIR_Signature *sig = NULL;
  IIR *name = NULL;
  IIR_DesignatorExplicit *clone = new IIR_DesignatorExplicit;
  IIRScram::_clone(clone);

  name = get_name()->_clone();
  clone->set_name(name);

  if (get_signature() != NULL) {
    sig = (IIR_Signature*)get_signature()->_clone();
  }
  clone->set_signature(sig);

  return clone;
}

IIR *
IIRScram_DesignatorExplicit::_semantic_transform( set<IIR_TypeDefinition> *transform_set ){
  set_name( get_name()->_semantic_transform( transform_set ) );
  return this;
}

void 
IIRScram_DesignatorExplicit::_type_check( set<IIR_TypeDefinition> *check_set ){
  get_name()->_type_check( check_set );
}

IIR *
IIRScram_DesignatorExplicit::_rval_to_decl( IIR_TypeDefinition *my_type ){
  set_name( get_name()->_rval_to_decl( my_type ) );
  
  return this;
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_resolved(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_resolved();
}

ostream &
IIRScram_DesignatorExplicit::_print( ostream &os ){
  ASSERT( get_name() != NULL );
  return get_name()->_print( os );
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_locally_static(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_locally_static();
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_globally_static(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_locally_static();
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_signal(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_signal();
}

IIR_SignalKind 
IIRScram_DesignatorExplicit::_get_signal_kind(){
  ASSERT( get_name() != NULL );
  return get_name()->_get_signal_kind();
}
