// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ElementDeclaration.cc,v 1.3 1999/10/07 14:05:03 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_ElementDeclaration.hh"
#include "IIR_RecordTypeDefinition.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "IIR_SimpleName.hh"
#include "IIR_TextLiteral.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"

IIRScram_ElementDeclaration::~IIRScram_ElementDeclaration() {}

void 
IIRScram_ElementDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  ASSERT( _get_declarative_region() != NULL );
  ASSERT(_get_declarative_region()->get_kind() == IIR_RECORD_TYPE_DEFINITION);
  
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_subtype()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}


IIR_TypeDefinition *
IIRScram_ElementDeclaration::_get_subtype(){
  return get_subtype();
}


set<IIR_Declaration> *
IIRScram_ElementDeclaration::_find_declarations( IIR_Name *to_find ){
  set<IIR_Declaration> *retval = NULL;

  ASSERT( get_subtype() != NULL );

  if( get_subtype()->_is_record_type() == TRUE ){
    IIR_RecordTypeDefinition *my_subtype;
    my_subtype = (IIR_RecordTypeDefinition *)get_subtype();
    retval = my_subtype->element_declarations._find_declarations( to_find );
  }
  else{
    retval = NULL;
  }

  return retval;
}

IIR_TypeDefinition *
IIRScram_ElementDeclaration::_determine_rval_in_set( set<IIR_TypeDefinition> *look_in,
						     IIR_TypeDefinition *my_rval ){

  ASSERT( _get_subtype() == my_rval );

  IIR_SimpleName *temp_name = new IIR_SimpleName;
  copy_location( this, temp_name );
  temp_name->set_prefix( get_declarator() );

  IIR_TypeDefinition *current_prefix_rval = look_in->get_element();
  while( current_prefix_rval != NULL ){
    set<IIR_Declaration> *found_declarations = current_prefix_rval->_find_declarations(temp_name);
    IIR_Declaration *current = found_declarations->get_element();
    while( current != NULL ){
      if( current == this ){
	delete temp_name;
	return current_prefix_rval;
      }
      current = found_declarations->get_next_element();
    }
    delete found_declarations;
    current_prefix_rval = look_in->get_next_element();
  }

  ostrstream err;
  err << "Internal error in IIRScram_ElementDeclaration::_determine_rval_in_set" << ends;
  report_error( this, err );
  abort();
  return 0;
}

set<IIR_TypeDefinition> *
IIRScram_ElementDeclaration::_get_rval_set( set<IIR_TypeDefinition> *look_in,
					    IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;

  IIR_SimpleName *temp_name = new IIR_SimpleName;
  copy_location( this, temp_name );
  temp_name->set_prefix( get_declarator() );

  // We need to scan the prefixes and make sure that our definition is in there
  // somewhere...

  IIR_TypeDefinition *current_prefix_rval = look_in->get_element();
  while( current_prefix_rval != NULL ){
    set<IIR_Declaration> *found_declarations;
    found_declarations = current_prefix_rval->_find_declarations( temp_name );
    if( found_declarations != NULL ){
      IIR_Declaration *current_declaration = found_declarations->get_element();
      while( current_declaration != NULL ){
	if( current_declaration == this ){
	  delete temp_name;
	  retval->add( _get_subtype() );
	  break;
	}
	current_declaration = found_declarations->get_next_element();
      }
    }
    current_prefix_rval = look_in->get_next_element();
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }

  return retval;
}

set<IIR_TypeDefinition> *
IIRScram_ElementDeclaration::_get_rval_set( set<IIR_Declaration> *look_in,
					    IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;

  IIR_SimpleName *temp_name = new IIR_SimpleName;
  copy_location( this, temp_name );
  temp_name->set_prefix( get_declarator() );

  // We need to scan the prefixes and make sure that our definition is in there
  // somewhere...

  IIR_Declaration *current_prefix_decl = look_in->get_element();
  while( current_prefix_decl != NULL ){
    set<IIR_Declaration> *found =  current_prefix_decl->_find_declarations( temp_name );
    if( found != NULL ){
      IIR_Declaration *current = found->get_element();
      while( current != NULL ){
	if( current == this ){
	  delete temp_name;
	  retval->add( _get_subtype() );
	  break;
	}
	current = found->get_next_element();
      }
    }
    current_prefix_decl = look_in->get_next_element();
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }

  return retval;
}

int
IIRScram_ElementDeclaration::_get_field_number()
{
  IIR_ElementDeclarationList *field_list = & ((IIR_RecordTypeDefinition *) _get_declarative_region())->element_declarations;
  IIR_ElementDeclaration *field = (IIR_ElementDeclaration *) field_list->first();
  int field_number = 1;
  
  while (field != NULL) {
    if (field == (IIR_ElementDeclaration *) this) {
      break;
    }

    field = (IIR_ElementDeclaration *) field_list->successor(field);
    field_number++;
  }

  return field_number;
}
  
void
IIRScram_ElementDeclaration::_publish_cc_universal_value()
{
  ASSERT(_get_declarative_region() != NULL);
  ASSERT(_get_declarative_region()->get_kind() == IIR_RECORD_TYPE_DEFINITION);
  
  _cc_out << _get_field_number();
}

void 
IIRScram_ElementDeclaration::_publish_cc_type_name() {
  if (get_subtype()->_is_scalar_type() == TRUE &&
      get_subtype()->_is_kernel_type() == FALSE){
    get_subtype()->_publish_cc_kernel_type();
  }
  else {
    get_subtype()->_publish_cc_type_name();
  }
}

IIR *
IIRScram_ElementDeclaration::_rval_to_decl( IIR_TypeDefinition *prefix_rval,
					    IIR_TypeDefinition *suffix_rval ){
  ASSERT( suffix_rval == _get_subtype() );
  return this;
}


IIR_Boolean 
IIRScram_ElementDeclaration::_is_scalar_type(){
  ASSERT( _get_subtype() != NULL );
  return _get_subtype()->_is_scalar_type();
}


IIR_Boolean 
IIRScram_ElementDeclaration::_is_array_type(){
  ASSERT( _get_subtype() != NULL );
  return _get_subtype()->_is_array_type();
}

IIR_Boolean 
IIRScram_ElementDeclaration::_is_access_type(){
  ASSERT( _get_subtype() != NULL );
  return _get_subtype()->_is_access_type();
}

void 
IIRScram_ElementDeclaration::_publish_cc() {
  _get_declarator()->_publish_cc();
}

void
IIRScram_ElementDeclaration::_publish_cc_elaborate() {
  _publish_cc();
}

IIR_TypeDefinition *
IIRScram_ElementDeclaration::_get_type_of_element( int index_num ){
  ASSERT( _get_subtype() != NULL );
  return _get_subtype()->_get_type_of_element( index_num );  
}

IIR_TypeDefinition *
IIRScram_ElementDeclaration::_get_rval_pointed_at( ){
  IIR_TypeDefinition *retval;

  ASSERT( _get_subtype() != NULL );
  if( _get_subtype()->_is_iir_access_type_definition() ){
    retval = ((IIR_AccessTypeDefinition *)_get_subtype())->get_designated_type();
  }
  else{
    retval = NULL;
  }
  
  return retval;
}
