// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Expression.cc,v 1.2 1999/03/09 20:54:26 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_Expression.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"

IIRScram_Expression::~IIRScram_Expression() {}

void 
IIRScram_Expression::_publish_cc_bounds() {
  IIR_ScalarTypeDefinition *index_type = NULL;
  IIR_ArrayTypeDefinition  *array_type = NULL;
  //Now By default we return NULL
  //The bounds of the result of the expression is determined at runtime
  //_cc_out << "NULL";
  if ( _get_subtype()->_is_array_type() == TRUE && _get_subtype()->_is_single_dimensional_array_type() == TRUE){
    array_type = (IIR_ArrayTypeDefinition *)_get_subtype();
    index_type = array_type->get_index_subtype();
    if ( index_type != NULL && index_type->get_left() != NULL && index_type->get_right() != NULL ){
      _cc_out << "ArrayInfo(";
      index_type->get_left()->_publish_cc_value();
      if ( index_type->_is_ascending_range() == TRUE ){
	_cc_out << ", to, ";
      } else {
	_cc_out << ", downto, ";
      }
      index_type->get_right()->_publish_cc_value();
      _cc_out << ")";
    } else {
      _cc_out << "nullInfo";
    }
  } else {
    _cc_out << "nullInfo";
  }
}

void
IIRScram_Expression::_publish_cc_state_object_init(){
  _cc_out << "new ";
  _get_subtype()->_publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE, ";
  _publish_cc();
  _cc_out << ")";
}

void
IIRScram_Expression::_publish_cc_elaborate() {
  _publish_cc();
}

void 
IIRScram_Expression::_publish_cc_universal_value() {
  ASSERT(_get_subtype() != NULL);
  _cc_out << "((";
  _get_subtype()->_publish_cc_universal_type();
  _cc_out << "&) ";
  _publish_cc();
  _cc_out << ".getVHDLData())";
}

void 
IIRScram_Expression::_publish_cc_value() {
  _cc_out << "(";
  _publish_cc_universal_value();
  _cc_out << ".val)";
}

IIR_Boolean
IIRScram_Expression::_is_array_type()
{
  return get_subtype()->_is_array_type();
}

IIR *
IIRScram_Expression::_rval_to_decl( IIR_TypeDefinition *my_type ){
  set_subtype( my_type );
  ASSERT( _is_resolved() == TRUE );

  return this;
}


void
IIRScram_Expression::_clone(IIR_Expression *clone) {
  IIRScram::_clone(clone);
  // clone IIR_Expression info
  clone->set_subtype(get_subtype());
}


void 
IIRScram_Expression::_add_decl_into_cgen_symbol_table() {
  if((this->get_kind() != IIR_PHYSICAL_LITERAL) &&
     (this->get_kind() != IIR_TYPE_CONVERSION)) {
    _report_undefined_scram_fn("_add_decl_into_cgen_symbol_table()");
  }
}

IIR_TypeDefinition*
IIRScram_Expression::_get_subtype() {
  return get_subtype();
}


void
IIRScram_Expression::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  if((get_kind() == IIR_PHYSICAL_LITERAL) ||
     (get_kind() == IIR_ALLOCATOR)) {
    //Do nothing here
  }
  else {
    //This else clause should go off, once all the derived nodes of 
    //IIR_Expression have this function filled.
    _report_undefined_scram_fn("_build_sensitivity_list(IIR_DesignatorList*)");
  }
}

