
#ifndef IIRSCRAM_INTEGER_SUBTYPE_DEFINITION_HH
#define IIRSCRAM_INTEGER_SUBTYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.ed
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IntegerSubtypeDefinition.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_IntegerSubtypeDefinition.hh"

class IIRScram_IntegerSubtypeDefinition : public IIRBase_IntegerSubtypeDefinition {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  void _publish_cc_universal_type();
  void _publish_cc_left();
  void _publish_cc_right();
  //  void _publish_cc_parent_type_name();
  
  //The following function is used to publish the range of the type.
  //And this is useful in publishing ranges speficied in aggregartes.
  //It is intended to be used for aggregate initialization only.
  void _publish_cc_universal_value();

  virtual IIR_Boolean _is_subtype();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();

  IIR *_clone();

  IIR_FunctionDeclaration* _get_resolution_function(){ return get_resolution_function(); }
  void _set_resolution_function(IIR_FunctionDeclaration *new_function ){
    set_resolution_function( new_function );
  }

protected:
  
  IIRScram_IntegerSubtypeDefinition() {};
  virtual ~IIRScram_IntegerSubtypeDefinition() = 0;
    
private:
  

};

#endif
