// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LessThanOrEqualOperator.cc,v 1.2 1999/03/09 20:55:18 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_LessThanOrEqualOperator.hh"

IIRScram_LessThanOrEqualOperator::~IIRScram_LessThanOrEqualOperator() {}

void 
IIRScram_LessThanOrEqualOperator::_publish_cc_operator_name() {
  _cc_out << "savantLessThanOrEqual";
}


IIR*
IIRScram_LessThanOrEqualOperator::_clone() {
  IIR_LessThanOrEqualOperator *clone = new IIR_LessThanOrEqualOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_LessThanOrEqualOperator::_get_operator_precedence(){
  return IIRScram::RELATIONAL_OPERATOR;
}

IIR_Boolean                                      
IIRScram_LessThanOrEqualOperator::_is_relational_operator(){
  return TRUE ;                                                              
}

void
IIRScram_LessThanOrEqualOperator::_publish_vhdl_operator(ostream & _vhdl_out){
  _vhdl_out << " <= ";
}
