// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_MonadicOperator.cc,v 1.2 1999/03/09 20:55:30 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_MonadicOperator.hh"
#include "IIR_AbsoluteOperator.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_IdentityOperator.hh"
#include "IIR_NegationOperator.hh"
#include "IIR_NotOperator.hh"
#include "IIR_SubprogramDeclaration.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"
#include <strstream.h>

IIRScram_MonadicOperator::~IIRScram_MonadicOperator() {}

char *
IIRScram_MonadicOperator::_get_function_name(){
  char *retval;

  switch ( get_kind() ){
  case IIR_IDENTITY_OPERATOR:{
    retval = "\"+\"";
    break;
  }

  case IIR_NEGATION_OPERATOR:{
    retval = "\"-\"";
    break;
  }

  case IIR_ABSOLUTE_OPERATOR:{
    retval = "\"abs\"";
    break;
  }

  case IIR_NOT_OPERATOR:{
    retval = "\"not\"";
    break;
  }

  default:{
    cerr << "Unknown operator type in IIRScram_MonadicOperator::_get_function_name()" << endl;
    abort();
  }
  }

  return retval;
}


IIR * 
IIRScram_MonadicOperator::_transmute() {
  IIR_AssociationElementByExpression* associationelement;
  IIR_FunctionCall* functioncall = new IIR_FunctionCall;
  copy_location( this, functioncall );

  functioncall->set_implementation(get_implementation());

  associationelement = new IIR_AssociationElementByExpression;
  copy_location( this, associationelement );
  associationelement->set_actual(get_operand());
  functioncall->parameter_association_list.append(associationelement);

  return functioncall;
}


IIR_AssociationList *
IIRScram_MonadicOperator::_build_argument_list(){
  IIR_AssociationList *retval = new IIR_AssociationList;
  //  copy_location( this, retval );
  
  if( get_operand()->_is_association() == FALSE ){
    IIR_AssociationElementByExpression *new_assoc = new IIR_AssociationElementByExpression();
    copy_location( this, new_assoc );
    new_assoc->set_actual( get_operand() );
    retval->append( new_assoc );
  }
  else{
    retval->append( (IIR_AssociationElement *)get_operand() );
  }

  return retval;
}


void 
IIRScram_MonadicOperator::_publish_cc_operator_name() {
  _report_undefined_scram_fn("_publish_cc_operator_name()");
}


void 
IIRScram_MonadicOperator::_publish_cc() {
  ASSERT(get_subtype() != NULL);
  _publish_cc_operator_name();
  _cc_out << "(";
  get_operand()->_publish_cc();
  _cc_out << ")";
}


void 
IIRScram_MonadicOperator::_publish_cc_headers() {
  ASSERT(get_operand() != NULL);
  get_operand()->_publish_cc_headers();
}


void 
IIRScram_MonadicOperator::_publish_cc_initialization_value() {
  _publish_cc();
}


void 
IIRScram_MonadicOperator::_publish_cc_wait_data() {
  _publish_cc_operator_name();
  _cc_out << "(";
  get_operand()->_publish_cc_wait_data();
  _cc_out << ")";
}


void
IIRScram_MonadicOperator::_get_list_of_input_signals(set<IIR_Declaration>* list){
  get_operand()->_get_list_of_input_signals(list);
}


void
IIRScram_MonadicOperator::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_operand()->_build_sensitivity_list(sensitivity_list);
}


ostream &
IIRScram_MonadicOperator::_print( ostream &os ){
  os << _get_function_name();

  return os;
}


IIR_Boolean 
IIRScram_MonadicOperator::_is_resolved(){
  if( get_implementation() != NULL ){
    return get_implementation()->_is_resolved();
  }
  else{
    return get_operand()->_is_resolved();
  }
}

IIR *
IIRScram_MonadicOperator::_clone() {
  IIR *cloneop;
  IIR_MonadicOperator *clone;

  switch (get_kind()) {
  case IIR_IDENTITY_OPERATOR:
    clone = new IIR_IdentityOperator;
    break;
  case IIR_NEGATION_OPERATOR:
    clone = new IIR_NegationOperator;
    break;
  case IIR_ABSOLUTE_OPERATOR:
    clone = new IIR_AbsoluteOperator;
    break;
  case IIR_NOT_OPERATOR:
    clone = new IIR_NotOperator;
    break;
  default:
    ostrstream err;
    err << "ERROR: unexpected node type \"" << get_kind_text() << "\" in "
	<< "IIR_MonadicOperator::_clone()" << ends;
    report_error( this, err );
    break;
  }

  IIRScram_Expression::_clone(clone);
  clone->set_implementation(get_implementation());
  cloneop = get_operand()->_clone();
  clone->set_operand(cloneop);

  return clone;
}


void 
IIRScram_MonadicOperator::_add_decl_into_cgen_symbol_table() {
  get_operand()->_add_decl_into_cgen_symbol_table();
}


IIR_Boolean
IIRScram_MonadicOperator::_is_static_expression() {
  return get_operand()->_is_static_expression();
}


IIR_Boolean
IIRScram_MonadicOperator::_is_operator() {
  return TRUE;
}

IIR_Boolean 
IIRScram_MonadicOperator::_is_locally_static_primary(){
  ASSERT( _is_resolved() == TRUE );
  return get_operand()->_is_locally_static_primary();
}

void
IIRScram_MonadicOperator::_publish_vhdl(ostream &_vhdl_out){
  // Commented out since scram is not parsing it. need to be uncommented
  // out later.
  //_vhdl_out << "(";
  _publish_vhdl_operator(_vhdl_out);
  _vhdl_out << "(";
  get_operand()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ")";
  // Commented out since scram is not parsing it. Need to be uncommented
  // out later.
  //_vhdl_out << "))";
}

void 
IIRScram_MonadicOperator::_type_check_operands(){
  ASSERT( get_implementation() != NULL );
  ASSERT( get_implementation()->interface_declarations.num_elements() == 1 );

  IIR_TypeDefinition *operand_subtype = 
    get_implementation()->interface_declarations.first()->get_subtype();

  set_operand( get_operand()->_semantic_transform( operand_subtype ) );
  get_operand()->_type_check( operand_subtype );
  set_operand( get_operand()->_rval_to_decl( operand_subtype ) );
}
