// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_NextStatement.cc,v 1.2 1999/03/09 20:55:37 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_NextStatement.hh"
#include "IIR_Identifier.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "IIR_Label.hh"
#include "IIR_List.hh"

IIRScram_NextStatement::~IIRScram_NextStatement() {}


void
IIRScram_NextStatement::_publish_vhdl(ostream &_vhdl_out) {
  if (get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ": ";
  }
    
  _vhdl_out << "next ";
    
  if (get_enclosing_loop() != NULL) {
    if ( get_enclosing_loop()->get_label() != NULL ){
      get_enclosing_loop()->get_label()->_publish_vhdl(_vhdl_out);
    }
  }
    
  if (get_condition() != NULL) {
    _vhdl_out << "\nwhen ";
    get_condition()->_publish_vhdl(_vhdl_out);
  }
}


void
IIRScram_NextStatement::_publish_cc() {
  if (get_label() != NULL) {
    get_label()->_publish_cc();
    _cc_out << ": ";
  }

  if (get_condition() != NULL) {
    _cc_out << "if (";
    _cc_out << "SAVANT_BOOLEAN_TRUE == ";
    ASSERT(get_condition()->_is_resolved() == TRUE);
    get_condition()->_publish_cc();
    _cc_out << ") {\n";
  }
  if (get_enclosing_loop() != NULL) {
    _cc_out << "goto ";
    get_enclosing_loop()->_publish_cc_next_label();
    _cc_out << ";" << endl;
  }
  else {
    _cc_out << "continue;\n";
  }
  if (get_condition() != NULL) {
    _cc_out << "}\n";
  }
}

void
IIRScram_NextStatement::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  if(get_condition() != NULL) {
    get_condition()->_get_list_of_input_signals(list);
  }
}

void
IIRScram_NextStatement::_type_check() {
  if( get_condition() != NULL ){
    set_condition( _type_check_and_resolve_boolean_condition( get_condition() ) );
  }
}

