// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_OrOperator.cc,v 1.2 1999/03/09 20:55:44 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_OrOperator.hh"
#include "IIR_TypeDefinition.hh"

IIRScram_OrOperator::~IIRScram_OrOperator() {}

void 
IIRScram_OrOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " or ";
}

void 
IIRScram_OrOperator::_publish_cc_operator_name() {
  _cc_out << "savantOr";
}

void 
IIRScram_OrOperator::_publish_cc_wait_data() {
  _cc_out << "savantOr(";
  get_left_operand()->_publish_cc_wait_data();
  _cc_out << ", ";
  get_right_operand()->_publish_cc_wait_data();
  _cc_out << ")";
}

void 
IIRScram_OrOperator::_publish_cc_short_circuit() {
  if(get_subtype()->_is_bit_type()) {
    _cc_out << "((";
    get_left_operand()->_publish_cc();
    _cc_out << " == ENUMERATION_ONE) ? ";
    _cc_out << "ENUMERATION_ONE : ";
    _publish_cc_operator_name();
    _cc_out << "(ENUMERATION_ZERO, ";
    get_right_operand()->_publish_cc();
    _cc_out << "))";
  }
  else {
    _cc_out << "((";
    get_left_operand()->_publish_cc();
    _cc_out << " == ENUMERATION_TRUE) ? ";
    _cc_out << "ENUMERATION_TRUE : ";
    _publish_cc_operator_name();
    _cc_out << "(ENUMERATION_FALSE, ";
    get_right_operand()->_publish_cc();
    _cc_out << "))";
  }
}

void 
IIRScram_OrOperator::_publish_cc_wait_data_short_circuit() {

  if(get_subtype()->_is_bit_type()) {
    _cc_out << "((";
    get_left_operand()->_publish_cc();
    _cc_out << " == ENUMERATION_ONE) ? ";
    _cc_out << "ENUMERATION_ONE : ";
    _publish_cc_operator_name();
    _cc_out << "(ENUMERATION_ZERO, ";
    get_right_operand()->_publish_cc();
    _cc_out << "))";
  }
  else {
    _cc_out << "((";
    get_left_operand()->_publish_cc_wait_data();
    _cc_out << " == ENUMERATION_TRUE) ? ";
    _cc_out << "ENUMERATION_TRUE : ";
    _publish_cc_operator_name();
    _cc_out << "(ENUMERATION_FALSE, ";
    get_right_operand()->_publish_cc_wait_data();
    _cc_out << "))";
  }
}


IIR*
IIRScram_OrOperator::_clone() {
  IIR_OrOperator *clone = new IIR_OrOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_OrOperator::_get_operator_precedence(){
  return IIRScram::LOGICAL_OPERATOR;
}

bool
IIRScram_OrOperator::_is_associative(IIR_Kind oper_kind){
  switch(oper_kind) {                                                        
  case IIR_AND_OPERATOR:
  case IIR_NAND_OPERATOR:
  case IIR_NOR_OPERATOR:
  case IIR_XOR_OPERATOR:
  case IIR_XNOR_OPERATOR:
    return FALSE;                                                             
  default:
    return TRUE;                                                             
  }                 
}

IIR_Boolean
IIRScram_OrOperator::_is_logical_operator(){
  return TRUE;
}
