#ifndef IIRSCRAM_RECORD_TYPE_DEFINITION_HH
#define IIRSCRAM_RECORD_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_RecordTypeDefinition.hh,v 1.2 1999/03/09 20:56:10 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_RecordTypeDefinition.hh"
#include "set.hh"

class IIR_RecordTypeDefinition;

class IIRScram_RecordTypeDefinition : public IIRBase_RecordTypeDefinition {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_subtype_decl(ostream &);

  virtual IIR_Boolean _is_record_type() { return TRUE; }
  virtual IIR_Boolean _is_iir_record_type_definition() { return TRUE; }

  virtual IIR_Boolean _has_access_type();

  // This method returns the subtype of the "nth" element.
  IIR_TypeDefinition *_get_element_subtype( int );

  IIR_ElementDeclarationList *_get_element_declarations(){ return &element_declarations; }

  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  //The following methods needed for publishing 
  //the record types .hh and .cc files
  virtual void _publish_cc_kernel_type();
  virtual void _publish_cc_decl_constructors();
  virtual void _publish_cc_decl_destructors();
  virtual void _publish_cc_decl_operator_equalto();
  virtual void _publish_cc_data_members();
  virtual void _publish_cc_headers();

  virtual void _publish_cc_constructor_args();

  void _publish_cc_decl_cc();
  void _publish_cc_record_fields();
  void _publish_cc_constructor_with_arguments();
  void _publish_cc_constructor_with_no_arguments();  
  void _publish_cc_constructor_with_aggregates();  
  void _publish_cc_constructor_aggregate_init();  
  void _publish_cc_constructor_for_alias_init();
  
  void _publish_cc_destructor();
  void _publish_cc_operator_equalto();
  void _publish_cc_get_field();

  void _publish_cc_decl_type_attributes();
  void _publish_cc_necessary_decl_in_state();

  void _publish_cc_event_operator_equalto();
  void _publish_cc_lastevent_operator_equalto();
  void _publish_cc_event_constructor_with_aggregates();
  void _publish_cc_class_event_get_field();
  void _publish_cc_event_constructor_with_no_arguments();
  void _publish_cc_last_event_constructor_with_no_arguments();
  
  //The following methods needed for the initializations in _state.hh files
  void _publish_cc_init_signal();
  void _publish_cc_composite_init();

  void _publish_cc_decl_operators();
  void _publish_cc_equality_operator();
  void _publish_cc_inequality_operator();
  void _publish_cc_init_fields_for_signals();

  void _publish_cc_class_event();
  void _publish_cc_class_last_event();
  void _publish_cc_universal_type();

  void _publish_cc_extern_type_info() {}
  void _publish_cc_type_info() {}
  
  IIR_FunctionDeclaration* _get_resolution_function(){ return get_resolution_function(); }
  void _set_resolution_function(IIR_FunctionDeclaration *new_function ){
    set_resolution_function( new_function );
  }
  
  ostream &_print( ostream & );

  IIR_TypeDefinition *_get_new_subtype();

  IIR_ScalarTypeDefinition *_get_index_subtype();
  
  IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );

  void _make_interface_visible( symbol_table * );

  IIR *_clone();
  void _clone( IIR_RecordTypeDefinition * );

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();

  void _come_into_scope( symbol_table *, IIR_TypeDeclaration * );
  void _come_out_of_scope( symbol_table * );

protected:
  IIRScram_RecordTypeDefinition();
  virtual ~IIRScram_RecordTypeDefinition() = 0;
    
private:
};
#endif


