
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ReportStatement.cc,v 1.3 1999/08/31 03:03:19 dmadhava Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ReportStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"

IIRScram_ReportStatement::~IIRScram_ReportStatement(){}

void 
IIRScram_ReportStatement::_publish_vhdl(ostream &_vhdl_out) {
  if(get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ":\n";
  }

  _vhdl_out << "   report ";
  get_report_expression()->_publish_vhdl(_vhdl_out);

  if(get_severity_expression() != NULL) {
    _vhdl_out << "\n";
    _vhdl_out << "     severity ";
    get_severity_expression()->_publish_vhdl(_vhdl_out);
  }
}

void
IIRScram_ReportStatement::_publish_cc() {
  if (get_label() != NULL) {
    get_label()->_publish_cc();
    _cc_out << ":  ";
  }
  _cc_out << "{\n";  
  _cc_out << "  SavantlineType savantOutString;\n"
	  << "  ostrstream savantOutStream;\n\n";

  _cc_out << "  savantOutStream << \"At Time: \" << ";
  
  if(_is_currently_publishing_subprogram() == TRUE) {
    _cc_out << "processPtr->getTimeNow()";
  } else {
    _cc_out << "getTimeNow()";
  }
  
  _cc_out << " << \" Report: \" << endl << \"    \" << ";
  if(get_report_expression() != NULL) {
    get_report_expression()->_publish_cc();
  } else {
    _cc_out << "\"Report\"";
  }
  _cc_out << " << endl";
  
  // Severity expression.
  _cc_out << " << \"Severity Level: \" << ";
  if(get_severity_expression() != NULL) {
    get_severity_expression()->_publish_cc();
  } else {
    _cc_out << "\"NOTE\"";
  }
  
  // More information on the location of the report statement.
  _cc_out << " << \" at " << *get_file_name() << ":" 
	  << get_line_number() << "\" << ends;" << endl;
  
  _cc_out << "savantOutString = savantOutStream.str();" << endl;
  
  if(_is_currently_publishing_subprogram() == TRUE) {
    _cc_out << "processPtr->";
  }
  
  _cc_out << "savantwriteline(NULL, FileQueue::standardOut, savantOutString);"
	  << endl;
  _cc_out << "delete [] savantOutStream.str();" << endl ;
  _cc_out << "}" << endl;
}

void
IIRScram_ReportStatement::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  if(get_report_expression() != NULL) {
    get_report_expression()->_get_list_of_input_signals(list);
  }
  if(get_severity_expression() != NULL) {
    get_severity_expression()->_get_list_of_input_signals(list);
  }
}

void 
IIRScram_ReportStatement::_type_check(){
  if( get_report_expression() != NULL ){
    _type_check_report_expression();
  }

  if( get_severity_expression() != NULL ){
    _type_check_severity_expression();
  }
}


