// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V.Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SubtypeDeclaration.cc,v 1.5 1999/10/28 03:24:10 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include <strstream.h>
#include "IIRScram_SubtypeDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_DesignFile.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIRScram_TextLiteral.hh"
#include "set.hh"
#include "IIR_FunctionDeclaration.hh"

IIRScram_SubtypeDeclaration::~IIRScram_SubtypeDeclaration() {}

IIR_Int32 
IIRScram_SubtypeDeclaration::_get_num_indexes(){
  ASSERT( get_subtype() != NULL );
  return get_subtype()->_get_num_indexes();
}

void 
IIRScram_SubtypeDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  ASSERT(get_subtype() != NULL);
  // This assertion is not true for:
  // type foo is ( red, green, blue );
  // subtype bar is foo;
  // (Or for any other type definition that isn't required to have an
  // anonymous base type.)
  //  ASSERT(get_subtype()->get_base_type() != NULL);
  

  _vhdl_out << "subtype ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  if(get_subtype() != NULL) {
    _vhdl_out << " is ";

    get_subtype()->_publish_vhdl_subtype_decl(_vhdl_out);
  }
  _vhdl_out << ";\n";
}

void 
IIRScram_SubtypeDeclaration::_publish_cc() {
  _get_declarator()->_publish_cc();
}

void
IIRScram_SubtypeDeclaration::_publish_cc_universal_type(){
  get_subtype()->_publish_cc_universal_type();
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_type_name() {
  get_subtype()->_publish_cc_type_name();
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_headers() {
  _cc_out << "#include \"";
  _publish_cc_type_name();
  _cc_out << ".hh\"\n";
  get_subtype()->_publish_cc_headers();
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_decl() {
  char *className;
  strstream classStream;

  PublishedUnit _saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(IIRScram::TYPE);
  if (_get_subtype()->_is_scalar_type() == TRUE && 
      _get_subtype()->_is_kernel_type() == FALSE){
    _cc_out << "#include \"";
    _get_subtype()->_publish_cc_kernel_type();
    _cc_out << ".hh\"\n";
  }
  classStream << "Savant";
  _get_declarator()->_print(classStream);
  classStream <<"Type" << ends;
  className = classStream.str();
  if (_get_subtype()->_is_scalar_type() == FALSE ||
      _get_subtype()->_is_access_type() == TRUE){
    _cc_out.set_file(TRUE, className, ".hh");
    get_subtype()->_publish_cc_decl_hh();
  }

  if(get_subtype()->_has_access_type() == FALSE) {
    if ((get_subtype()->_is_record_type() == TRUE) ||
	(get_subtype()->_is_array_type() == TRUE)) {
      _cc_out.set_file(TRUE, className, "_event.hh");
      get_subtype()->_publish_cc_class_event();
      _cc_out.set_file(TRUE, className, "_lastevent.hh");
      get_subtype()->_publish_cc_class_last_event();
    }
  }
  _cc_out.set_file(TRUE, className, ".cc");
  if (_get_subtype()->_is_scalar_type() == FALSE ||
      _get_subtype()->_is_access_type() == TRUE){
    _cc_out << "#include \"" << className << ".hh\"\n";
  }
  _cc_out << "#include \"_savant_entity_elab.hh\"\n"
	  << "#include \"standard.hh\"\n\n";
  if(get_subtype()->_get_resolution_function() != NULL) {
    _cc_out << "VHDLType* ";
    get_subtype()->_get_resolution_function()->_publish_cc_resolution_function_name();
    _cc_out << "(VHDLKernelBase*, int, VHDLType**);\n";
  }
  
  if (_get_subtype()->_is_scalar_type() == FALSE ||
      _get_subtype()->_is_access_type() == TRUE){
    get_subtype()->_publish_cc_decl_cc();
  }
  _set_currently_publishing_unit(_saved_publishing_unit);
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_range() {
  // cerr << "IIRScram_SubtypeDeclaration::_publish_cc_range() called!! " 
  // << "Trying to work around\n";
  get_subtype()->_publish_cc_range();
}

void
IIRScram_SubtypeDeclaration::_publish_cc_type_info() {
  if((_is_scalar_type() == TRUE || _is_array_type() == TRUE) &&
     _is_access_type() == FALSE){
    get_subtype()->_publish_cc_type_info();
    _cc_out << ";\n";
  }
}

void
IIRScram_SubtypeDeclaration::_publish_cc_extern_type_info() {
  if(((_is_scalar_type() == TRUE) || (_is_array_type() == TRUE)) &&
     (_is_access_type() == FALSE))  {
    get_subtype()->_publish_cc_extern_type_info();
    _cc_out << ";\n";
  }
}

IIRScram_Declaration::declaration_type 
IIRScram_SubtypeDeclaration::_get_type(){
   return SUBTYPE;
}

IIR_AttributeSpecificationList*
IIRScram_SubtypeDeclaration::_get_attribute_specification_list(){
  return &attributes;
}

IIR_TypeDefinition *
IIRScram_SubtypeDeclaration::_get_subtype(){
  return get_subtype();
}

IIR_Boolean 
IIRScram_SubtypeDeclaration::_is_scalar_type(){
  return get_subtype()->_is_scalar_type();
}

IIR_Boolean 
IIRScram_SubtypeDeclaration::_is_array_type(){
  return get_subtype()->_is_array_type();
}

IIR_Boolean
IIRScram_SubtypeDeclaration::_is_resolved_type() {
  return get_subtype()->_is_resolved_type();
}

IIR_Boolean
IIRScram_SubtypeDeclaration::_is_kernel_type() {
  if ((IIRScram_TextLiteral::_cmp(_get_declarator(), "integer") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "boolean") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "severity_level") == 0) ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "positive") == 0)       ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "character") == 0)      ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "real") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "time") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "natural") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "bit") == 0)            ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "delay_length") == 0)   || 
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "file_open_kind") == 0) ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "file_open_status") == 0)
      ) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}

void
IIRScram_SubtypeDeclaration::_publish_vhdl_range(ostream &_vhdl_out){
  _publish_vhdl(_vhdl_out);
}

IIR*
IIRScram_SubtypeDeclaration::_clone() {
  return this;
}
