#ifndef LIST_HH
#define LIST_HH

class iterator;
class list_object;

#define INIT_ARRAY_SIZE 3

class list {
  friend class iterator;

public:
  list( iterator * );
  inline list(){
    reset_data();
  }

  ~list( ){
    delete [] iterator_array;
  };

  void register_iterator( iterator * );
  void remove_iterator( iterator * );

  inline int get_num_elements(){
    return num_elements;
  }

  inline list_object *get_head(){
    return head;
  }

  inline list_object *get_tail(){
    return tail;
  }

  // Stick this at the end of the list.  (Doesn't change our current
  // position...)
  void append( list_object * );

  // Stick this at the beginning of the list.  (Doesn't change our
  // current position...)
  void prepend( list_object * );
  
private:
  inline void set_head(  list_object *new_head ){
    head = new_head;
  }

  inline void set_tail(  list_object *new_tail ){
    tail = new_tail;
  }

  inline void new_element(){
    num_elements++;
  }

  void reset_data();

  void removing_element( list_object * );

  list_object *head;
  list_object *tail;

  iterator **iterator_array;
  int iterator_array_size;
  int num_iterators;

  int num_elements;
};

#endif
