
#ifndef IIRBASE_DESIGN_FILE_HH
#define IIRBASE_DESIGN_FILE_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com

#include "IIR.hh"

// These are all instantiated, so they really need to be here.
#include "IIR_DesignFileList.hh"
#include "IIR_CommentList.hh"
#include "IIR_LibraryUnitList.hh"

class IIR_DesignFile;

class IIRBase_DesignFile : public IIR {

public:
  IIR_Kind get_kind() const {return IIR_DESIGN_FILE;}
  IIR_Char *get_kind_text() const {return "IIR_DesignFile";}

  IIR_Identifier *get_name();
  void set_name( IIR_Identifier * );

  static IIR_DesignFileList &get_design_files();
  IIR_CommentList           comments;
  IIR_LibraryUnitList       library_units;

protected:
  IIRBase_DesignFile();
  virtual ~IIRBase_DesignFile() = 0;
    
private:
  IIR_Identifier *my_file_name;
};
#endif





