
#ifndef IIRBASE_PHYSICAL_UNIT_HH
#define IIRBASE_PHYSICAL_UNIT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIR_Declaration.hh"
#include "IIR_AttributeSpecificationList.hh"

class IIR_PhysicalUnit;

class IIRBase_PhysicalUnit : public IIR_Declaration {

public:
  IIR_Kind get_kind() const { return IIR_PHYSICAL_UNIT; }
  IIR_Char *get_kind_text() const { return "IIR_PhysicalUnit"; }

  void set_multiplier(IIR*);
  IIR* get_multiplier();
  void set_unit_name(IIR_PhysicalUnit*);
  IIR_PhysicalUnit* get_unit_name();

  IIR_AttributeSpecificationList attributes;

 protected:
  IIRBase_PhysicalUnit();
  virtual ~IIRBase_PhysicalUnit() = 0;
    
private:
  IIR* multiplier;
  IIR_PhysicalUnit *unit_name;
};

#endif
