
#ifndef IIRSCRAM_ATTRIBUTE_HH
#define IIRSCRAM_ATTRIBUTE_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//          Timothy J. McBrayer 
//          Swaminathan Subramanian

#include "IIRBase_Attribute.hh"

template <class type> class set;
class IIR_Declaration;
class IIR_Identifier;
class IIR_TypeDefinition;
class IIR_SignalDeclaration;
class IIR_ConstantDeclaration;
class IIR_FunctionDeclaration;
class IIR_TypeDeclaration;
class IIR_Attribute;
class IIR_RangeTypeDefinition;
class IIR_ScalarTypeDefinition;
class IIR_NatureDefinition;
class IIR_FreeQuantityDeclaration;
class IIR_BranchQuantityDeclaration;

class IIRScram_Attribute : public IIRBase_Attribute {

public:
  virtual set<IIR_Declaration> *_symbol_lookup();
  virtual set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0); 
  virtual IIR_TypeDefinition *_get_prefix_subtype(IIR_Boolean (IIR::*constraint_function)() = 0); 
  IIR_TypeDefinition *_get_prefix_rval_range_attributes();

  /** High, low, left, and right attributes use these. */
  virtual set<IIR_TypeDefinition> *
  _get_rval_set_high_low_left_right(IIR_Boolean (IIR::*constraint_function)() = 0); 
  virtual IIR_TypeDefinition *_get_subtype_high_low_left_right();


  virtual void _type_check( set<IIR_TypeDefinition> * );

  IIR *_decl_to_decl( IIR_Declaration * );

  virtual void set_suffix( IIR * );
  virtual IIR *get_suffix( );
  
  ostream &_print( ostream &os );

  /** This method gets the declaration that this attribute represents.  If
      the declaration doesn't yet exist, it generates it and puts it in
      the symbol table.  We also pass in the list of possible declarations
      that this attribute is attached to.  For instance, if we have
      foo'quiet, then all of the declarations of "foo". */
  virtual IIR_Declaration *_get_implicit_declaration( const string &implicit_decl_name,
						      IIR_TypeDefinition *implicit_decl_type );

  IIR *_rval_to_decl( IIR_TypeDefinition * );

  /** This function defines the necessary variables that are needed in the 
      _state.hh file */
  virtual void _publish_cc_necessary_decl_in_state( published_file &_cc_out );

  virtual void _publish_cc_name_in_caps( published_file &_cc_out );
  virtual void _publish_cc_attrib_type( published_file &_cc_out );
  virtual void _publish_cc_necessary_decl_init( published_file &_cc_out );
  virtual void _publish_cc_init_val( published_file &_cc_out );
  virtual void _publish_cc_sigtype( published_file &_cc_out );
  virtual void _publish_cc_init_fields_for_signals( published_file &_cc_out );
  virtual void _publish_cc_implicit_signal_declaration( published_file &_cc_out );
  virtual void _publish_cc_implicit_signal_state_object_init( published_file &_cc_out );
  virtual const string _get_cc_type_name();
  virtual void _publish_cc_universal_value( published_file &_cc_out );
  virtual void _publish_cc_bounds( published_file &_cc_out );
  virtual void _publish_cc_as_for_loop( published_file &_cc_out, 
					const char * = "generateConstant" );
  
  void _publish_cc_universal_left( published_file &_cc_out );
  void _publish_cc_universal_right( published_file &_cc_out );
  virtual void _publish_cc_value( published_file &_cc_out );
  virtual void _publish_cc_type_cast( published_file &_cc_out );
  
  virtual void _publish_cc_type_attribute( published_file &_cc_out,
					   const char *attributeString, 
					   IIR_Boolean checkSuffixFlag = FALSE);
  virtual void _publish_cc_headers( published_file &_cc_out );

  virtual void _publish_cc_necessary_copying( published_file &_cc_out );

          void _publish_cc_necessary_attribute_copying( published_file &_cc_out,
							SignalAttribute attrib, 
							const char *objectSuffix);

  virtual void _publish_cc_read_or_write( published_file &_cc_out, 
					  const string &,
					  const string & );

  virtual void _publish_cc_attribute_read_or_write( published_file &_cc_out,
						    SignalAttribute attrib, 
						    const string &, 
						    const string &,
						    const string & );
  
  void _get_list_of_input_signals( set<IIR> *list) ;  
  void _build_sensitivity_list(IIR_DesignatorList*);

  virtual IIR_Boolean _has_suffix();

  IIR_SignalDeclaration *_build_signal_declaration( const string &, IIR_TypeDefinition * );
  IIR_ConstantDeclaration *_build_constant_declaration( const string &, IIR_TypeDefinition * );
  IIR_TypeDeclaration *_build_type_declaration( const string &, IIR_TypeDefinition * );
  IIR_FunctionDeclaration *_build_function_declaration( const string &,
							IIR_TypeDefinition *return_type,
							IIR_TypeDefinition *argument_type = NULL );

  /** This method takes a predefined attribute of a terminal or a free
      quantity (in VHDL-AMS) and builds an IIR_FreeQuantityDeclaration.*/
  IIR_FreeQuantityDeclaration *_build_free_quantity_declaration( const string &,
								 IIR_TypeDefinition *);
 
  /** This method takes a predefined attribute of a branch quantity
      (in VHDL-AMS) and builds an IIR_BranchQuantityDeclaration. */
  IIR_BranchQuantityDeclaration *_build_branch_quantity_declaration( const string &
								     ,IIR_TypeDefinition *);
  
  /** This method takes a 'range or 'reverse_range attribute, and builds an
      IIR_RangeTypeDefinition in the form of prefix'left to
      prefix'right.  */
  virtual IIR_RangeTypeDefinition *_build_range_type();

  virtual IIR_Boolean _is_iir_attribute(){ return TRUE; }

  virtual IIR_Boolean _is_resolved();
  
  virtual IIR_Boolean _is_attribute(){ return TRUE; }
  virtual IIR_Boolean _is_readable(){ return TRUE; }

  virtual IIR_Boolean _is_value_attribute(){ return FALSE; }
  virtual IIR_Boolean _is_type_attribute(){ return FALSE; }
  virtual IIR_Boolean _is_range_attribute(){ return FALSE; }
  virtual IIR_Boolean _is_function_attribute(){ return FALSE; }
  virtual IIR_Boolean _is_signal_attribute(){ return FALSE; }
  virtual IIR_Boolean _is_above_attribute() { return FALSE; }

  IIR_Declaration *_get_implicit_declaration();
  void _set_implicit_declaration( IIR_Declaration * );

  IIR_TypeDefinition* _get_explicit_signal_type();
  const string _get_cc_signal_attribute_type_suffix();
  const string _get_cc_signal_attribute_subelement_type();
  const string _get_cc_signal_attribute_subelement_type( SignalAttribute attrib );
  
  virtual IIR_Boolean _is_quiet_attribute() { return FALSE; }
  virtual IIR_Boolean _is_stable_attribute() { return FALSE; }
  virtual IIR_Boolean _is_transaction_attribute() { return FALSE; }
  virtual IIR_Boolean _is_event_attribute() { return FALSE; }
  virtual IIR_Boolean _is_active_attribute() { return FALSE; }
  virtual IIR_Boolean _is_lastevent_attribute() { return FALSE; }
  virtual IIR_Boolean _is_lastactive_attribute() { return FALSE; }
  virtual IIR_Boolean _is_lastvalue_attribute() { return FALSE; }
  virtual IIR_Boolean _is_driving_attribute() { return FALSE; }
  virtual IIR_Boolean _is_drivingvalue_attribute() { return FALSE; }
  virtual IIR_Boolean _is_delayed_attribute() { return FALSE; }
  virtual IIR_Boolean _is_signal() { return FALSE; };

  void _publish_cc_declarator( published_file &_cc_out );
  void _publish_cc_signal_attribute_suffix( published_file &_cc_out );

  /** If you hit this, an attribute has an unimplemented clone(). */
  virtual IIR *_clone();
  virtual void _clone( IIR * );

  void _add_decl_into_cgen_symbol_table();

  IIR_TextLiteral *_get_attribute_name();

  set<IIR_Declaration> *_get_implicit_declarations(){ return _my_implicit_decls; }
  void _set_implicit_declarations( set<IIR_Declaration> *id ){ _my_implicit_decls = id; }

  IIR_Boolean _is_locally_static_primary();
  IIR_Boolean _is_globally_static_primary();

  void _publish_cc_extern_type_info( published_file &_cc_out );

  /** This method does the subtype calculation for IIR_Range and
      IIR_ReverseRange attributes.  In the case of some error, NULL is
      returned. */
  IIR_ScalarTypeDefinition *_get_subtype_range_attribute();

protected:
  IIRScram_Attribute() : implicit_declaration( NULL ),
			 my_attribute_name( NULL ),
			 _my_implicit_decls( NULL ){ }
  virtual ~IIRScram_Attribute() = 0;
  

  virtual void _resolve_suffix_special();
  void _resolve_suffix_base_type_of_prefix();
  void _resolve_suffix_local_static_int();
  void _resolve_suffix_non_negative_time();

  /** This returns an IIR_TextLiteral with the name of whatever attribute
      was instantiated. */
  virtual IIR_TextLiteral *_build_attribute_name();

  IIR_Declaration *_get_actual_signal_declaration();
  void _check_and_add_necessary_decls();

  void _publish_cc_necessary_decl_in_state_last_event( published_file &_cc_out );
  
  void _publish_cc_signal_attribute( published_file &_cc_out,
				     const char *attributeString, 
				     IIR_Boolean checkSuffixFlag = FALSE);

  void _publish_cc_necessary_signal_decl_in_state( published_file &_cc_out,
						   SignalAttribute attrib,
						   const char *objectSuffix);

  void _publish_cc_signal_attribute_subelement_type_suffix( published_file &_cc_out,
							    SignalAttribute attrib);

  void _publish_cc_necessary_signal_state_object_init( published_file &_cc_out,
						       SignalAttribute attrib, 
						       const char *objectSuffix, 
						       IIR_Boolean implicitSignal = FALSE);  

  void _publish_cc_necessary_signal_init( published_file &_cc_out,
					  SignalAttribute attrib,
					  const char *objectSuffix, 
					  IIR_Boolean implicitSignal = FALSE);

  void _publish_cc_default_initial_universal_value( published_file &_cc_out,
						    SignalAttribute attrib );

  void _publish_cc_signal_attribute_subelement_type_info( published_file &_cc_out, 
							  SignalAttribute );
  
  IIR_Boolean _need_to_process_prefix_prefix_signal_attribute();

private:
  void _resolve_prefix();
  void _resolve_suffix();

  virtual IIR_Boolean _need_to_process_prefix_prefix(){ return FALSE; }
  void _process_prefix_prefix( IIR_TypeDefinition *resolved_rval );
  
  IIR_Declaration *implicit_declaration;
  IIR_TextLiteral *my_attribute_name;
  set<IIR_Declaration> *_my_implicit_decls;
};

#endif
