#ifndef IIRSCRAM_RIGHT_OF_ATTRIBUTE_HH
#define IIRSCRAM_RIGHT_OF_ATTRIBUTE_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_RightOfAttribute.hh"

class IIRScram_RightOfAttribute : public IIRBase_RightOfAttribute {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
 
  IIR_TextLiteral *_build_attribute_name();

  IIR_TypeDefinition *get_subtype();
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR_Declaration *_get_implicit_declaration( const string &, IIR_TypeDefinition * );

  IIR_Boolean _has_suffix(){ return TRUE; }
  void _set_suffix( IIR *new_suffix ){ set_suffix( new_suffix ); }

  IIR_Boolean _is_function_attribute(){ return TRUE; }

protected:
  void _resolve_suffix_special();

  IIRScram_RightOfAttribute(){}

  virtual ~IIRScram_RightOfAttribute() = 0;
    
private:
};
#endif
