/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.storage;

import com.sun.midp.io.ConnectionBaseAdapter;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityDomain;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessStream
extends ConnectionBaseAdapter {
    public static final int READ_WRITE_TRUNCATE = -3;
    private int handle = -1;

    public RandomAccessStream() {
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            midletSuite.checkIfPermitted(9);
        }
    }

    public RandomAccessStream(SecurityDomain callerSecurityDomain) {
        callerSecurityDomain.checkIfPermitted(9);
    }

    public void connect(String name, int mode, boolean timeouts) throws IOException {
        this.connect(name, mode);
    }

    public void connect(String name, int mode) throws IOException {
        if (this.handle != -1) {
            throw new IOException("Disconnect the stream before reconnecting.");
        }
        byte[] asciiFilename = File.toCString(name);
        this.handle = RandomAccessStream.open(asciiFilename, mode);
        this.connectionOpen = true;
    }

    public void disconnect() throws IOException {
        if (this.handle == -1) {
            return;
        }
        RandomAccessStream.close(this.handle);
        this.handle = -1;
        this.connectionOpen = false;
    }

    public int readBytes(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int test = b[off] + b[len - 1] + b[off + len - 1];
        return RandomAccessStream.read(this.handle, b, off, len);
    }

    protected int readBytesNonBlocking(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int writeBytes(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int test = b[off] + b[len - 1] + b[off + len - 1];
        RandomAccessStream.write(this.handle, b, off, len);
        return len;
    }

    public int writeStream(InputStream in) throws IOException {
        byte[] temp = new byte[1024];
        int totalBytesWritten = 0;
        int bytesRead;
        while ((bytesRead = in.read(temp)) != -1) {
            this.writeBytes(temp, 0, bytesRead);
            totalBytesWritten += bytesRead;
        }
        return totalBytesWritten;
    }

    public void setPosition(int absolutePosition) throws IOException {
        RandomAccessStream.position(this.handle, absolutePosition);
    }

    public int getSizeOf() throws IOException {
        return RandomAccessStream.sizeOf(this.handle);
    }

    public void truncate(int size) throws IOException {
        RandomAccessStream.truncateStream(this.handle, size);
    }

    private static native int open(byte[] var0, int var1) throws IOException;

    private static native void close(int var0) throws IOException;

    private static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    private static native void write(int var0, byte[] var1, int var2, int var3) throws IOException;

    private static native void position(int var0, int var1) throws IOException;

    private static native int sizeOf(int var0) throws IOException;

    private static native void truncateStream(int var0, int var1) throws IOException;
}

