/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.scalatest.PrintReporter$;
import org.scalatest.Report;
import org.scalatest.Reporter;
import org.scalatest.Reporter$class;
import org.scalatest.Resources$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.runtime.BoxesRunTime;

public abstract class PrintReporter
implements Reporter,
ScalaObject {
    private int suitesAbortedCount;
    private int testsFailedCount;
    private int testsCompletedCount;
    private final PrintWriter pw;

    public PrintReporter(PrintWriter pw) {
        this.pw = pw;
        this.testsCompletedCount = 0;
        this.testsFailedCount = 0;
        this.suitesAbortedCount = 0;
        Reporter$class.$init$(this);
    }

    private void makeReport(Report report, String resourceName) {
        Option option;
        block6: {
            block5: {
                block4: {
                    Report report2 = report;
                    if (report2 == null || report2.equals(null)) {
                        throw new NullPointerException("report is null");
                    }
                    String name = report.name();
                    String message = report.message();
                    Option throwable = report.throwable();
                    String stringToPrint = Resources$.MODULE$.apply(resourceName, name, message);
                    this.pw.println(stringToPrint);
                    option = throwable;
                    if (!(option instanceof Some)) break block4;
                    ((Throwable)((Some)option).x()).printStackTrace(this.pw);
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
            }
            this.pw.flush();
            return;
        }
        throw new MatchError((Object)option);
    }

    private void makeFinalReport(String resourceName) {
        this.printResourceStringWithInt(resourceName, this.testsCompletedCount());
        if (this.suitesAbortedCount() == 1) {
            this.printResourceString("oneSuiteAborted");
        } else if (this.suitesAbortedCount() > 1) {
            this.printResourceStringWithInt("multipleSuitesAborted", this.suitesAbortedCount());
        }
        if (this.testsFailedCount() == 1) {
            this.printResourceString("oneTestFailed");
        } else if (this.testsFailedCount() > 1) {
            this.printResourceStringWithInt("multipleTestsFailed", this.testsFailedCount());
        } else if (this.suitesAbortedCount() == 0) {
            this.printResourceString("allTestsPassed");
        }
        this.pw.flush();
    }

    private void printResourceString(String resourceName) {
        this.pw.println(Resources$.MODULE$.apply(resourceName));
        this.pw.flush();
    }

    private void printResourceStringWithInt(String resourceName, int testCount) {
        String stringToReport = Resources$.MODULE$.apply(resourceName, ((Object)BoxesRunTime.boxToInteger((int)testCount)).toString());
        this.pw.println(stringToReport);
        this.pw.flush();
    }

    public void dispose() {
        this.pw.close();
    }

    public void runCompleted() {
        this.makeFinalReport("runCompleted");
    }

    public void runAborted(Report report) {
        this.makeReport(report, "runAborted");
    }

    public void runStopped() {
        this.makeFinalReport("runStopped");
    }

    public void suiteAborted(Report report) {
        this.suitesAbortedCount_$eq(this.suitesAbortedCount() + 1);
        this.makeReport(report, "suiteAborted");
    }

    public void suiteCompleted(Report report) {
        this.makeReport(report, "suiteCompleted");
    }

    public void suiteStarting(Report report) {
        this.makeReport(report, "suiteStarting");
    }

    public void infoProvided(Report report) {
        this.makeReport(report, "infoProvided");
    }

    public void testFailed(Report report) {
        this.makeReport(report, "testFailed");
        this.testsCompletedCount_$eq(this.testsCompletedCount() + 1);
        this.testsFailedCount_$eq(this.testsFailedCount() + 1);
    }

    public void testIgnored(Report report) {
        this.makeReport(report, "testSucceeded");
    }

    public void testSucceeded(Report report) {
        this.makeReport(report, "testSucceeded");
        this.testsCompletedCount_$eq(this.testsCompletedCount() + 1);
    }

    public void testStarting(Report report) {
        this.makeReport(report, "testStarting");
    }

    public void runStarting(int testCount) {
        if (testCount < 0) {
            throw new IllegalArgumentException();
        }
        this.testsCompletedCount_$eq(0);
        this.testsFailedCount_$eq(0);
        this.suitesAbortedCount_$eq(0);
        this.printResourceStringWithInt("runStarting", testCount);
    }

    public PrintReporter(String filename) {
        this(new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File(filename)), PrintReporter$.MODULE$.BufferSize())));
    }

    public PrintReporter(OutputStream os) {
        this(new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(os, PrintReporter$.MODULE$.BufferSize()))));
    }

    private void suitesAbortedCount_$eq(int x$1) {
        this.suitesAbortedCount = x$1;
    }

    private int suitesAbortedCount() {
        return this.suitesAbortedCount;
    }

    private void testsFailedCount_$eq(int x$1) {
        this.testsFailedCount = x$1;
    }

    private int testsFailedCount() {
        return this.testsFailedCount;
    }

    private void testsCompletedCount_$eq(int x$1) {
        this.testsCompletedCount = x$1;
    }

    private int testsCompletedCount() {
        return this.testsCompletedCount;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

