/* ---------------------------------------------------------------------
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     November 17, 1996
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "../SRC/pblas.h"

#if( _F2C_CALL_ == _F2C_ADD_ )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in).
* No redefinition necessary to have following FORTRAN to C interface:
*           FORTRAN CALL               C DECLARATION
*           call pdgemm(...)           void pdgemm_(...)
*
* This is the default.
*/

#endif

#if( _F2C_CALL_ == _F2C_UPCASE )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in)
* following FORTRAN to C interface:
*           FORTRAN CALL               C DECLARATION
*           call pdgemm(...)           void PDGEMM(...)
*/

#define geterr_           GETERR

#endif

#if( _F2C_CALL_ == _F2C_NOCHANGE )
/*
* These defines set up the naming scheme required to have a FORTRAN
* routine call a C routine (which is what the PBLAS are written in)
* for following FORTRAN to C interface:
*           FORTRAN CALL               C DECLARATION
*           call pdgemm(...)           void pdgemm(...)
*/

#define geterr_           geterr

#endif

void pberror_( ctxt, mess, einfo )
/*
*  .. Scalar Arguments ..
*/
   int         * ctxt, * einfo;
/* ..
*  .. Array Arguments ..
*/
   char        * mess;
{
/*
*  Purpose
*  =======
*
*  pberror_ is an error handler of the PBLAS routines, displays an error
*  message on stderr, and stops the running program. This is the tester
*  version.
*
* ======================================================================
*
*  .. Parameters ..
*/
#define DESCMULT      100
#define BIGNUM      10000
/* ..
*  .. Local Scalars ..
*/
   int         abrtflg, iinfo, mycol, myrow, npcol, nprow;
/* ..
*  .. External Functions ..
*/
   void        blacs_abort_();
   void        blacs_gridinfo_();
   F_VOID_FCT  geterr_();
/* ..
*  .. Executable Statements ..
*/ 

   geterr_( einfo, &abrtflg );

   if( abrtflg )
   {

      blacs_gridinfo_( ctxt, &nprow, &npcol, &myrow, &mycol );

      iinfo = *einfo;
      if( iinfo < 0 )
      {
         iinfo = -iinfo;
         if( iinfo < DESCMULT )
         {
            fprintf( stderr, "{%5d,%5d}: On entry to %s ", myrow, mycol,
                     mess );
            fprintf( stderr, "parameter number %2d had an illegal value\n",
                     iinfo );
         }
         else
         {
            fprintf( stderr, "{%5d,%5d}: On entry to %s ", myrow, mycol,
                     mess );
            fprintf( stderr, "parameter number %2d had an illegal value\n",
                     iinfo / DESCMULT );
            fprintf( stderr, "entry # %2d had an illegal value\n",
                     iinfo % DESCMULT );
         }
      }
      else
      {
         fprintf( stderr,
                  "{%5d,%5d}: Positive error code %2d returned by %s !!!\n",
                  myrow, mycol, iinfo, mess );
      }
      blacs_abort_( ctxt, &iinfo );
   }
}
