/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_legends_dialog.h"
#include "sg.h"
#include "sg_dialogs.h"

static GtkWidget *border_combo; 
static GtkWidget *fg_combo; 
static GtkWidget *bg_combo; 
static GtkWidget *left_entry, *top_entry;
static GtkWidget *font_combo;
static GtkWidget *legends_item;
static GtkPlot *plot;
SGlayer *the_layer;

void
sg_legends_dialog_update_plot(GtkWidget *widget)
{
  SGplot *parent;
  GtkWidget *child;
  GtkColorCombo *combo;
  GdkColor fg, bg;
  gchar *color_name;
  gdouble x, y;
  gchar *font_name;
  gint font_height;

  child = (GtkWidget *)GTK_LIST(GTK_COMBO(border_combo)->list)->selection->data;
  plot->legends_border = (GtkPlotBorderStyle)gtk_list_child_position(GTK_LIST(GTK_COMBO(border_combo)->list), child);

  x = atof(gtk_entry_get_text(GTK_ENTRY(left_entry)));
  y = atof(gtk_entry_get_text(GTK_ENTRY(top_entry)));
  plot->legends_x = x;
  plot->legends_y = y;

  combo = GTK_COLOR_COMBO(fg_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &fg);
  gdk_color_alloc(fg_combo->style->colormap, &fg);

  combo = GTK_COLOR_COMBO(bg_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &bg);
  gdk_color_alloc(bg_combo->style->colormap, &bg);

  font_name = GTK_FONT_COMBO(font_combo)->psfont->psname;
  font_height = GTK_FONT_COMBO(font_combo)->height;

  gtk_plot_legends_set_attributes(plot, font_name, font_height, &fg, &bg);

  plot->show_legends = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(legends_item));

  parent = (SGplot *)the_layer->parent;
  gtk_plot_canvas_paint(GTK_PLOT_CANVAS(parent->real_canvas));
  gtk_plot_canvas_refresh(GTK_PLOT_CANVAS(parent->real_canvas));
}

static void
init_dialog()
{
  GtkPSFont *font;
  gchar label[100];

  sg_color_combo_init(GTK_COLOR_COMBO(fg_combo), plot->legends_attr.fg);
  sg_color_combo_init(GTK_COLOR_COMBO(bg_combo), plot->legends_attr.bg);

  gtk_list_select_item(GTK_LIST(GTK_COMBO(border_combo)->list), plot->legends_border);

  sprintf(label, "%*.*f", 1, 3, plot->legends_x);
  gtk_entry_set_text(GTK_ENTRY(left_entry), label);
  sprintf(label, "%*.*f", 1, 3, plot->legends_y);
  gtk_entry_set_text(GTK_ENTRY(top_entry), label);

  font = gtk_psfont_get_font(plot->legends_attr.font);
  gtk_font_combo_select(GTK_FONT_COMBO(font_combo),
                        font->family,
                        font->bold,
                        font->italic,
                        plot->legends_attr.height);

  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(legends_item),
                              plot->show_legends);

}

GtkWidget *
sg_legends_dialog_new (SGlayer *layer)
{
  GtkWidget *frame;
  GtkWidget *main_box, *main_table;
  GtkWidget *table;
  GtkRequisition req;

  the_layer = layer;
  
  plot = GTK_PLOT(layer->real_plot);

  /* Create widgets */
  main_box = gtk_hbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 5);

  main_table = gtk_table_new(2,2,FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(main_table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(main_table), 2);
  gtk_table_set_row_spacings(GTK_TABLE(main_table), 2);
  gtk_box_pack_start (GTK_BOX (main_box), main_table, FALSE, FALSE, 0);
/*----------------------------------------------*/
  frame = gtk_frame_new("Position");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 0, 1, 0, 1);

  table=gtk_table_new(3, 3, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("left offset "), 0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("top offset "), 0, 1, 2, 3);
  left_entry = gtk_entry_new();
  top_entry = gtk_entry_new();

  gtk_widget_size_request(left_entry, &req);
  req.width /= 2;
  gtk_widget_set_usize(left_entry, req.width, req.height);
  gtk_widget_set_usize(top_entry, req.width, req.height);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Units in % of page size"), 0, 3, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), left_entry, 1, 2, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), top_entry, 1, 2, 2, 3);

  
 /*--------------------------------------*/
  frame = gtk_frame_new("Properties");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 1, 2, 0, 1);

  table=gtk_table_new(4, 3, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Foreground"), 0, 1, 0, 1);
  fg_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), fg_combo, 1, 2, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Background"), 0, 1, 1, 2);
  bg_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), bg_combo, 1, 2, 1, 2);

  gtk_table_attach_defaults(GTK_TABLE(table), 
                            gtk_label_new("Border"), 0, 1, 2, 3);
  border_combo = gtk_combo_new();
  gtk_widget_set_usize(border_combo, req.width, req.height);
  sg_combo_set_items(GTK_COMBO(border_combo), border_styles);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(border_combo)->entry), FALSE);
  gtk_table_attach_defaults(GTK_TABLE(table), border_combo, 1, 2, 2, 3);

  legends_item = gtk_check_item_new_with_label("show legends");
  gtk_table_attach_defaults(GTK_TABLE(table), legends_item, 0, 2, 3, 4);

/*--------------------------------------*/
  frame = gtk_frame_new("Font");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 0, 2, 1, 2);

  font_combo = gtk_font_combo_new();
  gtk_container_add(GTK_CONTAINER(frame), font_combo);
  gtk_container_set_border_width(GTK_CONTAINER(font_combo), 5);
/*--------------------------------------*/
  /* connect signals */
  init_dialog();

  sg_entry_set_numeric(GTK_ENTRY(left_entry), 3);
  sg_entry_set_numeric(GTK_ENTRY(top_entry), 3);

  return main_box;

}
