// ==========================================================
// Definition of CelestLab "constants"
// 
// Syntax: 
// data.name = value
// (scilab syntax)
// 
// Warning: 
// Do not modify the names of variables and their values
// as a change would cause errors and/or invalid results.
// ==========================================================

// Degrees to radians conversion 
data.deg2rad = %pi/180

// Radians to degrees conversion
data.rad2deg = 180/%pi

// Critical inclinations (so that drift of argument of perigee = 0) [rad]
// (mean drift due to J2 only)
// sin(criticalInc) = 2/sqrt(5)
data.criticalInc1 = 1.1071487177940905030170654601785370400 
data.criticalInc2 = 2.0344439357957027354455779231009658441  

// Margins for orbit types 
// if eccentricity < epsOrb.cir       => circular orbit
// if eccentricity <= 1-epsOrb.parab  => elliptic orbit
// if eccentricity >= 1+epsOrb.parab  => hyperbolic orbit, parabolic otherwise
// if sin(inclination) < epsOrb.equa  => equatorial orbit

data.epsOrb.cir   = 1.e-10    
data.epsOrb.parab = 1.e-10  
data.epsOrb.equa  = 1.e-10 
