// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) DIGITEO - 2009 - Allan CORNET
// 
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//==========================================
function ilib_gen_cleaner(makename,loadername,files)

  [lhs,rhs] = argn(0);

  if (rhs < 1) then
    makename = 'makelib';
  end

  if (rhs < 2) then
    loadername = 'loader.sce';
  end
  
  if (rhs < 3) then
    files = [];
  end

  cleanername = 'cleaner.sce';

  fd = mopen(cleanername,"wt");
  mfprintf(fd,"// This file is released into the public domain\n");
  mfprintf(fd,"// Generated by builder.sce : Please, do not edit this file\n");
  mfprintf(fd,"// cleaner.sce\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"curdir = pwd();\n");
  mfprintf(fd,"cleaner_path = get_file_path(''cleaner.sce'');\n");
  mfprintf(fd,"chdir(cleaner_path);\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"if fileinfo(''%s'') <> [] then\n",loadername);
  mfprintf(fd,"  mdelete(''%s'');\n",loadername);
  mfprintf(fd,"end\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  
  if MSDOS then
    make_command = get_make_command(makename);  
    mfprintf(fd,"if fileinfo(''%s%s'') <> [] then\n",makename,get_makefile_ext());
    mfprintf(fd,"  unix_s(''%s'');\n",make_command);  
    mfprintf(fd,"  mdelete(''%s%s'');\n",makename,get_makefile_ext());
    mfprintf(fd,"end\n");
    mfprintf(fd,"// ------------------------------------------------------\n");
  end 

  if files <> [] then 
    for i = 1:size(files,'*')
      if ( files(i) <> '' ) then
        mfprintf(fd,"if fileinfo(''%s'') <> [] then\n", files(i));
        mfprintf(fd,"  mdelete(''%s'');\n", files(i));
        mfprintf(fd,"end\n");
        mfprintf(fd,"// ------------------------------------------------------\n");
      end
    end
  end

  mfprintf(fd,"chdir(curdir);\n");
  mfprintf(fd,"// ------------------------------------------------------\n");  
  mclose(fd);

  if ilib_verbose() > 1 then
    disp(mgetl('cleaner.sce'));
  end
endfunction
//==========================================
function cmd = get_make_command(makename)
  if MSDOS then // WINDOWS
    // Visual Studio C++ 
    if ( findmsvccompiler() <> 'unknown' ) then 
      cmd = 'nmake /Y /nologo /f ' + makename + '.mak' + ' clean';
    else
      // LCC-WIN32
      if findlcccompiler() then
        cmd = 'make -f ' + makename + '.lcc' + ' clean';
      else
      // TO DO : Add another compiler here
      end
    end
  else // LINUX
    cmd = 'make ' + makename + ' clean'; 
  end  
endfunction
//==========================================
function ext = get_makefile_ext()
  if MSDOS then // WINDOWS
    // Visual Studio C++ 
    if ( findmsvccompiler() <> 'unknown' ) then 
      ext = '.mak';
    else
      // LCC-WIN32
      if findlcccompiler() then
        ext = '.lcc';
      else
      // TO DO : Add another compiler here
      end
    end
  else // LINUX
    ext = '';
  end  
endfunction
//==========================================
