/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2004-2006 - INRIA - Fabrice Leray
 * Copyright (C) 2006 - INRIA - Allan Cornet
 * Copyright (C) 2006 - INRIA - Jean-Baptiste Silvy
 * Copyright (C) 2009 - DIGITEO - Pierre Lando
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

/*------------------------------------------------------------------------*/
/* file: get_box_property.c                                               */
/* desc : function to retrieve in Scilab the box field of                 */
/*        a handle                                                        */
/*------------------------------------------------------------------------*/

#include "getHandleProperty.h"
#include "GetProperty.h"
#include "returnProperty.h"
#include "Scierror.h"
#include "localization.h"
/*------------------------------------------------------------------------*/
int get_box_property( sciPointObj * pobj )
{
  if ( sciGetEntityType ( pobj ) == SCI_SUBWIN )
  {
    switch( sciGetBoxType( pobj ) )
    {
    case BT_OFF:
      return sciReturnString( "off" ) ;
      break ;
    case BT_ON:
      return sciReturnString( "on" ) ;
      break ;
    case BT_HIDDEN_AXES:
      return sciReturnString( "hidden_axes" ) ;
      break ;
    case BT_BACK_HALF:
      return sciReturnString( "back_half" ) ;
      break ;
    }
  }
  else if (sciGetEntityType( pobj ) == SCI_TEXT)
  {
    if ( sciGetIsBoxed(pobj) )
    {
      return sciReturnString( "on" ) ;
    }
    else
    {
      return sciReturnString( "off" ) ;  
    }
  }
	Scierror(999, _("'%s' property does not exist for this handle.\n"),"box") ;
  return -1 ;
}
/*------------------------------------------------------------------------*/
