;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribetex/tex.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:03:53 2001                          */
;*    Last change :  Fri Jan 18 11:44:53 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The translator scribe->tex                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribetex_tex
   
   (library scribeapi)
   
   (export  *scribe-tex-packages*
	    *scribe-tex-image-native*
	    *scribe-tex-image-convert*
	    *scribe-tex-title*
	    *scribe-tex-maketitle*
	    *scribe-tex-authors*
	    *scribe-tex-author-start*
	    *scribe-tex-author-stop*
	    *scribe-tex-author-hook*
	    *scribe-tex-document-class*
	    
	    (generic tex ::obj))

   (eval    (export *scribe-tex-packages*)
	    (export *scribe-tex-image-native*)
	    (export *scribe-tex-image-convert*)
	    (export *scribe-tex-title*)
	    (export *scribe-tex-maketitle*)
	    (export *scribe-tex-authors*)
	    (export *scribe-tex-author-start*)
	    (export *scribe-tex-author-stop*)
	    (export *scribe-tex-author-hook*)
	    (export *scribe-tex-document-class*)))

;*---------------------------------------------------------------------*/
;*    *scribe-tex-packages* ...                                        */
;*---------------------------------------------------------------------*/
(define *scribe-tex-packages* '())

;*---------------------------------------------------------------------*/
;*    *scribe-tex-image-native* ...                                    */
;*---------------------------------------------------------------------*/
(define *scribe-tex-image-native*
   '("ps" "eps"))

;*---------------------------------------------------------------------*/
;*    *scribe-tex-image-convert* ...                                   */
;*---------------------------------------------------------------------*/
(define *scribe-tex-image-convert*
   '(("gif" "convert")
     ("jpeg" "convert")
     ("xpm" "convert")
     ("bitmap" "convert")))

;*---------------------------------------------------------------------*/
;*    Custom variables                                                 */
;*---------------------------------------------------------------------*/
(define *scribe-tex-title* "\\title")
(define *scribe-tex-maketitle* "\\maketitle")
(define *scribe-tex-authors* "\\author")
(define *scribe-tex-author-start* #f)
(define *scribe-tex-author-stop* "\\\\")
(define *scribe-tex-author-hook* #f)
(define *scribe-tex-document-class* #f)

;*---------------------------------------------------------------------*/
;*    *alltt* ...                                                      */
;*---------------------------------------------------------------------*/
(define *alltt* #f)
(define *tt* #f)

;*---------------------------------------------------------------------*/
;*    tex-string ...                                                   */
;*---------------------------------------------------------------------*/
(define (tex-string str::bstring)
   (let ((len (string-length str)))
      (let loop ((r 0)
		 (nlen len))
	 (if (=fx r len)
	     (if (=fx nlen len)
		 str
		 (let ((res (make-string nlen)))
		    (let loop ((r 0)
			       (w 0))
		       (if (=fx w nlen)
			   res
			   (let ((c (string-ref str r)))
			      (case c
				 ((#\\)
				  (blit-string! "{\\char92}" 0 res w 9)
				  (loop (+fx r 1) (+fx w 9)))
				 ((#\^)
				  (blit-string! "{\\char94}" 0 res w 9)
				  (loop (+fx r 1) (+fx w 9)))
				 ((#\{)
				  (blit-string! "{\\char123}" 0 res w 10)
				  (loop (+fx r 1) (+fx w 10)))
				 ((#\})
				  (blit-string! "{\\char125}" 0 res w 10)
				  (loop (+fx r 1) (+fx w 10)))
				 ((#\<)
				  (if *alltt*
				      (begin
					 (string-set! res w c)
					 (loop (+fx r 1) (+fx w 1)))
				      (begin
					 (blit-string! "$<$" 0 res w 3)
					 (loop (+fx r 1) (+fx w 3)))))
				 ((#\>)
				  (if *alltt*
				      (begin
					 (string-set! res w c)
					 (loop (+fx r 1) (+fx w 1)))
				      (begin
					 (blit-string! "$>$" 0 res w 3)
					 (loop (+fx r 1) (+fx w 3)))))
				 ((#\& #\$ #\# #\_ #\%)
				  (string-set! res w #\\)
				  (string-set! res (+fx 1 w) c)
				  (loop (+fx r 1) (+fx w 2)))
				 ((#\~)
				  (blit-string! "$_{\\mbox{\\char126}}$" 0 res w 20)
				  (loop (+fx r 1) (+fx w 20)))
				 ((#\)
				  (blit-string! "\\`{a}" 0 res w 5)
				  (loop (+fx r 1) (+fx w 5)))
				 ((#\)
				  (blit-string! "\\'{e}" 0 res w 5)
				  (loop (+fx r 1) (+fx w 5)))
				 ((#\)
				  (blit-string! "\\`{e}" 0 res w 5)
				  (loop (+fx r 1) (+fx w 5)))
				 ((#\)
				  (blit-string! "\\^{e}" 0 res w 5)
				  (loop (+fx r 1) (+fx w 5)))
				 ((#\)
				  (blit-string! "\\`{u}" 0 res w 5)
				  (loop (+fx r 1) (+fx w 5)))
				 ((#a248)
				  (blit-string! "{\\o}" 0 res w 4)
				  (loop (+fx r 1) (+fx w 4)))
				 ((#\)
				  (blit-string! "\\^\\i" 0 res w 4)
				  (loop (+fx r 1) (+fx w 4)))
				 ((#\)
				  (blit-string! "\\\"\\i" 0 res w 4)
				  (loop (+fx r 1) (+fx w 4)))
				 ((#\- #\/)
				  (if (not *tt*)
				      (begin
					 (string-set! res w c)
					 (loop (+fx r 1) (+fx w 1)))
				      (begin
					 (string-set! res w #\\)
					 (string-set! res (+fx w 1) #\-)
					 (string-set! res (+fx w 2) c)
					 (loop (+fx r 1) (+fx w 3)))))
				 (else
				  (string-set! res w c)
				  (loop (+fx r 1) (+fx w 1)))))))))
	     (case (string-ref str r)
		((#\\ #\^)
		 (loop (+fx r 1) (+fx nlen 8)))
		((#\< #\>)
		 (loop (+fx r 1) (if *alltt* nlen (+fx nlen 2))))
		((#\{ #\})
		 (loop (+fx r 1) (+fx nlen 9)))
		((#\~)
		 (loop (+fx r 1) (+fx nlen 19)))
		((#\& #\$ #\# #\_ #\%)
		 (loop (+fx r 1) (+fx nlen 1)))
		((#\ #\ #\ #\ #\)
		 (loop (+fx r 1) (+fx nlen 4)))
		((#\ #\ #a248)
		 (loop (+fx r 1) (+fx nlen 3)))
		((#\- #\/)
		 (loop (+fx r 1) (if *tt* (+fx nlen 2) nlen)))
		(else
		 (loop (+fx r 1) nlen)))))))

;*---------------------------------------------------------------------*/
;*    ref-string ...                                                   */
;*---------------------------------------------------------------------*/
(define (ref-string str)
   (define (inner str)
      (let ((len (string-length str)))
	 (let loop ((r 0)
		    (nlen len))
	    (if (=fx r len)
		(if (=fx nlen len)
		    str
		    (let ((res (make-string nlen)))
		       (let loop ((r 0)
				  (w 0))
			  (if (=fx w nlen)
			      res
			      (let ((c (string-ref str r)))
				 (case c
				    ((#\\)
				     (blit-string! "{\\char92}" 0 res w 9)
				     (loop (+fx r 1) (+fx w 9)))
				    ((#\^)
				     (blit-string! "{\\char94}" 0 res w 9)
				     (loop (+fx r 1) (+fx w 9)))
				    ((#\<)
				     (if *alltt*
					 (begin
					    (string-set! res w c)
					    (loop (+fx r 1) (+fx w 1)))
					 (begin
					    (blit-string! "$<$" 0 res w 3)
					    (loop (+fx r 1) (+fx w 3)))))
				    ((#\>)
				     (if *alltt*
					 (begin
					    (string-set! res w c)
					    (loop (+fx r 1) (+fx w 1)))
					 (begin
					    (blit-string! "$>$" 0 res w 3)
					    (loop (+fx r 1) (+fx w 3)))))
				    ((#\& #\$ #\# #\_ #\% #\-)
				     (string-set! res w #\B)
				     (string-set! res (+fx 1 w) #\Y)
				     (loop (+fx r 1) (+fx w 2)))
				    ((#\~)
				     (blit-string! "$_{\\mbox{\\char126}}$" 0 res w 20)
				     (loop (+fx r 1) (+fx w 20)))
				    ((#\)
				     (blit-string! "\\`{a}" 0 res w 5)
				     (loop (+fx r 1) (+fx w 5)))
				    ((#\)
				     (blit-string! "\\'{e}" 0 res w 5)
				     (loop (+fx r 1) (+fx w 5)))
				    ((#\)
				     (blit-string! "\\`{e}" 0 res w 5)
				     (loop (+fx r 1) (+fx w 5)))
				    ((#\)
				     (blit-string! "\\^{e}" 0 res w 5)
				     (loop (+fx r 1) (+fx w 5)))
				    ((#\)
				     (blit-string! "\\`{u}" 0 res w 5)
				     (loop (+fx r 1) (+fx w 5)))
				    ((#\)
				     (blit-string! "\\^\\i" 0 res w 4)
				     (loop (+fx r 1) (+fx w 5)))
				    ((#\)
				     (blit-string! "\\\"\\i" 0 res w 4)
				     (loop (+fx r 1) (+fx w 5)))
				    (else
				     (string-set! res w c)
				     (loop (+fx r 1) (+fx w 1)))))))))
		(case (string-ref str r)
		   ((#\\ #\^)
		    (loop (+fx r 1) (+fx nlen 8)))
		   ((#\< #\>)
		    (if *alltt*
			(loop (+fx r 1) nlen)
			(loop (+fx r 1) (+fx nlen 2))))
		   ((#\~)
		    (loop (+fx r 1) (+fx nlen 19)))
		   ((#\& #\$ #\# #\_ #\% #\-)
		    (loop (+fx r 1) (+fx nlen 1)))
		   ((#\ #\ #\ #\ #\)
		    (loop (+fx r 1) (+fx nlen 4)))
		   ((#\ #\)
		    (loop (+fx r 1) (+fx nlen 3)))
		   (else
		    (loop (+fx r 1) nlen)))))))
   (cond
      ((pair? str)
       (apply string-append
	      (map (lambda (x)
		      (if (string? x)
			  (inner x)
			  (with-output-to-string (lambda () (tex x)))))
		   str)))
      ((symbol? str)
       (inner (symbol->string str)))
      (else
       (inner str))))

;*---------------------------------------------------------------------*/
;*    tt ...                                                           */
;*---------------------------------------------------------------------*/
(define (dott obj)
   (display "\\texttt{")
   (let ((tt *tt*))
      (set! *tt* #t)
      (tex obj)
      (set! *tt* tt)
      (display "}")))

;*---------------------------------------------------------------------*/
;*    tex ::obj ...                                                    */
;*---------------------------------------------------------------------*/
(define-generic (tex obj::obj)
   (cond
      ((procedure? obj)
       (tex (obj)))
      ((string? obj)
       (display (tex-string obj)))
      ((symbol? obj)
       (display ""))
      ((or (number? obj) (char? obj))
       (display obj))
      ((eq? obj #unspecified)
       obj)
      ((list? obj)
       (for-each tex obj))
      ((or (symbol? obj) (boolean? obj))
       "")
      (else
       (with-access::%node obj (loc)
	  (error/location "tex"
			  "Can't find method for node"
			  (find-runtime-type obj)
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    tex ::%document ...                                              */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%document)
   (with-document
    obj
    (lambda ()
       (with-access::%document obj (title authors body)
	  ;; display the tex header
	  (define (tex-header)
	     (print "\\documentclass{"
		    (if (string? *scribe-tex-document-class*)
			*scribe-tex-document-class*
			(if (pair? (document-chapters obj)) "book" "article"))
		    "}")
	     (print "\\usepackage{alltt}")
	     (print "\\usepackage{epsfig}")
	     (let ((ok? (lambda (x) (or (string? x) (symbol? x)))))
		(for-each (lambda (p)
			     (match-case p
				((? ok?)
				 (print "\\usepackage{" p "}"))
				((? symbol?)
				 (print "\\usepackage{" p "}"))
				(((and ?pkg (? ok?)) (and ?opt (? ok?)))
				 (print "\\usepackage[" opt "]{" pkg "}"))
				(else
				 (error "scribe(tex)"
					"Illegal package"
					p))))
			  *scribe-tex-packages*)
		(newline))
	     (print "\\begin{document}"))
	  ;; display the footer
	  (define (tex-footer)
	     (if *scribe-footer* (tex *scribe-footer*)))
	  ;; the header of the Tex document
	  (tex-header)
	  ;; the title
	  (scribe-tex-title title authors)
	  ;; the body
	  (tex body)
	  ;; the footer of the document
	  (tex-footer)
	  ;; we are done
	  (newline)
	  (newline)
	  (print "\\end{document}")))))

;*---------------------------------------------------------------------*/
;*    scribe-tex-title ...                                             */
;*---------------------------------------------------------------------*/
(define (scribe-tex-title title authors)
   (display* *scribe-tex-title* "{")
   (tex title)
   (print "}")
   (if (procedure? *scribe-tex-author-hook*)
       (*scribe-tex-author-hook* authors))
   (print *scribe-tex-authors* "{")
   (for-each tex authors)
   (print "}")
   (print *scribe-tex-maketitle*)
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    tex ::%author ...                                                */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%author)
   (with-access::%author obj (name affiliation email url address phone)
      (if *scribe-tex-author-start* (print *scribe-tex-author-start*))
      (tex name) (print "\\\\")
      (if affiliation (begin (tex affiliation) (print "\\\\")))
      (if (pair? address)
	  (for-each (lambda (x) (tex x) (print "\\\\")) address))
      (if email (begin (dott email) (print "\\\\")))
      (if url (begin (dott url) (print "\\\\")))
      (if phone (begin (display "\\textit{") (tex phone) (print "}\\\\")))
      (if *scribe-tex-author-stop* (print *scribe-tex-author-stop*))))
   
;*---------------------------------------------------------------------*/
;*    tex ::%toc ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%toc)
   (print "\\tableofcontents"))

;*---------------------------------------------------------------------*/
;*    tex ::%text ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%text)
   (tex (%text-body obj)))

;*---------------------------------------------------------------------*/
;*    tex ::%linebreak ...                                             */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%linebreak)
   (let loop ((num (%linebreak-repetition obj)))
      (print "\\ \\linebreak")
      (if (>fx num 1)
	  (begin
	     (newline)
	     (loop (-fx num 1))))))

;*---------------------------------------------------------------------*/
;*    tex ::%center ...                                                */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%center)
   (print "\\begin{center}")
   (tex (%center-body obj))
   (print "\\end{center}"))

;*---------------------------------------------------------------------*/
;*    tex ::%flush ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%flush)
   (with-access::%flush obj (side loc)
      (case side
	 ((center)
	  (print "\\begin{center}")
	  (tex (%flush-body obj))
	  (newline)
	  (print "\\end{center}"))
	 ((left)
	  (print "\\begin{flushleft}")
	  (tex (%flush-body obj))
	  (newline)
	  (print "\\end{flushleft}"))
	 ((right)
	  (print "\\begin{flushright}")
	  (tex (%flush-body obj))
	  (newline)
	  (print "\\end{flushright}"))
	 (else
	  (error/location "tex"
			  "Illegal flush value"
			  side
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    tex ::%atom ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%atom)
   (print (%atom-value obj)))

;*---------------------------------------------------------------------*/
;*    tex ::%bold ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%bold)
   (display "\\textbf{")
   (tex (%bold-body obj))
   (display "}"))

;*---------------------------------------------------------------------*/
;*    tex ::%emph ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%emph)
   (display "{\\em{")
   (tex (%emph-body obj))
   (display "}}"))

;*---------------------------------------------------------------------*/
;*    tex ::%underline ...                                             */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%underline)
   (display "{\\underline{")
   (tex (%underline-body obj))
   (display "}}"))

;*---------------------------------------------------------------------*/
;*    tex ::%kbd ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%kbd)
   (dott (%kbd-body obj)))

;*---------------------------------------------------------------------*/
;*    tex ::%it ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%it)
   (display "\\textit{")
   (tex (%it-body obj))
   (display "}"))

;*---------------------------------------------------------------------*/
;*    tex ::%pre ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%pre)
   (print "\\begin{small}")
   (print "\\begin{alltt}")
   (let ((alltt *alltt*))
      (set! *alltt* #t)
      (tex (%pre-body obj))
      (set! *alltt* alltt))
   (print "\\end{alltt}")
   (print "\\end{small}"))

;*---------------------------------------------------------------------*/
;*    tex ::%tt ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%tt)
   (with-access::%tt obj (body)
      (dott body)))

;*---------------------------------------------------------------------*/
;*    tex ::%code ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%code)
   (with-access::%code obj (body)
      (dott body)))

;*---------------------------------------------------------------------*/
;*    tex ::%samp ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%samp)
   (with-access::%samp obj (body)
      (display "\\textit{")
      (tex body)
      (display "}")))

;*---------------------------------------------------------------------*/
;*    tex ::%var ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%var)
   (with-access::%var obj (body)
      (dott body)))

;*---------------------------------------------------------------------*/
;*    tex ::%sc ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%sc)
   (with-access::%sc obj (body)
      (display "{\\sc{")
      (tex body)
      (display "}}")))

;*---------------------------------------------------------------------*/
;*    tex ::%sup ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%sup)
   (with-access::%sup obj (body)
      (display "$^{\\mbox{")
      (tex body)
      (display "}}$")))

;*---------------------------------------------------------------------*/
;*    tex ::%sub ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%sub)
   (with-access::%sub obj (body)
      (display "$_{\\mbox{")
      (tex body)
      (display "}}$")))

;*---------------------------------------------------------------------*/
;*    tex ::%color ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%color)
   (with-access::%color obj (body bg fg margin)
      (tex body)))

;*---------------------------------------------------------------------*/
;*    tex ::%frame ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%frame)
   (with-access::%frame obj (body width margin)
      (print "\\fbox{%")
      (display "\\begin{minipage}{")
      (cond
	 ((not width)
	  (print ".8\\linewidth}"))
	 ((fixnum? width)
	  (print width "}"))
	 ((real? width)
	  (print width "\\linewidth}")))
      (tex body)
      (print "\\end{minipage}")
      (print "}")))

;*---------------------------------------------------------------------*/
;*    mark ...                                                         */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%mark)
   (with-access::%mark obj (id)
      (display* "\\label{" (ref-string id) "}")))

;*---------------------------------------------------------------------*/
;*    tex ::%reference ...                                             */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%reference)
   (with-access::%reference obj (body anchor)
      (multiple-value-bind (file mark)
	 (find-reference obj (current-document))
	 (cond
	    ((not mark)
	     (warning "ref" "Can't find reference -- " anchor)
	     (display "reference:???"))
	    (body
	     (tex body))
	    (else
	     (cond
		((string? mark)
		 (display* "\\ref{" (ref-string mark) "}"))
		((%container? mark)
		 (display* "\\ref{" (ref-string (%container-stamp mark))
			   "}"))))))))

;*---------------------------------------------------------------------*/
;*    tex ::%url-ref ...                                               */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%url-ref)
   (with-access::%url-ref obj (url anchor body)
      (if (and body (not (equal? body url)))
	  (begin
	     (tex body)
	     (display " (")))
      (display "{\\texttt{")
      (let ((tt *tt*))
	 (set! *tt* #t)
	 (tex url)
	 (if (or (pair? anchor)
		 (and (string? anchor) (>fx (string-length anchor) 0)))
	     (begin
		(display "\\char35")
		(tex anchor)))
	 (display "}}")
	 (set! *tt* tt))
      (if (and body (not (equal? body url))) (display ")"))))
   
;*---------------------------------------------------------------------*/
;*    tex ::%chapter-ref ...                                           */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%chapter-ref)
   (multiple-value-bind (_ chapter)
      (find-reference obj (current-document))
      (if (not chapter)
	  (with-access::%chapter-ref obj (anchor)
	     (warning "ref" "Can't find chapter -- " anchor)
	     (display "chapter:???"))
	  (with-access::%chapter-ref obj (anchor body)
	     (with-access::%chapter chapter (stamp)
		(if (and body (not (equal? body '(#t))))
		    (tex body)
		    (display "Chapter "))
		(display* "\\ref{" (ref-string stamp) "}"))))))

;*---------------------------------------------------------------------*/
;*    tex ::%section-ref ...                                           */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%section-ref)
   (multiple-value-bind (_ section)
      (find-reference obj (current-document))
      (if (not (%section? section))
	  (with-access::%section-ref obj (anchor)
	     (warning "ref" "Can't find section -- " anchor)
	     (display "section:???"))
	  (with-access::%section-ref obj (body)
	     (with-access::%section section (stamp)
		(if (and body (not (equal? body '(#t))))
		    (tex body)
		    (display "Section "))
		(display* "\\ref{" (ref-string stamp) "}"))))))
   
;*---------------------------------------------------------------------*/
;*    tex ::%subsection-ref ...                                        */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%subsection-ref)
   (multiple-value-bind (_ subsection)
      (find-reference obj (current-document))
      (if (not (%subsection? subsection))
	  (with-access::%subsection-ref obj (anchor)
	     (warning "ref" "Can't find subsection -- " anchor)
	     (display "subsection:???"))
	  (with-access::%subsection-ref obj (body)
	     (with-access::%subsection subsection (stamp)
		(if (and body (not (equal? body '(#t))))
		    (tex body)
		    (display "Section "))
		(display* "\\ref{" (ref-string stamp) "}"))))))

;*---------------------------------------------------------------------*/
;*    tex ::%subsubsection-ref ...                                     */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%subsubsection-ref)
   (multiple-value-bind (_ subsubsection)
      (find-reference obj (current-document))
      (if (not (%subsubsection? subsubsection))
	  (with-access::%subsubsection-ref obj (anchor)
	     (warning "ref" "Can't find subsubsection -- " anchor)
	     (display "subsubsection:???"))
	  (with-access::%subsubsection-ref obj (body)
	     (with-access::%subsubsection subsubsection (stamp)
		(if (and body (not (equal? body '(#t))))
		    (tex body)
		    (display "Section "))
		(display* "\\ref{" (ref-string stamp) "}"))))))

;*---------------------------------------------------------------------*/
;*    tex ::%biblio-ref ...                                            */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%biblio-ref)
   (with-access::%biblio-ref obj (anchor body)
      (tex-bibentry-ref anchor body)))

;*---------------------------------------------------------------------*/
;*    tex-bibentry-ref ::%bibentry ...                                 */
;*---------------------------------------------------------------------*/
(define (tex-bibentry-ref obj::%bibentry body)
   (with-access::%bibentry obj (stamp parent number)
      (if body (tex body))
      (display* "~{\\char91}" number "{\\char93}")))

;*---------------------------------------------------------------------*/
;*    mailto ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%mailto)
   (with-access::%mailto obj (email body)
      (dott (if (pair? body) body email))))

;*---------------------------------------------------------------------*/
;*    tex ::%item ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%item)
   (with-access::%item obj (value body)
      (if (not (null? value))
	  (begin
	     (display "[")
	     (tex value)
	     (print "]")))
      (tex body)))

;*---------------------------------------------------------------------*/
;*    tex ::%itemize ...                                               */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%itemize)
   (with-access::%itemize obj (items)
      (print "\\begin{itemize}")
      (for-each (lambda (item)
		   (display "\\item ")
		   (tex item)
		   (newline))
		items)
      (print "\\end{itemize}")))
      
;*---------------------------------------------------------------------*/
;*    tex ::%enumerate ...                                             */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%enumerate)
   (with-access::%enumerate obj (items)
      (print "\\begin{enumerate}")
      (for-each (lambda (item)
		   (display "\\item ")
		   (tex item)
		   (newline))
		items)
      (print "\\end{enumerate}")))
      
;*---------------------------------------------------------------------*/
;*    tex ::%description ...                                           */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%description)
   (with-access::%description obj (items)
      (print "\\begin{description}")
      (for-each (lambda (item)
		   (with-access::%item item (value body)
		      (for-each (lambda (i)
				   (display "\\item[")
				   (tex i)
				   (print "]"))
				(if (pair? value) value (list value)))
		      (tex body)))
		items)
      (print "\\end{description}")))
      
;*---------------------------------------------------------------------*/
;*    do-section ...                                                   */
;*---------------------------------------------------------------------*/
(define (do-section kind container::%block title)
   (with-access::%container container (stamp body)
      (newline)
      (print "%%" title)
      (display* "\\" kind "{")
      (tex title)
      (print "}")
      (newline)
      (print "\\label{" (ref-string stamp) "}")
      (tex body)))
   
;*---------------------------------------------------------------------*/
;*    tex ::%section ...                                               */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%section)
   (with-access::%section obj (number)
      (let ((sec (if (and number
			  (or (null? (document-chapters (current-document)))
			      (%chapter? (%section-parent obj))))
		     "section"
		     "section*")))
	 (do-section sec obj (%section-title obj)))))

;*---------------------------------------------------------------------*/
;*    tex ::%subsection ...                                            */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%subsection)
   (with-access::%subsection obj (parent number)
      (let ((ssec (if (and number
			   (or (null? (document-chapters (current-document)))
			       (and (%section? parent)
				    (%chapter? (%section-parent parent)))))
		      "subsection"
		      "subsection*")))
	 (do-section ssec obj (%subsection-title obj)))))

;*---------------------------------------------------------------------*/
;*    tex ::%subsubsection ...                                         */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%subsubsection)
   (with-access::%subsubsection obj (parent number)
      (let ((sssec (if (and number
			    (or (null? (document-chapters (current-document)))
				(and (%subsection? parent)
				     (%section? (%subsection-parent parent))
				     (%chapter? (%section-parent
						 (%subsection-parent parent))))))
		       "subsubsection"
		       "subsubsection*")))
	 (do-section sssec obj (%subsubsection-title obj)))))

;*---------------------------------------------------------------------*/
;*    tex ::%paragraph ...                                             */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%paragraph)
   (with-access::%paragraph obj (body)
      (newline)
      (print "\\par\\noindent")
      (tex body)
      (newline)))

;*---------------------------------------------------------------------*/
;*    make-chapter-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-chapter-title obj)
   (with-access::%chapter obj (title subtitle number parent)
      (let* ((doc parent)
	     (title (or title subtitle)))
	 (if (string? title)
	     title
	     (with-output-to-string 
		(lambda () (tex title)))))))

;*---------------------------------------------------------------------*/
;*    tex ::%chapter ...                                               */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%chapter)
   (with-access::%chapter obj (body file title subtitle)
      (do-section "chapter" obj (make-chapter-title obj))))

;*---------------------------------------------------------------------*/
;*    tex ::%hrule ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%hrule)
   (print "\\hrulefill"))

;*---------------------------------------------------------------------*/
;*    tex ::%font ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%font)
   (with-access::%font obj (size face body)
      (let ((size (if (number? size)
		      (number->string size))))
	 (cond
	    ((not (string? size))
	     (tex body))
	    ((string=? size "+4")
	     (display "\\Huge{")
	     (tex body)
	     (display "}"))
	    ((string=? size "+3")
	     (display "\\huge{")
	     (tex body)
	     (display "}"))
	    ((string=? size "+2")
	     (display "\\Large{")
	     (tex body)
	     (display "}"))
	    ((string=? size "+1")
	     (display "\\large{")
	     (tex body)
	     (display "}"))
	    ((string=? size "-1")
	     (display "\\small{")
	     (tex body)
	     (display "}"))
	    ((string=? size "-2")
	     (display "\\footnotesize{")
	     (tex body)
	     (display "}"))
	    ((string=? size "-3")
	     (display "\\tiny{")
	     (tex body)
	     (display "}"))
	    ((string=? size "-4")
	     (display "\\scriptsize{")
	     (tex body)
	     (display "}"))
	    (else
	     (tex body))))))

;*---------------------------------------------------------------------*/
;*    tex ::%image ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%image)
   (define (convert-image file converter)
      (let ((new (string-append (prefix file) ".eps")))
	 (system (string-append converter " " file " " new))
	 new))
   (with-access::%image obj (file width height zoom)
      (if (not (string? file))
	  (warning "tex" "Illegal image -- " file)
	  (let* ((suf (suffix file))
		 (file (if (member suf *scribe-tex-image-native*)
			   file
			   (let ((cell (assoc suf *scribe-tex-image-convert*)))
			      (if (pair? cell)
				  (convert-image file (cadr cell))
				  (begin
				     (warning "tex" "Illegal image -- " file)
				     file))))))
	     (display* "\\epsfig{file=" file)
	     (if width (display* " width=\"" width "\""))
	     (if height (display* " height=\"" height "\""))
	     (if zoom (display* " zoom=\"" zoom "\""))
	     (display "}")))))

;*---------------------------------------------------------------------*/
;*    tex ::%table ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%table)
   (with-access::%table obj (rows width nbcols border)
      (let* ((bs (if border (make-string border #\|) ""))
	     (nc nbcols)
	     (hs (if border
		     (let loop ((nc nc)
				(fmt bs))
			(if (> nc 0)
			    (loop (-fx nc 1) (string-append bs "c" fmt))
			    fmt))
		     (make-string nc #\c)))
	     (ls (if border
		     (let loop ((bd border)
				(fmt ""))
			(if (> bd 0)
			    (loop (-fx bd 1) (string-append "\\hline" fmt))
			    fmt))
		     "")))
	 (if (and #f (flonum? width))
	     ;; I'm unable to understand how tabular* works!. One more
	     ;; time, I'm defeat by LaTex.
	     (begin
		(print "\\begin{tabular*}" width "\\linewidth}[c]{" hs "}" ls)
		(for-each (lambda (r)
			     (table-row->tex r nc bs)
			     (print "\\\\" ls))
			  rows)
		(print "\\end{tabular*}"))
	     (begin
		(print "\\begin{tabular}{" hs "}" ls)
		(for-each (lambda (r)
			     (table-row->tex r nc bs)
			     (print "\\\\" ls))
			  rows)
		(print "\\end{tabular}"))))))

;*---------------------------------------------------------------------*/
;*    table-row->tex ::%table-row ...                                  */
;*---------------------------------------------------------------------*/
(define (table-row->tex obj::%table-row nbcols bs)
   (with-access::%table-row obj (cells bg)
      (let loop ((cells cells)
		 (nbcols nbcols)
		 (first #t))
	 (if (pair? cells)
	     (let ((new-nbcols (-fx nbcols (%table-cell-colspan (car cells)))))
;* 		;; to prevent inner column                             */
;* 		(table-cell->tex (car cells)                           */
;* 				 (if first bs "")                      */
;* 				 (if (=fx new-nbcols 0) bs ""))        */
		(table-cell->tex (car cells) bs bs)
		(if (pair? (cdr cells)) (print " & "))
		(loop (cdr cells) new-nbcols #f))
	     (if (> nbcols 0) (display (make-string nbcols #\&)))))))

;*---------------------------------------------------------------------*/
;*    table-cell->tex ::%table-cell ...                                */
;*---------------------------------------------------------------------*/
(define (table-cell->tex obj::%table-cell pre post)
   (with-access::%table-cell obj (width align valign colspan body)
      (if (or width
	      (and align (not (eq? align 'center)))
	      valign
	      (not (eq? colspan 1)))
	  ;; we have to use a multicolum macro
	  (begin
	     (display* "\\multicolumn{" colspan "}{"pre)
	     (display (case align
			 ((left) #\l)
			 ((right) #\r)
			 (else #\c)))
	     (display* post "}{")
	     (if width (display* "\\parbox{" width
				 (if (flonum? width) "\\linewidth" "")
				 "}{"))
	     (if (%table-header? obj) (display "\\textsf{"))
	     (tex body)
	     (if (%table-header? obj) (display "}"))
	     (if width (display "}"))
	     (display "}"))
	  (begin
	     (if (%table-header? obj) (display "\\textsf{"))
	     (tex body)
	     (if (%table-header? obj) (display "}"))))))
      
;*---------------------------------------------------------------------*/
;*    tex ::%character ...                                             */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%character)
   (case (%character-value obj)
      ((copyright)
       (display "(c)"))
      ((#\space)
       (display "\\char32"))
      ((#\tab)
       (display "\\char9"))))

;*---------------------------------------------------------------------*/
;*    tex ::%hook ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%hook)
   (with-access::%hook obj (body before after process)
      (if (procedure? before)
	  (let ((bef (before)))
	     (if process (tex bef))))
      (call-next-method)
      (if (procedure? after)
	  (let ((af (after)))
	     (if process (tex af))))))

;*---------------------------------------------------------------------*/
;*    tex ::%figure ...                                                */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%figure)
   (with-access::%figure obj (body legend)
      (print "\\begin{figure}")
      (tex body)
      (display "\\caption{")
      (tex legend)
      (print "}")
      (print "\\end{figure}")))

;*---------------------------------------------------------------------*/
;*    tex ::%footnote ...                                              */
;*---------------------------------------------------------------------*/
(define-method (tex obj::%footnote)
   (with-access::%footnote obj (note body)
      (tex body)
      (display "\\footnote{")
      (tex note)
      (display "}")))

;*---------------------------------------------------------------------*/
;*    Top level form to register the newly loaded back-end             */
;*---------------------------------------------------------------------*/
(register-backend! 'tex tex)
