/***************************************************************************
                          navigator.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "navigator.h"
#include "navigator.moc"

Navigator::Navigator(QWidget *parent, int Size, int Seite, ScribusView* vie) : QLabel(parent)
{
	setScaledContents(false);
	setAlignment( int( QLabel::AlignLeft | QLabel::AlignTop) );
	pmx = vie->PageToPixmap(Seite, Size);
	resize(pmx.width(), pmx.height());
	Xp = 0;
	Yp = 0;
	drawMark(0, 0);
	view = vie;
}

void Navigator::mouseMoveEvent(QMouseEvent *m)
{
	drawMark(m->x(), m->y());
	emit Coords(float(m->x())/float(width()), float(m->y())/float(height()));
}

void Navigator::mousePressEvent(QMouseEvent *m)
{
	drawMark(m->x(), m->y());
	emit Coords(float(m->x())/float(width()), float(m->y())/float(height()));
}

void Navigator::mouseReleaseEvent(QMouseEvent *m)
{
	emit Coords(float(m->x())/float(width()), float(m->y())/float(height()));
}

void Navigator::paintEvent(QPaintEvent *e)
{
	QPainter p;
	p.begin(this);
	p.setClipRect(e->rect());
	p.drawPixmap(0, 0, pmx);
	drawMark(Xp, Yp);
	p.end();
}

void Navigator::drawMark(int x, int y)
{
	QPainter p;
	p.begin(this);
	p.setRasterOp(XorROP);
	p.setPen(QPen(QColor(white), 1, SolidLine, FlatCap, MiterJoin));
	p.drawLine(Xp-5, Yp-5, Xp-1, Yp-1);
	p.drawLine(Xp-5, Yp+5, Xp-1, Yp+1);
	p.drawLine(Xp+2, Yp+2, Xp+6, Yp+6);
	p.drawLine(Xp+2, Yp-2, Xp+6, Yp-6);
	if (!((Xp == x) && (Yp == y)))
		{
		Xp = x;
		Yp = y;
		p.drawLine(Xp-5, Yp-5, Xp-1, Yp-1);
		p.drawLine(Xp-5, Yp+5, Xp-1, Yp+1);
		p.drawLine(Xp+2, Yp+2, Xp+6, Yp+6);
		p.drawLine(Xp+2, Yp-2, Xp+6, Yp-6);
		}
	p.end();
}

void Navigator::SetSeite(int Seite, int Size)
{
	pmx = view->PageToPixmap(Seite, Size);
	resize(pmx.width(), pmx.height());
	repaint();
}

Navigator::~Navigator()
{
}
