/***************************************************************************
                 	scribusXml.h the document xml library for scribus
                             -------------------
    begin                : Sam Jul 14 10:00:00 CEST 2001
    copyright            : (C) 2001 by Christian Tpp
    email                : christian.toepp@mr-ct@gmx.de
 ***************************************************************************/

#ifndef _SCRIBUS_CONFIG_
#define _SCRIBUS_CONFIG_

#include "scribusview.h"
#include <qvaluelist.h>
#include <qdom.h>

class ScriXmlDoc : public QObject
{
Q_OBJECT
public:
	ScriXmlDoc();
	~ScriXmlDoc();
	bool ReadColors(QString fileName);
	QString WriteElem(QList<uint> *Selitems, ScribusDoc *doc);
	bool ReadElem(QString fileName, SCFonts &avail, ScribusDoc *doc, int Xp, int Yp, bool Fi, bool loc);
	bool ReadDoc(QString fileName, SCFonts &avail, ScribusDoc *docu, ScribusView *viewx);
	void WritePages(ScribusView *view, QDomDocument docu, QDomElement dc);
	bool WriteDoc(QString fileName, ScribusDoc *docu, ScribusView *viewx);
	void WritePref(preV *Vor);
	bool ReadPref(struct preV *Vorein);
	CListe Farben;
	struct Linked { int Start;
									int StPag;
              	};
	QValueList<Linked> LFrames;
	
signals:
	void NewPage(int);
};

#endif // _SCRIBUS_CONFIG_
