/* ScummVM - Scumm Interpreter
 * Copyright (C) 2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-9-1/gui/theme.cpp $
 * $Id: theme.cpp 21939 2006-04-16 13:01:41Z fingolfin $
 */

#include "gui/theme.h"
#include "gui/eval.h"

namespace GUI {

Theme::Theme() : _drawArea(), _configFile(), _loadedThemeX(0), _loadedThemeY(0) {
	Common::MemoryReadStream s((const byte *)_defaultConfigINI, strlen(_defaultConfigINI));
	_defaultConfig.loadFromStream(s);

	_evaluator = new Eval();
}
	
Theme::~Theme() {
	delete _evaluator;
}

} // End of namespace GUI
