/*   ScwEntry
 *   Copyright 2005  Kalle Vahlman
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __SCW_ENTRY_H__
#define __SCW_ENTRY_H__

#include <time.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define SCW_TYPE_ENTRY            (scw_entry_get_type ())
#define SCW_ENTRY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCW_TYPE_ENTRY, ScwEntry))
#define SCW_ENTRY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCW_TYPE_ENTRY, ScwEntryClass))
#define SCW_IS_ENTRY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCW_TYPE_ENTRY))
#define SCW_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCW_TYPE_ENTRY))
#define SCW_ENTRY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), SCW_TYPE_ENTRY, ScwEntryClass))


typedef struct _ScwEntry       ScwEntry;
typedef struct _ScwEntryClass  ScwEntryClass;

struct _ScwEntry
{
  GtkEntry parent;

};

struct _ScwEntryClass
{
  GtkEntryClass parent_class;
/*
  void    (*send_message)           (ScwEntry *entry,
                                     gchar *message,
                                     gpointer   *user_data);
*/
};


GType      scw_entry_get_type  (void) G_GNUC_CONST;

/* Public functions, but usage discouraged
 * Public so people can do stupid things if they want to
 */

void
scw_entry_set_history_size (ScwEntry	*entry,
                            gint      size);
gint
scw_entry_get_history_size (ScwEntry *entry);
GList *
scw_entry_get_history (ScwEntry *entry);
GList *
scw_entry_history_get_current (ScwEntry *entry);


/* Public API */

/* Append a history item.
 *
 * Concurrent duplicates are collapsed
 * The entry keeps it's own copy of the data
 */
void
scw_entry_history_append (ScwEntry *entry,
                          const gchar    *item);

/* Step back one item in history
 *
 * If at the end of history, does nothing.
 * Updates the entry's contents
 * If no history item is active, appends the current text to the history
 */
void
scw_entry_history_step_back (ScwEntry *entry);

/* Step forward one item in history
 *
 * If at the end of history, does nothing.
 * Updates the entry's contents
 * If no history item is active, appends the current text to the history
 */
void
scw_entry_history_step_forward (ScwEntry *entry);

/* Returns the previous history item
 * 
 * Does not change the history or the entry in any way
 * Returns a copy of the previous item, the item should be freed after use 
 * Returns NULL if no items are available
 */
const gchar *
scw_entry_history_peek_backwards (ScwEntry *entry);

/* Returns the next history item
 * 
 * Does not change the history or the entry in any way
 * Returns a copy of the next item, the item should be freed after use 
 * Returns NULL if no items are available
 */
const gchar *
scw_entry_history_peek_forward (ScwEntry *entry);

G_END_DECLS

#endif /* __SCW_ENTRY_H__ */
