 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_BASIC_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_BASIC_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace debug {

//____________________________________________________________________________
// Check

class Check;       	// "projects/library/seqan/basic/basic_debug.h"(242)

//____________________________________________________________________________
// Checkpoint

struct Checkpoint;       	// "projects/library/seqan/basic/basic_debug.h"(300)

//____________________________________________________________________________
// CheckpointLess

struct CheckpointLess;       	// "projects/library/seqan/basic/basic_debug.h"(306)

//____________________________________________________________________________
// CheckpointStore

template <typename T > struct CheckpointStore;       	// "projects/library/seqan/basic/basic_debug.h"(316)

//____________________________________________________________________________
// Report

class Report;       	// "projects/library/seqan/basic/basic_debug.h"(246)

} //namespace debug
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdaptorIterator

template <typename TIterator, typename TSpec > struct AdaptorIterator;       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(31)

//____________________________________________________________________________
// Allocator

template <typename TSpec> struct Allocator;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(50)

//____________________________________________________________________________
// BandedGotoh_

struct BandedGotoh_;       	// "projects/library/seqan/basic/basic_tag.h"(111)

//____________________________________________________________________________
// BandedNeedlemanWunsch_

struct BandedNeedlemanWunsch_;       	// "projects/library/seqan/basic/basic_tag.h"(92)

//____________________________________________________________________________
// BitCompressed

template <unsigned BITSIZE1 , unsigned BITSIZE2 > struct BitCompressed;       	// "projects/library/seqan/basic/basic_aggregates.h"(41)

//____________________________________________________________________________
// BitsPerValue

template <typename TValue> struct BitsPerValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(840)

//____________________________________________________________________________
// BytesPerValue

template <typename TValue> struct BytesPerValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(865)

//____________________________________________________________________________
// CASE

template <int tag_,class Type_,class Next_ > struct CASE;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(76)

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "projects/library/seqan/basic/basic_type.h"(290)

//____________________________________________________________________________
// ChunkPool

template <size_t SIZE, size_t MAX_COUNT , typename TParentAllocator > struct ChunkPool;       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(56)

//____________________________________________________________________________
// ChunkPool2

template <typename TValue, size_t MAX_COUNT , typename TParentAllocator > struct ChunkPool2;       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(248)

//____________________________________________________________________________
// CompareType

template <typename TLeft, typename TRight> struct CompareType;       	// "projects/library/seqan/basic/basic_compare.h"(30)
template <typename TLeft, typename TRight> struct CompareType;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(539)

//____________________________________________________________________________
// Container

template <typename T> struct Container;       	// "projects/library/seqan/basic/basic_iterator_base.h"(106)
template <typename T> struct Container;       	// "projects/library/seqan/basic/basic_iterator.h"(147)

//____________________________________________________________________________
// Convert

template <typename TTarget, typename TSource > struct Convert;       	// "projects/library/seqan/basic/basic_converter.h"(48)

//____________________________________________________________________________
// CountedPtr

template <typename Type > struct CountedPtr;       	// "projects/library/seqan/basic/basic_counted_ptr.h"(34)

//____________________________________________________________________________
// CutCompressed

template <unsigned valueSizeI1 > struct CutCompressed;       	// "projects/library/seqan/basic/basic_aggregates.h"(36)

//____________________________________________________________________________
// DeepestSpec

template <typename T> struct DeepestSpec;       	// "projects/library/seqan/basic/basic_type.h"(229)

//____________________________________________________________________________
// DefaultGetIteratorSpec

template <typename T> struct DefaultGetIteratorSpec;       	// "projects/library/seqan/basic/basic_iterator.h"(94)

//____________________________________________________________________________
// DefaultIteratorSpec

template <typename T> struct DefaultIteratorSpec;       	// "projects/library/seqan/basic/basic_iterator.h"(72)

//____________________________________________________________________________
// Default_

struct Default_;       	// "projects/library/seqan/basic/basic_definition.h"(86)

//____________________________________________________________________________
// Difference

template <typename T> struct Difference;       	// "projects/library/seqan/basic/basic_type.h"(137)

//____________________________________________________________________________
// DotDrawing_

struct DotDrawing_;       	// "projects/library/seqan/basic/basic_tag.h"(36)

//____________________________________________________________________________
// False

struct False;       	// "projects/library/seqan/basic/basic_definition.h"(134)

//____________________________________________________________________________
// Finite

template <unsigned SIZE> struct Finite;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1144)

//____________________________________________________________________________
// GetValue

template <typename T> struct GetValue;       	// "projects/library/seqan/basic/basic_type.h"(69)

//____________________________________________________________________________
// GoEnd_

struct GoEnd_;       	// "projects/library/seqan/basic/basic_definition.h"(112)

//____________________________________________________________________________
// Gotoh_

struct Gotoh_;       	// "projects/library/seqan/basic/basic_tag.h"(102)

//____________________________________________________________________________
// Hirschberg_

struct Hirschberg_;       	// "projects/library/seqan/basic/basic_tag.h"(139)

//____________________________________________________________________________
// Holder

template <typename TValue, typename TSpec > struct Holder;       	// "projects/library/seqan/basic/basic_holder.h"(112)

//____________________________________________________________________________
// Host

template <typename T> struct Host;       	// "projects/library/seqan/basic/basic_type.h"(181)

//____________________________________________________________________________
// IF

template <bool Flag,class Type1, class Type2> struct IF;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(35)

//____________________________________________________________________________
// Id

template <typename T> struct Id;       	// "projects/library/seqan/basic/basic_type.h"(335)

//____________________________________________________________________________
// InfimumValue

template <typename T, typename TParent > struct InfimumValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(996)

//____________________________________________________________________________
// IntegralForValue

template <typename TValue> struct IntegralForValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(923)

//____________________________________________________________________________
// IsSimple

template <typename T> struct IsSimple;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(53)

//____________________________________________________________________________
// Iter

template <typename TContainer, typename TSpec> class Iter;       	// "projects/library/seqan/basic/basic_iterator_base.h"(41)

//____________________________________________________________________________
// Iterator

template <typename T, typename TSpec > struct Iterator;       	// "projects/library/seqan/basic/basic_iterator.h"(129)

//____________________________________________________________________________
// IteratorProxy

template <typename TIterator> struct IteratorProxy;       	// "projects/library/seqan/basic/basic_proxy.h"(80)

//____________________________________________________________________________
// Iterator_Default_Imp

template <typename T, typename TSpec> struct Iterator_Default_Imp;       	// "projects/library/seqan/basic/basic_iterator.h"(119)

//____________________________________________________________________________
// Key

template <typename T > struct Key;       	// "projects/library/seqan/basic/basic_type.h"(358)

//____________________________________________________________________________
// LENGTH

template <typename T> struct LENGTH;       	// "projects/library/seqan/basic/basic_type.h"(599)

//____________________________________________________________________________
// LOOP

template <typename Worker, int I> class LOOP;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(121)

//____________________________________________________________________________
// LOOP_REVERSE

template <typename Worker, int I> class LOOP_REVERSE;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(144)

//____________________________________________________________________________
// Lcs_

struct Lcs_;       	// "projects/library/seqan/basic/basic_tag.h"(148)

//____________________________________________________________________________
// Length

template <typename T> struct Length;       	// "projects/library/seqan/basic/basic_definition.h"(37)

//____________________________________________________________________________
// Log2

template <__int64 numerus > struct Log2;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(166)

//____________________________________________________________________________
// Log2Floor

template <__int64 numerus > struct Log2Floor;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(171)

//____________________________________________________________________________
// LogProb

template <typename TValue , typename TSpec > class LogProb;       	// "projects/library/seqan/basic/basic_logvalue.h"(36)
template <typename TValue, typename TSpec> class LogProb;       	// "projects/library/seqan/basic/basic_logvalue.h"(42)

//____________________________________________________________________________
// MemsetConstValueWorker

template <unsigned SIZE, bool direct, unsigned char c> struct MemsetConstValueWorker;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(251)

//____________________________________________________________________________
// MemsetWorker

template <unsigned SIZE, bool direct> struct MemsetWorker;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(205)

//____________________________________________________________________________
// MinimalCtor_

struct MinimalCtor_;       	// "projects/library/seqan/basic/basic_definition.h"(119)

//____________________________________________________________________________
// Move_

struct Move_;       	// "projects/library/seqan/basic/basic_definition.h"(106)

//____________________________________________________________________________
// MultiPool

template <typename TParentAllocator , unsigned int BLOCKING_LIMIT > struct MultiPool;       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(50)

//____________________________________________________________________________
// MyersBitVector_

struct MyersBitVector_;       	// "projects/library/seqan/basic/basic_tag.h"(121)

//____________________________________________________________________________
// MyersHirschberg_

struct MyersHirschberg_;       	// "projects/library/seqan/basic/basic_tag.h"(130)

//____________________________________________________________________________
// NeedlemanWunsch_

struct NeedlemanWunsch_;       	// "projects/library/seqan/basic/basic_tag.h"(83)

//____________________________________________________________________________
// NilCase

struct NilCase;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(72)

//____________________________________________________________________________
// NonMinimalCtor_

struct NonMinimalCtor_;       	// "projects/library/seqan/basic/basic_definition.h"(123)

//____________________________________________________________________________
// Nothing

struct Nothing;       	// "projects/library/seqan/basic/basic_definition.h"(145)

//____________________________________________________________________________
// Nussinov_

struct Nussinov_;       	// "projects/library/seqan/basic/basic_tag.h"(187)

//____________________________________________________________________________
// Object

template <typename T> struct Object;       	// "projects/library/seqan/basic/basic_type.h"(377)

//____________________________________________________________________________
// Pair

template <typename _T1, typename _T2 , typename TCompression > struct Pair;       	// "projects/library/seqan/basic/basic_aggregates.h"(72)

//____________________________________________________________________________
// Position

template <typename T> struct Position;       	// "projects/library/seqan/basic/basic_type.h"(161)

//____________________________________________________________________________
// PositionIterator

struct PositionIterator;       	// "projects/library/seqan/basic/basic_iterator_position.h"(29)

//____________________________________________________________________________
// Power

template <__int64 base, __int64 exponent > struct Power;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(186)

//____________________________________________________________________________
// ProfileType

template <typename TValue, typename TCount , typename TSpec > class ProfileType;       	// "projects/library/seqan/basic/basic_profchar.h"(34)
template <typename TValue, typename TCount, typename TSpec> class ProfileType;       	// "projects/library/seqan/basic/basic_profchar.h"(38)

//____________________________________________________________________________
// Proxy

template <typename TSpec> struct Proxy;       	// "projects/library/seqan/basic/basic_proxy.h"(48)
template <typename TSpec> struct Proxy;       	// "projects/library/seqan/basic/basic_transport.h"(67)

//____________________________________________________________________________
// Reference

template <typename T> struct Reference;       	// "projects/library/seqan/basic/basic_type.h"(91)

//____________________________________________________________________________
// SWITCH

template <int tag,class Case> class SWITCH;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(84)

//____________________________________________________________________________
// Simple

struct Simple;       	// "projects/library/seqan/basic/basic_holder.h"(86)

//____________________________________________________________________________
// SimpleAlloc

template <typename TParentAllocator > struct SimpleAlloc;       	// "projects/library/seqan/basic/basic_allocator_simple.h"(46)

//____________________________________________________________________________
// SimpleIterator

struct SimpleIterator;       	// "projects/library/seqan/basic/basic_iterator_simple.h"(30)

//____________________________________________________________________________
// SimpleType

template <typename TValue, typename TSpec> struct SimpleType;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(58)

//____________________________________________________________________________
// SinglePool

template <size_t SIZE, typename TParentAllocator > struct SinglePool;       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(50)

//____________________________________________________________________________
// SinglePool2

template <typename TValue, typename TParentAllocator > struct SinglePool2;       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(226)

//____________________________________________________________________________
// Size

template <typename T> struct Size;       	// "projects/library/seqan/basic/basic_type.h"(113)

//____________________________________________________________________________
// SmithWatermanClump_

struct SmithWatermanClump_;       	// "projects/library/seqan/basic/basic_tag.h"(177)

//____________________________________________________________________________
// SmithWaterman_

struct SmithWaterman_;       	// "projects/library/seqan/basic/basic_tag.h"(166)

//____________________________________________________________________________
// Source

template <typename TSpec > struct Source;       	// "projects/library/seqan/basic/basic_type.h"(392)

//____________________________________________________________________________
// SourceValue

template <typename T> struct SourceValue;       	// "projects/library/seqan/basic/basic_profchar.h"(118)

//____________________________________________________________________________
// Spec

template <typename T> struct Spec;       	// "projects/library/seqan/basic/basic_type.h"(200)

//____________________________________________________________________________
// StdAllocator

template <typename T, typename TData> struct StdAllocator;       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(170)

//____________________________________________________________________________
// StdContainerIterator

template <typename TStdContainer> struct StdContainerIterator;       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(68)

//____________________________________________________________________________
// StdIteratorAdaptor

struct StdIteratorAdaptor;       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(89)

//____________________________________________________________________________
// SupremumValue

template <typename T, typename TParent > struct SupremumValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(985)

//____________________________________________________________________________
// TYPECMP

template <class Type1, class Type2> struct TYPECMP;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(54)

//____________________________________________________________________________
// Tag

template <typename T> struct Tag;       	// "projects/library/seqan/basic/basic_definition.h"(31)

//____________________________________________________________________________
// TagAllocateStorage_

struct TagAllocateStorage_;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(84)

//____________________________________________________________________________
// TagAllocateTemp_

struct TagAllocateTemp_;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(81)

//____________________________________________________________________________
// TagAllocateUnspecified_

struct TagAllocateUnspecified_;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(78)

//____________________________________________________________________________
// TagBlat_

struct TagBlat_;       	// "projects/library/seqan/basic/basic_tag.h"(192)

//____________________________________________________________________________
// TagList

template <typename TTag , typename TSubList > struct TagList;       	// "projects/library/seqan/basic/basic_definition.h"(47)

//____________________________________________________________________________
// TagRooted_

struct TagRooted_;       	// "projects/library/seqan/basic/basic_iterator.h"(48)

//____________________________________________________________________________
// TagSelector

template <typename TTagList > struct TagSelector;       	// "projects/library/seqan/basic/basic_definition.h"(63)

//____________________________________________________________________________
// TagStandard_

struct TagStandard_;       	// "projects/library/seqan/basic/basic_iterator.h"(51)

//____________________________________________________________________________
// ToStdAllocator

template <typename THost, typename TValue> struct ToStdAllocator;       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(61)

//____________________________________________________________________________
// Triple

template <typename _T1, typename _T2 , typename _T3 , typename TCompression > struct Triple;       	// "projects/library/seqan/basic/basic_aggregates.h"(238)

//____________________________________________________________________________
// Tristate

struct Tristate;       	// "projects/library/seqan/basic/basic_holder.h"(87)

//____________________________________________________________________________
// Tristate2

struct Tristate2;       	// "projects/library/seqan/basic/basic_holder.h"(1347)

//____________________________________________________________________________
// True

struct True;       	// "projects/library/seqan/basic/basic_definition.h"(133)

//____________________________________________________________________________
// Tuple

template <typename _T, unsigned _size, typename TCompression > struct Tuple;       	// "projects/library/seqan/basic/basic_aggregates.h"(333)

//____________________________________________________________________________
// Value

template <typename T, const int i > struct Value;       	// "projects/library/seqan/basic/basic_type.h"(43)

//____________________________________________________________________________
// ValueSize

template <typename T> struct ValueSize;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(941)

//____________________________________________________________________________
// VertexDescriptor

template <typename T> struct VertexDescriptor;       	// "projects/library/seqan/basic/basic_type.h"(313)

//____________________________________________________________________________
// VoidHolder

class VoidHolder;       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(30)

//____________________________________________________________________________
// VolatilePtr

template <typename Type > struct VolatilePtr;       	// "projects/library/seqan/basic/basic_volatile_ptr.h"(40)

//____________________________________________________________________________
// WEIGHT

template <typename T> struct WEIGHT;       	// "projects/library/seqan/basic/basic_type.h"(621)

//____________________________________________________________________________
// WorkerNothing

struct WorkerNothing;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(115)

//____________________________________________________________________________
// _AminoAcid

struct _AminoAcid;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1124)

//____________________________________________________________________________
// _BitVector

template <unsigned char _size > struct _BitVector;       	// "projects/library/seqan/basic/basic_aggregates.h"(360)

//____________________________________________________________________________
// _ClassIdentifier

template <typename T> struct _ClassIdentifier;       	// "projects/library/seqan/basic/basic_definition.h"(315)

//____________________________________________________________________________
// _Compressed

struct _Compressed;       	// "projects/library/seqan/basic/basic_aggregates.h"(29)

//____________________________________________________________________________
// _ConstParameter

template <typename T> struct _ConstParameter;       	// "projects/library/seqan/basic/basic_type.h"(474)

//____________________________________________________________________________
// _CopyConst

template <typename TFrom, typename TTo> struct _CopyConst;       	// "projects/library/seqan/basic/basic_definition.h"(154)

//____________________________________________________________________________
// _Dna

struct _Dna;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1049)

//____________________________________________________________________________
// _Dna5

struct _Dna5;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1073)

//____________________________________________________________________________
// _Dna5Q

struct _Dna5Q;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1395)

//____________________________________________________________________________
// _DnaQ

struct _DnaQ;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1372)

//____________________________________________________________________________
// _HammingDistance

struct _HammingDistance;       	// "projects/library/seqan/basic/basic_tag.h"(52)

//____________________________________________________________________________
// _InfimumValueSigned

template <typename T > struct _InfimumValueSigned;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(961)

//____________________________________________________________________________
// _InfimumValueUnsigned

template <typename T > struct _InfimumValueUnsigned;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(959)

//____________________________________________________________________________
// _IntegralForValue_Impl

template <int SIZE> struct _IntegralForValue_Impl;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(896)

//____________________________________________________________________________
// _IsSameType

template <typename T1, typename T2> struct _IsSameType;       	// "projects/library/seqan/basic/basic_definition.h"(424)

//____________________________________________________________________________
// _IsSimple

template <typename T> struct _IsSimple;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(47)

//____________________________________________________________________________
// _Iupac

struct _Iupac;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1097)

//____________________________________________________________________________
// _LevenshteinDistance

struct _LevenshteinDistance;       	// "projects/library/seqan/basic/basic_tag.h"(53)

//____________________________________________________________________________
// _Log2_Impl

template <int BITS_MAX> struct _Log2_Impl;       	// "projects/library/seqan/basic/basic_definition.h"(338)

//____________________________________________________________________________
// _MakeSigned

template <typename T> struct _MakeSigned;       	// "projects/library/seqan/basic/basic_definition.h"(258)

//____________________________________________________________________________
// _MakeUnsigned

template <typename T> struct _MakeUnsigned;       	// "projects/library/seqan/basic/basic_definition.h"(203)

//____________________________________________________________________________
// _NonConstPointer

template <typename T> struct _NonConstPointer;       	// "projects/library/seqan/basic/basic_type.h"(545)

//____________________________________________________________________________
// _Parameter

template <typename T> struct _Parameter;       	// "projects/library/seqan/basic/basic_type.h"(416)

//____________________________________________________________________________
// _Pointer

template <typename T> struct _Pointer;       	// "projects/library/seqan/basic/basic_type.h"(519)

//____________________________________________________________________________
// _RemoveConst

template <typename T> struct _RemoveConst;       	// "projects/library/seqan/basic/basic_definition.h"(172)

//____________________________________________________________________________
// _SupremumValueSigned

template <typename T > struct _SupremumValueSigned;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(956)

//____________________________________________________________________________
// _SupremumValueUnsigned

template <typename T > struct _SupremumValueUnsigned;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(954)

//____________________________________________________________________________
// _Translate_Table_AA_2_Ascii

template <typename T > struct _Translate_Table_AA_2_Ascii;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(337)

//____________________________________________________________________________
// _Translate_Table_Ascii_2_AA

template <typename T > struct _Translate_Table_Ascii_2_AA;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(374)

//____________________________________________________________________________
// _Translate_Table_Ascii_2_Dna

template <typename T > struct _Translate_Table_Ascii_2_Dna;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(138)

//____________________________________________________________________________
// _Translate_Table_Ascii_2_Dna5

template <typename T > struct _Translate_Table_Ascii_2_Dna5;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(176)

//____________________________________________________________________________
// _Translate_Table_Ascii_2_Iupac

template <typename T > struct _Translate_Table_Ascii_2_Iupac;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(214)

//____________________________________________________________________________
// _Translate_Table_Byte_2_AA

template <typename T > struct _Translate_Table_Byte_2_AA;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(412)

//____________________________________________________________________________
// _Translate_Table_Byte_2_Dna

template <typename T > struct _Translate_Table_Byte_2_Dna;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(251)

//____________________________________________________________________________
// _Translate_Table_Byte_2_Dna5

template <typename T > struct _Translate_Table_Byte_2_Dna5;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(280)

//____________________________________________________________________________
// _Translate_Table_Byte_2_Iupac

template <typename T > struct _Translate_Table_Byte_2_Iupac;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(308)

//____________________________________________________________________________
// _Translate_Table_Dna5_2_Ascii

template <typename T > struct _Translate_Table_Dna5_2_Ascii;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(33)

//____________________________________________________________________________
// _Translate_Table_Dna5_2_Iupac

template <typename T > struct _Translate_Table_Dna5_2_Iupac;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(43)

//____________________________________________________________________________
// _Translate_Table_Iupac_2_Ascii

template <typename T > struct _Translate_Table_Iupac_2_Ascii;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(53)

//____________________________________________________________________________
// _Translate_Table_Iupac_2_Dna

template <typename T > struct _Translate_Table_Iupac_2_Dna;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(81)

//____________________________________________________________________________
// _Translate_Table_Iupac_2_Dna5

template <typename T > struct _Translate_Table_Iupac_2_Dna5;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(110)

//____________________________________________________________________________
// _TupleShiftLeftWorker

struct _TupleShiftLeftWorker;       	// "projects/library/seqan/basic/basic_aggregates.h"(530)

//____________________________________________________________________________
// _TupleShiftRightWorker

struct _TupleShiftRightWorker;       	// "projects/library/seqan/basic/basic_aggregates.h"(537)

//____________________________________________________________________________
// _ValueConstructor

struct _ValueConstructor;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(81)

//____________________________________________________________________________
// _ValueConstructorProxy

struct _ValueConstructorProxy;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(114)

//____________________________________________________________________________
// _ValueDestructor

struct _ValueDestructor;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(128)

//____________________________________________________________________________
// _ValueDestructorProxy

struct _ValueDestructorProxy;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(138)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AminoAcid

typedef SimpleType<unsigned char, _AminoAcid> AminoAcid;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1125)

//____________________________________________________________________________
// Ascii

typedef char Ascii;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(61)

//____________________________________________________________________________
// BandedGotoh

typedef Tag<BandedGotoh_> const BandedGotoh;       	// "projects/library/seqan/basic/basic_tag.h"(112)

//____________________________________________________________________________
// BandedNeedlemanWunsch

typedef Tag<BandedNeedlemanWunsch_> const BandedNeedlemanWunsch;       	// "projects/library/seqan/basic/basic_tag.h"(93)

//____________________________________________________________________________
// Blat

typedef Tag<TagBlat_> const Blat;       	// "projects/library/seqan/basic/basic_tag.h"(193)

//____________________________________________________________________________
// Byte

typedef unsigned char Byte;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(62)

//____________________________________________________________________________
// Compressed

typedef Tag<_Compressed> Compressed;       	// "projects/library/seqan/basic/basic_aggregates.h"(30)

//____________________________________________________________________________
// Default

typedef Tag<Default_> const Default;       	// "projects/library/seqan/basic/basic_definition.h"(87)

//____________________________________________________________________________
// Dna

typedef SimpleType<unsigned char,_Dna> Dna;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1050)

//____________________________________________________________________________
// Dna5

typedef SimpleType<unsigned char, _Dna5> Dna5;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1074)

//____________________________________________________________________________
// Dna5Q

typedef SimpleType <unsigned char, _Dna5Q> Dna5Q;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1396)

//____________________________________________________________________________
// DnaQ

typedef SimpleType <unsigned char, _DnaQ> DnaQ;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1373)

//____________________________________________________________________________
// DotDrawing

typedef Tag<DotDrawing_> const DotDrawing;       	// "projects/library/seqan/basic/basic_tag.h"(37)

//____________________________________________________________________________
// EditDistance

typedef Tag<_LevenshteinDistance> EditDistance;       	// "projects/library/seqan/basic/basic_tag.h"(57)

//____________________________________________________________________________
// GoEnd

typedef Tag<GoEnd_> const GoEnd;       	// "projects/library/seqan/basic/basic_definition.h"(113)

//____________________________________________________________________________
// Gotoh

typedef Tag<Gotoh_> const Gotoh;       	// "projects/library/seqan/basic/basic_tag.h"(103)

//____________________________________________________________________________
// HammingDistance

typedef Tag<_HammingDistance> HammingDistance;       	// "projects/library/seqan/basic/basic_tag.h"(55)

//____________________________________________________________________________
// Hirschberg

typedef Tag<Hirschberg_> const Hirschberg;       	// "projects/library/seqan/basic/basic_tag.h"(140)

//____________________________________________________________________________
// Iupac

typedef SimpleType<unsigned char, _Iupac> Iupac;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1098)

//____________________________________________________________________________
// Lcs

typedef Tag<Lcs_> const Lcs;       	// "projects/library/seqan/basic/basic_tag.h"(149)

//____________________________________________________________________________
// LevenshteinDistance

typedef Tag<_LevenshteinDistance> LevenshteinDistance;       	// "projects/library/seqan/basic/basic_tag.h"(56)

//____________________________________________________________________________
// MinimalCtor

typedef Tag<MinimalCtor_> const MinimalCtor;       	// "projects/library/seqan/basic/basic_definition.h"(120)

//____________________________________________________________________________
// Move

typedef Tag<Move_> const Move;       	// "projects/library/seqan/basic/basic_definition.h"(107)

//____________________________________________________________________________
// MyersBitVector

typedef Tag<MyersBitVector_> const MyersBitVector;       	// "projects/library/seqan/basic/basic_tag.h"(122)

//____________________________________________________________________________
// MyersHirschberg

typedef Tag<MyersHirschberg_> const MyersHirschberg;       	// "projects/library/seqan/basic/basic_tag.h"(131)

//____________________________________________________________________________
// NeedlemanWunsch

typedef Tag<NeedlemanWunsch_> const NeedlemanWunsch;       	// "projects/library/seqan/basic/basic_tag.h"(84)

//____________________________________________________________________________
// NonMinimalCtor

typedef Tag<NonMinimalCtor_> const NonMinimalCtor;       	// "projects/library/seqan/basic/basic_definition.h"(124)

//____________________________________________________________________________
// Nussinov

typedef Tag<Nussinov_> const Nussinov;       	// "projects/library/seqan/basic/basic_tag.h"(188)

//____________________________________________________________________________
// PoolAllocator

typedef Allocator<MultiPool<Allocator<SimpleAlloc<Default> >, 0x100> > PoolAllocator;       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(54)

//____________________________________________________________________________
// Rooted

typedef Tag<TagRooted_> const Rooted;       	// "projects/library/seqan/basic/basic_iterator.h"(49)

//____________________________________________________________________________
// SimpleAllocator

typedef Allocator<SimpleAlloc<Default> > SimpleAllocator;       	// "projects/library/seqan/basic/basic_allocator_simple.h"(51)

//____________________________________________________________________________
// SmithWaterman

typedef Tag<SmithWaterman_> const SmithWaterman;       	// "projects/library/seqan/basic/basic_tag.h"(167)

//____________________________________________________________________________
// SmithWatermanClump

typedef Tag<SmithWatermanClump_> const SmithWatermanClump;       	// "projects/library/seqan/basic/basic_tag.h"(178)

//____________________________________________________________________________
// Standard

typedef Tag<TagStandard_> const Standard;       	// "projects/library/seqan/basic/basic_iterator.h"(52)

//____________________________________________________________________________
// TagAllocateStorage

typedef Tag<TagAllocateStorage_> const TagAllocateStorage;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(85)

//____________________________________________________________________________
// TagAllocateTemp

typedef Tag<TagAllocateTemp_> const TagAllocateTemp;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(82)

//____________________________________________________________________________
// TagAllocateUnspecified

typedef Tag<TagAllocateUnspecified_> const TagAllocateUnspecified;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(79)

//____________________________________________________________________________
// Unicode

typedef wchar_t Unicode;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(63)

//____________________________________________________________________________
// WatermanEggert

typedef Tag<SmithWatermanClump_> const WatermanEggert;       	// "projects/library/seqan/basic/basic_tag.h"(179)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace debug {

//____________________________________________________________________________
// Error

template <typename TAction> void Error(const char * file, int line, const char * comment);       	// "projects/library/seqan/basic/basic_debug.h"(254)

//____________________________________________________________________________
// Message

template <typename TAction> void Message(const char * file, int line, const char * comment);       	// "projects/library/seqan/basic/basic_debug.h"(264)

//____________________________________________________________________________
// Result

template <typename TAction> void Result(const char * file, int line, const char * comment);       	// "projects/library/seqan/basic/basic_debug.h"(273)

//____________________________________________________________________________
// checkpoint

inline bool checkpoint(unsigned int line, char const* file);       	// "projects/library/seqan/basic/basic_debug.h"(325)

//____________________________________________________________________________
// testCheckpoint

inline void testCheckpoint(char const* file, unsigned int line);       	// "projects/library/seqan/basic/basic_debug.h"(342)

//____________________________________________________________________________
// verifyCheckpoints

inline void verifyCheckpoints(char const* file);       	// "projects/library/seqan/basic/basic_debug.h"(350)

} //namespace debug
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// TValue

template <typename TValue, size_t I> inline void setValue(Holder<TValue *, Tristate> & me, TValue (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(967)
template <typename TValue, size_t I> inline void setValue(Holder<TValue * const, Tristate> & me, TValue (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(991)

//____________________________________________________________________________
// _allocatorBlockNumber

template <typename TParentAllocator, unsigned int BLOCKING_LIMIT> inline unsigned int _allocatorBlockNumber(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > &, size_t size_);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(140)

//____________________________________________________________________________
// _arrayClearSpace_Default

template <typename TIterator> void _arrayClearSpace_Default(TIterator array_begin, size_t array_length, size_t keep_from, size_t move_to);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(777)

//____________________________________________________________________________
// _arrayClearSpace_Pointer

template <typename TValue> inline void _arrayClearSpace_Pointer(TValue * array_begin, size_t array_length, size_t keep_from, size_t move_to, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(353)
template <typename TValue> inline void _arrayClearSpace_Pointer(TValue * array_begin, size_t array_length, size_t keep_from, size_t move_to, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(365)

//____________________________________________________________________________
// _arrayConstructCopy_Default

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayConstructCopy_Default(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(352)

//____________________________________________________________________________
// _arrayConstructCopy_Pointer

template <typename TValueSource, typename TValueTarget> inline void _arrayConstructCopy_Pointer(TValueSource * source_begin, TValueSource * source_end, TValueTarget * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(100)
template <typename TValueSource, typename TValueTarget> inline void _arrayConstructCopy_Pointer(TValueSource * source_begin, TValueSource * source_end, TValueTarget const* target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(110)
template <typename TValueSource, typename TValueTarget> inline void _arrayConstructCopy_Pointer(TValueSource * source_begin, TValueSource * source_end, TValueTarget * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(121)

//____________________________________________________________________________
// _arrayConstructMove_Default

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayConstructMove_Default(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(400)

//____________________________________________________________________________
// _arrayConstructMove_Pointer

template <typename TValue> inline void _arrayConstructMove_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(145)
template <typename TValue> inline void _arrayConstructMove_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(155)

//____________________________________________________________________________
// _arrayConstruct_Default

template <typename TIterator1, typename TIterator2> inline void _arrayConstruct_Default(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(283)
template <typename TIterator1, typename TIterator2, typename TParam> inline void _arrayConstruct_Default(TIterator1 begin_, TIterator2 end_, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(307)

//____________________________________________________________________________
// _arrayConstruct_Pointer

template <typename TIterator> inline void _arrayConstruct_Pointer(TIterator, TIterator, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(36)
template <typename TIterator> inline void _arrayConstruct_Pointer(TIterator begin_, TIterator end_, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(45)
template <typename TIterator, typename TParam> inline void _arrayConstruct_Pointer(TIterator begin_, TIterator end_, TParam const & param_, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(66)
template <typename TIterator, typename TParam> inline void _arrayConstruct_Pointer(TIterator begin_, TIterator end_, TParam const & param_, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(76)

//____________________________________________________________________________
// _arrayCopyBackward_Default

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayCopyBackward_Default(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(550)

//____________________________________________________________________________
// _arrayCopyBackward_Pointer

template <typename TValue> inline void _arrayCopyBackward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(250)
template <typename TValue> inline void _arrayCopyBackward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(260)

//____________________________________________________________________________
// _arrayCopyForward_Default

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayCopyForward_Default(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(507)

//____________________________________________________________________________
// _arrayCopyForward_Pointer

template <typename TValue> inline void _arrayCopyForward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(216)
template <typename TValue> inline void _arrayCopyForward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(226)

//____________________________________________________________________________
// _arrayDestruct_Default

template <typename TIterator1, typename TIterator2> inline void _arrayDestruct_Default(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(439)

//____________________________________________________________________________
// _arrayDestruct_Pointer

template <typename TValue> inline void _arrayDestruct_Pointer(TValue * , TValue * , True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(178)
template <typename TValue> inline void _arrayDestruct_Pointer(TValue * begin_, TValue * end_, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(187)

//____________________________________________________________________________
// _arrayMoveBackward_Default

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayMoveBackward_Default(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(682)

//____________________________________________________________________________
// _arrayMoveBackward_Pointer

template <typename TValue> inline void _arrayMoveBackward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(318)
template <typename TValue> inline void _arrayMoveBackward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(328)

//____________________________________________________________________________
// _arrayMoveForward_Default

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayMoveForward_Default(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(633)

//____________________________________________________________________________
// _arrayMoveForward_Pointer

template <typename TValue> inline void _arrayMoveForward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(284)
template <typename TValue> inline void _arrayMoveForward_Pointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(294)

//____________________________________________________________________________
// _dataValue

template <typename TValue> inline typename Reference<Holder<TValue, Tristate> >::Type _dataValue(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(517)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate> const>::Type _dataValue(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(523)
template <typename TValue> inline typename Reference<Holder<TValue *, Tristate> >::Type _dataValue(Holder<TValue *, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(530)
template <typename TValue> inline typename Reference<Holder<TValue *, Tristate> const>::Type _dataValue(Holder<TValue *, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(536)
template <typename TValue> inline typename Reference<Holder<TValue * const, Tristate> >::Type _dataValue(Holder<TValue * const, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(543)
template <typename TValue> inline typename Reference<Holder<TValue * const, Tristate> const>::Type _dataValue(Holder<TValue * const, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(549)

//____________________________________________________________________________
// _getMaxIndex

template <typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline typename Size<ProfileType<TSourceValue, TSourceCount, TSourceSpec> const >::Type _getMaxIndex(ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(151)

//____________________________________________________________________________
// _holderAllocateObject

template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type * _holderAllocateObject(THolder & me, TValue const & data);       	// "projects/library/seqan/basic/basic_holder.h"(587)

//____________________________________________________________________________
// _holderAllocatePointer

template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type _holderAllocatePointer(THolder & me, TValue * data, True);       	// "projects/library/seqan/basic/basic_holder.h"(597)
template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type _holderAllocatePointer(THolder & me, TValue * data, False);       	// "projects/library/seqan/basic/basic_holder.h"(608)
template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type _holderAllocatePointer(THolder & me, TValue * data);       	// "projects/library/seqan/basic/basic_holder.h"(615)

//____________________________________________________________________________
// _holderDeallocate

template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue const & data);       	// "projects/library/seqan/basic/basic_holder.h"(624)
template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue * data, True);       	// "projects/library/seqan/basic/basic_holder.h"(632)
template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue * data, False);       	// "projects/library/seqan/basic/basic_holder.h"(641)
template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue * data);       	// "projects/library/seqan/basic/basic_holder.h"(647)

//____________________________________________________________________________
// _intPow

template <typename TValue, typename TExponent> inline TValue _intPow(TValue a, TExponent b);       	// "projects/library/seqan/basic/basic_definition.h"(380)

//____________________________________________________________________________
// _isSameType

template <typename T1, typename T2> inline bool _isSameType();       	// "projects/library/seqan/basic/basic_definition.h"(439)

//____________________________________________________________________________
// _max

template <typename _Ty> inline const _Ty& _max(const _Ty& _Left, const _Ty& _Right);       	// "projects/library/seqan/basic/basic_definition.h"(413)

//____________________________________________________________________________
// _min

template <typename _Tx> inline const _Tx& _min(const _Tx& _Left, const _Tx& _Right);       	// "projects/library/seqan/basic/basic_definition.h"(398)
template <typename _Tx, typename _Ty> inline _Tx _min(const _Tx& _Left, const _Ty& _Right);       	// "projects/library/seqan/basic/basic_definition.h"(407)

//____________________________________________________________________________
// _toParameter

template <typename T> typename _Parameter<T>::Type _toParameter(T * _object);       	// "projects/library/seqan/basic/basic_type.h"(447)
template <typename T> typename _Parameter<T>::Type _toParameter(T _object);       	// "projects/library/seqan/basic/basic_type.h"(454)

//____________________________________________________________________________
// _toPointer

template <typename T> typename _NonConstPointer<T>::Type _toPointer(T & _object);       	// "projects/library/seqan/basic/basic_type.h"(566)
template <typename T> typename _NonConstPointer<T const>::Type _toPointer(T const & _object);       	// "projects/library/seqan/basic/basic_type.h"(573)
template <typename T> typename _NonConstPointer<T *>::Type _toPointer(T * _object);       	// "projects/library/seqan/basic/basic_type.h"(581)

//____________________________________________________________________________
// addRef

template <typename T> inline void addRef(T & );       	// "projects/library/seqan/basic/basic_holder.h"(45)
template <typename T> inline void addRef(T const & );       	// "projects/library/seqan/basic/basic_holder.h"(51)

//____________________________________________________________________________
// allocate

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me, TValue * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(173)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void allocate(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me, TValue2 * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(302)
template <size_t SIZE, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<SinglePool<SIZE, TParentAllocator> > & me, TValue * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(162)
template <typename TValue, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void allocate(Allocator<SinglePool2<TValue, TParentAllocator> > & me, TValue2 * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(279)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me, TValue * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(165)
template <typename T, typename TValue, typename TSize> inline void allocate(T const & me, TValue * & data, TSize count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(129)
template <typename T, typename TValue, typename TSize> inline void allocate(T & me, TValue * & data, TSize count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(137)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void allocate(T const &, TValue * & data, TSize count, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(147)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void allocate(T &, TValue * & data, TSize count, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(173)
template <typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<SimpleAlloc<TParentAllocator> > & me, TValue * & data, TSize count, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(146)

//____________________________________________________________________________
// arrayClearSpace

template <typename TIterator> void arrayClearSpace(TIterator array_begin, size_t array_length, size_t keep_from, size_t move_to);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(821)
template <typename TValue> void arrayClearSpace(TValue * array_begin, size_t array_length, size_t keep_from, size_t move_to);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(373)

//____________________________________________________________________________
// arrayConstruct

template <typename TIterator1, typename TIterator2> inline void arrayConstruct(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(295)
template <typename TIterator1, typename TIterator2, typename TParam> inline void arrayConstruct(TIterator1 begin_, TIterator2 end_, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(320)
template <typename TValue> inline void arrayConstruct(TValue * begin_, TValue * end_);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(53)
template <typename TValue, typename TParam> inline void arrayConstruct(TValue * begin_, TValue * end_, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(85)

//____________________________________________________________________________
// arrayConstructCopy

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayConstructCopy(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(367)
template <typename TValueSource, typename TValueTarget> inline void arrayConstructCopy(TValueSource * source_begin, TValueSource * source_end, TValueTarget * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(130)

//____________________________________________________________________________
// arrayConstructMove

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayConstructMove(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(415)
template <typename TValue> inline void arrayConstructMove(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(164)

//____________________________________________________________________________
// arrayCopy

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayCopy(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(594)

//____________________________________________________________________________
// arrayCopyBackward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayCopyBackward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(559)
template <typename TValue> inline void arrayCopyBackward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(269)

//____________________________________________________________________________
// arrayCopyForward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayCopyForward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(516)
template <typename TValue> inline void arrayCopyForward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(235)

//____________________________________________________________________________
// arrayDestruct

template <typename TIterator1, typename TIterator2> inline void arrayDestruct(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(451)
template <typename TValue> inline void arrayDestruct(TValue * begin_, TValue * end_);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(195)

//____________________________________________________________________________
// arrayFill

template <typename TIterator1, typename TIterator2, typename TValue> inline void arrayFill(TIterator1 begin_, TIterator2 end_, TValue const & value);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(477)

//____________________________________________________________________________
// arrayMove

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayMove(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(735)

//____________________________________________________________________________
// arrayMoveBackward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayMoveBackward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(697)
template <typename TValue> inline void arrayMoveBackward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(337)

//____________________________________________________________________________
// arrayMoveForward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayMoveForward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(647)
template <typename TValue> inline void arrayMoveForward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(303)

//____________________________________________________________________________
// assign

template <typename TTargetContainer, typename TIterator, typename TSpec, typename TSource> inline void assign(Iter<TTargetContainer, AdaptorIterator<TIterator, TSpec> > & target, TSource const & source);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(520)
template <typename TValue> inline void assign(VoidHolder & me, TValue const & val);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(188)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(172)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(52)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(60)
template <typename TTargetSpec, typename TSource> inline void assign(Proxy<TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(73)
template <typename TTargetSpec, typename TSource> inline void assign(Proxy<TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(82)
template <typename TValue> inline void assign(Holder<TValue, Tristate> & target_, Holder<TValue, Tristate> const & source_);       	// "projects/library/seqan/basic/basic_holder.h"(1111)
template <typename TValue> inline void assign(Holder<TValue, Simple> & target_, Holder<TValue, Simple> const & source_);       	// "projects/library/seqan/basic/basic_holder.h"(1331)
template <typename TValue> inline void assign(Holder<TValue, Tristate2> & target_, Holder<TValue, Tristate2> const & source_);       	// "projects/library/seqan/basic/basic_holder.h"(1648)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, SimpleType<TSourceValue, TSourceSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(296)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, SimpleType<TSourceValue, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(304)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(315)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(323)
template <typename TTargetValue, typename TTargetSpec, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, Proxy<TSourceSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(336)
template <typename TTargetValue, typename TTargetSpec, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, Proxy<TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(345)
template <typename TValue, typename TSpec> inline void assign(__int64 & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(360)
template <typename TValue, typename TSpec> inline void assign(__int64 & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(368)
template <typename TValue, typename TSpec> inline void assign(__uint64 & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(378)
template <typename TValue, typename TSpec> inline void assign(__uint64 & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(386)
template <typename TValue, typename TSpec> inline void assign(int & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(396)
template <typename TValue, typename TSpec> inline void assign(int & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(404)
template <typename TValue, typename TSpec> inline void assign(unsigned int & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(414)
template <typename TValue, typename TSpec> inline void assign(unsigned int & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(422)
template <typename TValue, typename TSpec> inline void assign(short & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(433)
template <typename TValue, typename TSpec> inline void assign(short & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(441)
template <typename TValue, typename TSpec> inline void assign(unsigned short & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(451)
template <typename TValue, typename TSpec> inline void assign(unsigned short & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(459)
template <typename TValue, typename TSpec> inline void assign(char & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(469)
template <typename TValue, typename TSpec> inline void assign(char & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(477)
template <typename TValue, typename TSpec> inline void assign(signed char & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(487)
template <typename TValue, typename TSpec> inline void assign(signed char & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(495)
template <typename TValue, typename TSpec> inline void assign(unsigned char & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(505)
template <typename TValue, typename TSpec> inline void assign(unsigned char & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(513)
inline void assign(Ascii & c_target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1157)
inline void assign(Ascii & c_target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1165)
inline void assign(Ascii & c_target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1172)
inline void assign(Ascii & c_target, AminoAcid const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1179)
inline void assign(Dna & target, Byte c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1190)
inline void assign(Dna & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1199)
inline void assign(Dna & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1208)
inline void assign(Dna & target, Dna5 const & c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1217)
inline void assign(Dna & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1226)
inline void assign(Dna5 & target, Byte c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1237)
inline void assign(Dna5 & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1246)
inline void assign(Dna5 & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1255)
inline void assign(Dna5 & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1264)
inline void assign(Dna5 & target, Dna const & c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1274)
inline void assign(Iupac & target, Byte c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1285)
inline void assign(Iupac & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1294)
inline void assign(Iupac & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1303)
inline void assign(Iupac & target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1310)
inline void assign(Iupac & target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1317)
inline void assign(AminoAcid & target, Byte c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1328)
inline void assign(AminoAcid & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1337)
inline void assign(AminoAcid & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1346)
inline void assign(DnaQ & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1445)
inline void assign(DnaQ & target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1455)
inline void assign(Dna5Q & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1466)
inline void assign(Dna5 & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1476)
inline void assign(Dna5Q & target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1487)
inline void assign(Dna & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1498)
inline void assign(DnaQ & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1509)
inline void assign(DnaQ & target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1520)
inline void assign(DnaQ & target, Byte c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1528)
inline void assign(DnaQ & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1537)
inline void assign(DnaQ & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1546)
inline void assign(Dna5Q & target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1556)
inline void assign(Dna & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1567)
inline void assign(Dna5 & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1576)
inline void assign(Dna5Q & target, Byte c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1587)
inline void assign(Dna5Q & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1596)
inline void assign(Dna5Q & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1605)
inline void assign(Dna5Q & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1614)
inline void assign(__int64 & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1628)
inline void assign(__int64 & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1636)
inline void assign(__uint64 & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1646)
inline void assign(__uint64 & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1654)
inline void assign(int & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1664)
inline void assign(int & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1672)
inline void assign(unsigned int & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1682)
inline void assign(unsigned int & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1690)
inline void assign(short & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1701)
inline void assign(short & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1709)
inline void assign(unsigned short & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1719)
inline void assign(unsigned short & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1727)
inline void assign(char & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1737)
inline void assign(char & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1745)
inline void assign(signed char & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1755)
inline void assign(signed char & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1763)
inline void assign(unsigned char & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1773)
inline void assign(unsigned char & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1781)
inline void assign(__int64 & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1792)
inline void assign(__int64 & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1800)
inline void assign(__uint64 & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1810)
inline void assign(__uint64 & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1818)
inline void assign(int & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1828)
inline void assign(int & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1836)
inline void assign(unsigned int & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1846)
inline void assign(unsigned int & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1854)
inline void assign(short & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1865)
inline void assign(short & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1873)
inline void assign(unsigned short & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1883)
inline void assign(unsigned short & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1891)
inline void assign(char & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1901)
inline void assign(char & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1909)
inline void assign(signed char & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1919)
inline void assign(signed char & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1927)
inline void assign(unsigned char & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1937)
inline void assign(unsigned char & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1945)
template <typename TTargetContainer, typename TSource> inline void assign(Iter<TTargetContainer, StdIteratorAdaptor> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(427)
template <typename TTargetContainer, typename TSource> inline void assign(Iter<TTargetContainer, PositionIterator> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_iterator_position.h"(450)

//____________________________________________________________________________
// assignHost

template <typename T, typename THost> inline void assignHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(135)
template <typename T, typename THost> inline void assignHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(143)

//____________________________________________________________________________
// assignQualityValue

inline void assignQualityValue(DnaQ &c, int q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1985)
inline void assignQualityValue(Dna5Q &c, int q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1991)
inline void assignQualityValue(DnaQ &c, Ascii q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1998)
inline void assignQualityValue(Dna5Q &c, Ascii q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2004)

//____________________________________________________________________________
// assignValue

template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(294)
template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(302)
template <typename TValue, typename TSource> inline void assignValue(Holder<TValue, Tristate> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1069)
template <typename TValue, typename TSource> inline void assignValue(Holder<TValue, Simple> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1309)
template <typename TValue, typename TSource> inline void assignValue(Holder<TValue, Tristate2> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1606)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(165)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue const & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(172)
template <typename T, typename TValue> inline void assignValue(T & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(258)
template <typename T, typename TValue> inline void assignValue(T const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(268)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, PositionIterator> & me, TValue _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(194)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, PositionIterator> const & me, TValue _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(202)

//____________________________________________________________________________
// assignValueAt

template <typename TObject, typename TPos, typename TSource> inline TSource & assignValueAt(TObject &me, TPos k, TSource &source);       	// "projects/library/seqan/basic/basic_aggregates.h"(462)
template <typename TObject, typename TPos, typename TSource> inline TSource const & assignValueAt(TObject &me, TPos k, TSource const &source);       	// "projects/library/seqan/basic/basic_aggregates.h"(469)
template <typename _T, unsigned _size, typename tmpS, typename TPos> inline tmpS const assignValueAt(Tuple<_T, _size, void> &me, TPos k, tmpS const source);       	// "projects/library/seqan/basic/basic_aggregates.h"(475)
template <typename _T, unsigned _size, typename tmpS, typename TPos> inline tmpS const assignValueAt(Tuple<_T, _size, Compressed> &me, TPos k, tmpS const source);       	// "projects/library/seqan/basic/basic_aggregates.h"(480)
template <typename _T, typename tmpS, typename _Spec, unsigned _size, typename TPos> inline SimpleType<tmpS, _Spec> const & assignValueAt(Tuple<_T, _size, Compressed> &me, TPos k, SimpleType<tmpS, _Spec> const &source);       	// "projects/library/seqan/basic/basic_aggregates.h"(488)

//____________________________________________________________________________
// assignValueI1

template <typename T1, typename T2, typename TCompression, typename T> inline void assignValueI1(Pair<T1, T2, TCompression> &pair, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(633)
template <typename T1, typename T2, unsigned valueSizeI1, typename T> inline void assignValueI1(Pair<T1, T2, CutCompressed<valueSizeI1> > &pair, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(644)
template <typename T1, typename T2, typename T3, typename TCompression, typename T> inline T const assignValueI1(Triple<T1, T2, T3, TCompression> &triple, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(658)

//____________________________________________________________________________
// assignValueI2

template <typename T1, typename T2, typename TCompression, typename T> inline void assignValueI2(Pair<T1, T2, TCompression> &pair, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(638)
template <typename T1, typename T2, unsigned valueSizeI1, typename T> inline void assignValueI2(Pair<T1, T2, CutCompressed<valueSizeI1> > &pair, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(651)
template <typename T1, typename T2, typename T3, typename TCompression, typename T> inline T const assignValueI2(Triple<T1, T2, T3, TCompression> &triple, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(663)

//____________________________________________________________________________
// assignValueI3

template <typename T1, typename T2, typename T3, typename TCompression, typename T> inline T const assignValueI3(Triple<T1, T2, T3, TCompression> &triple, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(668)

//____________________________________________________________________________
// atBegin

template <typename T, typename TContainer> inline bool atBegin(T const & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(394)
template <typename T> inline bool atBegin(T const & it);       	// "projects/library/seqan/basic/basic_iterator.h"(404)

//____________________________________________________________________________
// atEnd

template <typename TContainer, typename TIterator, typename TSpec> inline bool atEnd(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(507)
template <typename T, typename TContainer> inline bool atEnd(T & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(435)
template <typename T, typename TContainer> inline bool atEnd(T const & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(443)
template <typename T> inline bool atEnd(T & it);       	// "projects/library/seqan/basic/basic_iterator.h"(452)
template <typename T> inline bool atEnd(T const & it);       	// "projects/library/seqan/basic/basic_iterator.h"(459)

//____________________________________________________________________________
// atNil

template <typename TIterator> inline bool atNil(TIterator & me);       	// "projects/library/seqan/basic/basic_iterator.h"(714)
template <typename TIterator> inline bool atNil(TIterator * me);       	// "projects/library/seqan/basic/basic_iterator.h"(723)

//____________________________________________________________________________
// call_allocate

template <typename TMe, typename TValue, typename TSize> inline void call_allocate(TMe & me, TValue * & data, TSize const count);       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(33)

//____________________________________________________________________________
// call_deallocate

template <typename TMe, typename TValue, typename TSize> inline void call_deallocate(TMe & me, TValue * data, TSize const count);       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(38)

//____________________________________________________________________________
// clear

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator> void clear(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(157)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator> void clear(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(289)
template <size_t SIZE, typename TParentAllocator> void clear(Allocator<SinglePool<SIZE, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(146)
template <typename TValue, typename TParentAllocator> void clear(Allocator<SinglePool2<TValue, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(266)
inline void clear(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(110)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT> void clear(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(125)
template <typename _T, unsigned _size, typename TCompression> inline void clear(Tuple<_T, _size, TCompression> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(499)
template <typename _T, unsigned _size> inline void clear(Tuple<_T, _size, Compressed> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(503)
template <typename TValue> inline void clear(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(661)
template <typename TValue> inline void clear(Holder<TValue, Simple> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1242)
template <typename TValue> inline void clear(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1458)
template <typename TParentAllocator> void clear(Allocator<SimpleAlloc<TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(126)

//____________________________________________________________________________
// clearHost

template <typename T> inline void clearHost(T & me);       	// "projects/library/seqan/basic/basic_host.h"(59)

//____________________________________________________________________________
// const

template <typename TValue, size_t I> inline void setValue(Holder<TValue *, Tristate> & me, TValue const (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(979)
template <typename TValue, size_t I> inline void setValue(Holder<TValue * const, Tristate> & me, TValue const (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(1003)

//____________________________________________________________________________
// container

template <typename TContainer, typename TIterator, typename TSpec> inline typename _Parameter<TContainer>::Type container(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(169)
template <typename TContainer, typename TIterator, typename TSpec> inline typename _Parameter<TContainer>::Type container(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(176)
template <typename T> inline typename Container<T>::Type container(T me);       	// "projects/library/seqan/basic/basic_iterator.h"(328)
template <typename TContainer> inline typename _Parameter<TContainer>::Type container(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(117)
template <typename TContainer> inline typename _Parameter<TContainer>::Type container(Iter<TContainer, PositionIterator> const & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(124)

//____________________________________________________________________________
// convert

template <typename TTarget, typename TSource> inline typename Convert<TTarget, TSource>::Type convert(TSource const & source);       	// "projects/library/seqan/basic/basic_converter.h"(103)

//____________________________________________________________________________
// convertImpl

template <typename TTarget, typename T, typename TSpec> inline typename Convert<TTarget, Proxy<TSpec> >::Type convertImpl(Convert<TTarget, T> const, Proxy<TSpec> & source);       	// "projects/library/seqan/basic/basic_proxy.h"(273)
template <typename TTarget, typename T, typename TSpec> inline typename Convert<TTarget, Proxy<TSpec> const>::Type convertImpl(Convert<TTarget, T> const, Proxy<TSpec> const & source);       	// "projects/library/seqan/basic/basic_proxy.h"(280)
template <typename TTarget, typename T, typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline typename Convert<TTarget, ProfileType<TSourceValue, TSourceCount, TSourceSpec> >::Type convertImpl(Convert<TTarget, T> const, ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(182)
template <typename TTarget, typename T, typename TSource> inline typename Convert<TTarget, TSource>::Type convertImpl(Convert<TTarget, T> const, TSource const & source);       	// "projects/library/seqan/basic/basic_converter.h"(78)
template <typename TTarget, typename T, typename TSourceValue, typename TSourceSpec> inline typename _RemoveConst<TTarget>::Type convertImpl(Convert<TTarget, T> const, SimpleType<TSourceValue, TSourceSpec> const & source_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(249)

//____________________________________________________________________________
// convertQuality

inline void convertQuality(Ascii & c, int q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1976)

//____________________________________________________________________________
// create

template <typename TValue> inline TValue & create(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(134)
template <typename TValue> inline void create(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(709)
template <typename TValue> inline void create(Holder<TValue *, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(738)
template <typename TValue> inline void create(Holder<TValue * const, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(765)
template <typename TValue, typename TValue2> inline void create(Holder<TValue, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(795)
template <typename TValue, typename TValue2> inline void create(Holder<TValue const, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(813)
template <typename TValue, typename TValue2> inline void create(Holder<TValue *, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(825)
template <typename TValue, typename TValue2> inline void create(Holder<TValue * const, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(837)
template <typename TValue> inline void create(Holder<TValue, Simple> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1251)
template <typename TValue> inline void create(Holder<TValue, Simple> & me, TValue const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1261)
template <typename TValue> inline void create(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1489)
template <typename TValue> inline void create(Holder<TValue, Tristate2> & me, TValue const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1523)

//____________________________________________________________________________
// createHost

template <typename T> inline void createHost(T & me);       	// "projects/library/seqan/basic/basic_host.h"(69)
template <typename T, typename THost> inline void createHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(80)
template <typename T, typename THost> inline void createHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(88)

//____________________________________________________________________________
// deallocate

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me, TValue * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(222)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void deallocate(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me, TValue2 * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(313)
template <size_t SIZE, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<SinglePool<SIZE, TParentAllocator> > & me, TValue * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(202)
template <typename TValue, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void deallocate(Allocator<SinglePool2<TValue, TParentAllocator> > & me, TValue2 * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(290)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me, TValue * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(207)
template <typename T, typename TValue, typename TSize> inline void deallocate(T const & me, TValue * data, TSize const count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(228)
template <typename T, typename TValue, typename TSize> inline void deallocate(T & me, TValue * data, TSize const count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(236)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void deallocate( T const & , TValue * data, TSize count, TSize, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(251)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void deallocate( T & , TValue * data, TSize count, TSize, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(275)
template <typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<SimpleAlloc<TParentAllocator> > & me, TValue * data, TSize, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(181)

//____________________________________________________________________________
// dependent

template <typename TValue> inline bool dependent(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(572)
template <typename TValue> inline bool dependent(Holder<TValue, Simple> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1232)
template <typename TValue> inline bool dependent(Holder<TValue, Tristate2> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1444)

//____________________________________________________________________________
// dependentHost

template <typename T> inline bool dependentHost(T const & me);       	// "projects/library/seqan/basic/basic_host.h"(49)

//____________________________________________________________________________
// destroy

template <typename TValue> inline void destroy(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(146)

//____________________________________________________________________________
// detach

template <typename TValue> inline void detach(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(866)
template <typename TValue> inline void detach(Holder<TValue, Simple> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1271)
template <typename TValue> inline void detach(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1544)

//____________________________________________________________________________
// difference

template <typename TIterator> inline typename Difference<TIterator>::Type difference( TIterator const & begin, TIterator const & end);       	// "projects/library/seqan/basic/basic_iterator.h"(657)

//____________________________________________________________________________
// empty

inline bool empty(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(97)
inline bool empty(VoidHolder const & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(102)
template <typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline bool empty(ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(137)
template <typename TValue> inline bool empty(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(560)
template <typename TValue> inline bool empty(Holder<TValue, Simple> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1222)
template <typename TValue> inline bool empty(Holder<TValue, Tristate2> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1432)

//____________________________________________________________________________
// emptyHost

template <typename T> inline bool emptyHost(T const & me);       	// "projects/library/seqan/basic/basic_host.h"(39)

//____________________________________________________________________________
// gapValue

template <typename T> inline T gapValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(81)

//____________________________________________________________________________
// gapValueImpl

template <typename T> inline T const & gapValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(48)
inline char const & gapValueImpl(char *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(412)
inline char const & gapValueImpl(char const *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(419)

//____________________________________________________________________________
// getQualityValue

inline int getQualityValue(DnaQ const &c);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1965)
inline int getQualityValue(Dna5Q const &c);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1970)

//____________________________________________________________________________
// getValue

template <typename TValue> inline TValue & getValue(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(172)
template <typename TValue> inline TValue const & getValue(VoidHolder const & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(178)
template <typename TSpec> typename GetValue<Proxy<TSpec> >::Type getValue(Proxy<TSpec> & me);       	// "projects/library/seqan/basic/basic_proxy.h"(244)
template <typename TSpec> typename GetValue<Proxy<TSpec> const>::Type getValue(Proxy<TSpec> const & me);       	// "projects/library/seqan/basic/basic_proxy.h"(250)
template <typename T> inline typename GetValue<T>::Type getValue(T & me);       	// "projects/library/seqan/basic/basic_iterator.h"(210)
template <typename T> inline typename GetValue<T const>::Type getValue(T const & me);       	// "projects/library/seqan/basic/basic_iterator.h"(217)
template <typename T> inline T & getValue(T * me);       	// "projects/library/seqan/basic/basic_iterator.h"(225)

//____________________________________________________________________________
// getValueI1

template <typename T1, typename T2, typename TCompression> inline T1 getValueI1(Pair<T1, T2, TCompression> const &pair);       	// "projects/library/seqan/basic/basic_aggregates.h"(592)
template <typename T1, typename T2, unsigned valueSizeI1> inline T1 getValueI1(Pair<T1, T2, CutCompressed<valueSizeI1> > const &pair);       	// "projects/library/seqan/basic/basic_aggregates.h"(602)
template <typename T1, typename T2, typename T3, typename TCompression> inline T1 getValueI1(Triple<T1, T2, T3, TCompression> const &triple);       	// "projects/library/seqan/basic/basic_aggregates.h"(615)

//____________________________________________________________________________
// getValueI2

template <typename T1, typename T2, typename TCompression> inline T2 getValueI2(Pair<T1, T2, TCompression> const &pair);       	// "projects/library/seqan/basic/basic_aggregates.h"(597)
template <typename T1, typename T2, unsigned valueSizeI1> inline T2 getValueI2(Pair<T1, T2, CutCompressed<valueSizeI1> > const &pair);       	// "projects/library/seqan/basic/basic_aggregates.h"(608)
template <typename T1, typename T2, typename T3, typename TCompression> inline T2 getValueI2(Triple<T1, T2, T3, TCompression> const &triple);       	// "projects/library/seqan/basic/basic_aggregates.h"(620)

//____________________________________________________________________________
// getValueI3

template <typename T1, typename T2, typename T3, typename TCompression> inline T3 getValueI3(Triple<T1, T2, T3, TCompression> const &triple);       	// "projects/library/seqan/basic/basic_aggregates.h"(625)

//____________________________________________________________________________
// goBegin

template <typename TIterator, typename TContainer> inline void goBegin(TIterator & it, TContainer & container);       	// "projects/library/seqan/basic/basic_iterator.h"(488)
template <typename TIterator> inline void goBegin(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(506)

//____________________________________________________________________________
// goEnd

template <typename TIterator, typename TContainer> inline void goEnd(TIterator & it, TContainer & container);       	// "projects/library/seqan/basic/basic_iterator.h"(536)
template <typename TIterator, typename TContainer> inline void goEnd(TIterator & it, TContainer const & container);       	// "projects/library/seqan/basic/basic_iterator.h"(544)
template <typename TIterator> inline void goEnd(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(552)

//____________________________________________________________________________
// goFurther

template <typename TIterator, typename TDiff> inline void goFurther(TIterator & it, TDiff steps);       	// "projects/library/seqan/basic/basic_iterator.h"(602)

//____________________________________________________________________________
// goNext

template <typename TContainer, typename TIterator, typename TSpec> inline void goNext(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(361)
template <typename TContainer> inline void goNext(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(280)
template <typename TIterator> inline void goNext(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(576)
template <typename TContainer> inline void goNext(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(305)

//____________________________________________________________________________
// goNil

template <typename TIterator> inline void goNil(TIterator & me);       	// "projects/library/seqan/basic/basic_iterator.h"(681)
template <typename TIterator> inline void goNil(TIterator * & me);       	// "projects/library/seqan/basic/basic_iterator.h"(689)

//____________________________________________________________________________
// goPrevious

template <typename TContainer, typename TIterator, typename TSpec> inline void goPrevious(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(373)
template <typename TContainer> inline void goPrevious(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(292)
template <typename TIterator> inline void goPrevious(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(626)
template <typename TContainer> inline void goPrevious(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(317)

//____________________________________________________________________________
// host

template <typename T> inline typename Host<T>::Type & host(T & me);       	// "projects/library/seqan/basic/basic_host.h"(117)
template <typename T> inline typename Host<T const>::Type & host(T const & me);       	// "projects/library/seqan/basic/basic_host.h"(124)
template <typename THost, typename TValue> THost & host(ToStdAllocator<THost, TValue> & me);       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(158)

//____________________________________________________________________________
// hostIterator

template <typename TContainer, typename TIterator, typename TSpec> inline TIterator & hostIterator(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(205)
template <typename TContainer, typename TIterator, typename TSpec> inline TIterator const & hostIterator(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(212)
template <typename TContainer> inline typename StdContainerIterator<TContainer>::Type & hostIterator(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(129)
template <typename TContainer> inline typename StdContainerIterator<TContainer>::Type const & hostIterator(Iter<TContainer, StdIteratorAdaptor> const & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(135)

//____________________________________________________________________________
// infimumValue

template <typename T> inline T const & infimumValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(188)
template <typename T> inline T const & infimumValue(T);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(197)

//____________________________________________________________________________
// infimumValueImpl

template <typename T> inline T const & infimumValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(439)
inline float const & infimumValueImpl(float *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(678)
inline double const & infimumValueImpl(double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(705)
inline long double const & infimumValueImpl(long double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(732)

//____________________________________________________________________________
// iter

template <typename TIterator> inline TIterator & iter(Proxy<IteratorProxy<TIterator> > & me);       	// "projects/library/seqan/basic/basic_proxy.h"(150)
template <typename TIterator> inline TIterator const & iter(Proxy<IteratorProxy<TIterator> > const & me);       	// "projects/library/seqan/basic/basic_proxy.h"(156)

//____________________________________________________________________________
// length

template <typename _T, unsigned _size, typename TCompression> inline unsigned length(Tuple<_T, _size, TCompression> const &);       	// "projects/library/seqan/basic/basic_aggregates.h"(448)

//____________________________________________________________________________
// lexLess

template <typename _T> inline bool lexLess(const _T& _Left, const _T& _Right);       	// "projects/library/seqan/basic/basic_compare.h"(54)
template <typename _T, typename TSpec> inline bool lexLess(SimpleType<_T, TSpec> const &_Left, SimpleType<_T, TSpec> const &_Right);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(987)

//____________________________________________________________________________
// log2

template <typename T> inline unsigned int log2(T val);       	// "projects/library/seqan/basic/basic_definition.h"(368)

//____________________________________________________________________________
// memset

template <unsigned SIZE> finline void memset(void* ptr, unsigned char c);       	// "projects/library/seqan/basic/basic_metaprogramming.h"(241)
template <unsigned SIZE, unsigned char c> finline void memset(void* ptr);       	// "projects/library/seqan/basic/basic_metaprogramming.h"(287)

//____________________________________________________________________________
// move

template <typename TTarget, typename TSource> inline void move(TTarget & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(108)
template <typename TTarget, typename TSource> inline void move(TTarget const & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(116)
template <typename TTarget, typename TSource> inline void move(TTarget & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(124)
template <typename TTarget, typename TSource> inline void move(TTarget const & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(132)

//____________________________________________________________________________
// moveHost

template <typename T, typename THost> inline void moveHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(153)
template <typename T, typename THost> inline void moveHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(161)

//____________________________________________________________________________
// moveValue

template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(315)
template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(323)
template <typename TValue, typename TSource> inline void moveValue(Holder<TValue, Tristate> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1090)
template <typename TValue, typename TSource> inline void moveValue(Holder<TValue, Simple> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1320)
template <typename TValue, typename TSource> inline void moveValue(Holder<TValue, Tristate2> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1627)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(184)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue const & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(191)
template <typename T, typename TValue> inline void moveValue(T & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(297)
template <typename T, typename TValue> inline void moveValue(T const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(306)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, PositionIterator> & me, TValue _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(215)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, PositionIterator> const & me, TValue _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(223)

//____________________________________________________________________________
// nukeCopies

template <typename TValue> inline void nukeCopies(TValue* &);       	// "projects/library/seqan/basic/basic_volatile_ptr.h"(152)
template <typename TValue> inline void nukeCopies(VolatilePtr<TValue> &ptr);       	// "projects/library/seqan/basic/basic_volatile_ptr.h"(155)

//____________________________________________________________________________
// operator!=

template <typename TContainer, typename TIterator, typename TSpec> inline bool operator!= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(349)
template <typename TSpec, typename TRight> inline bool operator!= (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(337)
template <typename TLeft, typename TSpec> inline bool operator!= (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(348)
template <typename TLeftSpec, typename TRightSpec> inline bool operator!= (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(359)
template <typename TSpec> inline bool operator!= (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(371)
template <typename _T, unsigned _sizeL, unsigned _sizeR> inline bool operator!=(Tuple<_T, _sizeL, Compressed> const &_left, Tuple<_T, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(523)
template <typename L1, typename L2, typename LCompression, typename R1, typename R2, typename RCompression> inline bool operator!=(Pair<L1, L2, LCompression> const &_left, Pair<R1, R2, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(680)
template <typename L1, typename L2, unsigned LSizeI1, typename R1, typename R2, unsigned RSizeI1> inline bool operator!=(Pair<L1, L2, CutCompressed<LSizeI1> > const &_left, Pair<R1, R2, CutCompressed<RSizeI1> > const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(689)
template <typename L1, typename L2, typename L3, typename LCompression, typename R1, typename R2, typename R3, typename RCompression> inline bool operator!=(Triple<L1, L2, L3, LCompression> const &_left, Triple<R1, R2, R3, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(703)
template <typename TValue, typename TSpec, typename TRight> inline bool operator!= (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(633)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator!= (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(644)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator!= (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(655)
template <typename TValue, typename TSpec> inline bool operator!= (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(667)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator!= (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(677)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator!= (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(688)
template <typename TContainer> inline bool operator!= (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(216)
template <typename TContainer> inline bool operator!= (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(249)

//____________________________________________________________________________
// operator*

template <typename TContainer, typename TSpec> inline typename Reference<Iter<TContainer, TSpec> >::Type operator* (Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(143)
template <typename TContainer, typename TSpec> inline typename Reference<Iter<TContainer, TSpec> const>::Type operator* (Iter<TContainer, TSpec> const & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(150)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename TSpec, typename TSize> inline Iter<TContainer, TSpec> operator+ (Iter<TContainer, TSpec> const & me, TSize size);       	// "projects/library/seqan/basic/basic_iterator_base.h"(218)
template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(386)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(395)
template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (TIntegral left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(404)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (int left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(413)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> operator+ (Iter<TContainer, StdIteratorAdaptor> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(305)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> operator+ (Iter<TContainer, StdIteratorAdaptor> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(314)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> operator+ (TIntegral left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(323)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> operator+ (int left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(332)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> operator+ (Iter<TContainer, PositionIterator> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(329)
template <typename TContainer> inline Iter<TContainer, PositionIterator> operator+ (Iter<TContainer, PositionIterator> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(338)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> operator+ (TIntegral left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(347)
template <typename TContainer> inline Iter<TContainer, PositionIterator> operator+ (int left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(356)

//____________________________________________________________________________
// operator++

template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> const & operator++ (Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(162)
template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> operator++ (Iter<TContainer, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_iterator_base.h"(171)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> & operator++ (SimpleType<TValue, TSpec> & me);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(997)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> operator++ (SimpleType<TValue, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1005)

//____________________________________________________________________________
// operator+=

template <typename TContainer, typename TSpec, typename TSize> inline Iter<TContainer, TSpec> const & operator+= (Iter<TContainer, TSpec> & me, TSize size);       	// "projects/library/seqan/basic/basic_iterator_base.h"(228)
template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator+= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(426)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator+= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(436)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> & operator+= (Iter<TContainer, StdIteratorAdaptor> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(345)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> & operator+= (Iter<TContainer, StdIteratorAdaptor> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(355)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> & operator+= (Iter<TContainer, PositionIterator> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(369)
template <typename TContainer> inline Iter<TContainer, PositionIterator> & operator+= (Iter<TContainer, PositionIterator> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(379)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator- (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(450)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator- (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(459)
template <typename TContainer, typename TIterator, typename TSpec> inline typename Difference<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > >::Type operator- (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(470)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> operator- (Iter<TContainer, StdIteratorAdaptor> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(369)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> operator- (Iter<TContainer, StdIteratorAdaptor> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(378)
template <typename TContainer> inline typename Difference<Iter<TContainer, StdIteratorAdaptor> >::Type operator- (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(389)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> operator- (Iter<TContainer, PositionIterator> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(393)
template <typename TContainer> inline Iter<TContainer, PositionIterator> operator- (Iter<TContainer, PositionIterator> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(402)
template <typename TContainer> inline typename Difference<TContainer>::Type operator- (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(413)

//____________________________________________________________________________
// operator--

template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> const & operator-- (Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(185)
template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> operator-- (Iter<TContainer, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_iterator_base.h"(194)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> & operator-- (SimpleType<TValue, TSpec> & me);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1016)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> operator-- (SimpleType<TValue, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1024)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator-= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(483)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator-= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(493)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> & operator-= (Iter<TContainer, StdIteratorAdaptor> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(402)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> & operator-= (Iter<TContainer, StdIteratorAdaptor> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(412)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> & operator-= (Iter<TContainer, PositionIterator> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(426)
template <typename TContainer> inline Iter<TContainer, PositionIterator> & operator-= (Iter<TContainer, PositionIterator> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(436)

//____________________________________________________________________________
// operator<

template <typename TSpec, typename TRight> inline bool operator< (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(385)
template <typename TLeft, typename TSpec> inline bool operator< (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(396)
template <typename TLeftSpec, typename TRightSpec> inline bool operator< (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(407)
template <typename TSpec> inline bool operator< (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(419)
template <typename _T, unsigned _sizeL, unsigned _sizeR> inline bool operator<(Tuple<_T, _sizeL, Compressed> const &_left, Tuple<_T, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(511)
template <typename TValue, typename TSpec, typename TRight> inline bool operator< (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(704)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator< (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(715)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator< (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(726)
template <typename TValue, typename TSpec> inline bool operator< (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(738)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator< (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(748)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator< (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(759)
template <typename TContainer> inline bool operator< (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(229)
template <typename TContainer> inline bool operator< (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(262)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & strm, Proxy<TSpec> & proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(600)
template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & strm, Proxy<TSpec> const & proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(607)
template <typename TStream, typename TValue, typename TSpec> TStream& operator<<(TStream& os, LogProb<TValue, TSpec> const& rhs);       	// "projects/library/seqan/basic/basic_logvalue.h"(311)
template <typename TStream, typename TValue, typename TCount, typename TSpec> inline TStream& operator<<(TStream& os, ProfileType<TValue, TCount, TSpec> const& rhs);       	// "projects/library/seqan/basic/basic_profchar.h"(190)
template <typename _T1, typename _T2, typename TCompression> std::ostream& operator<<(std::ostream &out, Pair<_T1,_T2,TCompression> const &p);       	// "projects/library/seqan/basic/basic_aggregates.h"(168)
template <typename _T1, typename _T2, typename _T3, typename TCompression> std::ostream& operator<<(std::ostream &out, Triple<_T1,_T2,_T3,TCompression> const &t);       	// "projects/library/seqan/basic/basic_aggregates.h"(287)
template <typename _T, unsigned _size, typename TCompression> std::ostream& operator<<(std::ostream& out, Tuple<_T,_size,TCompression> const &a);       	// "projects/library/seqan/basic/basic_aggregates.h"(568)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator<< (TStream & stream, SimpleType<TValue, TSpec> const & data);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(264)

//____________________________________________________________________________
// operator<=

template <typename TSpec, typename TRight> inline bool operator<= (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(432)
template <typename TLeft, typename TSpec> inline bool operator<= (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(443)
template <typename TLeftSpec, typename TRightSpec> inline bool operator<= (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(454)
template <typename TSpec> inline bool operator<= (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(466)
template <typename TValue, typename TSpec, typename TRight> inline bool operator<= (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(775)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator<= (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(786)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator<= (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(797)
template <typename TValue, typename TSpec> inline bool operator<= (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(809)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator<= (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(819)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator<= (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(830)
template <typename TContainer> inline bool operator<= (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(255)
template <typename TContainer> inline bool operator<= (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(284)

//____________________________________________________________________________
// operator==

template <typename TContainer, typename TIterator, typename TSpec> inline bool operator== (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(336)
template <typename TSpec, typename TRight> inline bool operator== (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(290)
template <typename TLeft, typename TSpec> inline bool operator== (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(301)
template <typename TLeftSpec, typename TRightSpec> inline bool operator== (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(312)
template <typename TSpec> inline bool operator== (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(324)
template <typename _T, unsigned _sizeL, unsigned _sizeR> inline bool operator==(Tuple<_T, _sizeL, Compressed> const &_left, Tuple<_T, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(519)
template <typename L1, typename L2, typename LCompression, typename R1, typename R2, typename RCompression> inline bool operator==(Pair<L1, L2, LCompression> const &_left, Pair<R1, R2, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(676)
template <typename L1, typename L2, unsigned LSizeI1, typename R1, typename R2, unsigned RSizeI1> inline bool operator==(Pair<L1, L2, CutCompressed<LSizeI1> > const &_left, Pair<R1, R2, CutCompressed<RSizeI1> > const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(685)
template <typename L1, typename L2, typename L3, typename LCompression, typename R1, typename R2, typename R3, typename RCompression> inline bool operator==(Triple<L1, L2, L3, LCompression> const &_left, Triple<R1, R2, R3, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(697)
template <typename TValue, typename TSpec, typename TRight> inline bool operator== (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(562)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator== (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(573)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator== (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(584)
template <typename TValue, typename TSpec> inline bool operator== (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(596)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator== (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(606)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator== (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(617)
template <typename TContainer> inline bool operator== (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(203)
template <typename TContainer> inline bool operator== (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(236)

//____________________________________________________________________________
// operator>

template <typename TSpec, typename TRight> inline bool operator> (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(480)
template <typename TLeft, typename TSpec> inline bool operator> (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(491)
template <typename TLeftSpec, typename TRightSpec> inline bool operator> (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(502)
template <typename TSpec> inline bool operator> (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(514)
template <typename _T, unsigned _sizeL, unsigned _sizeR> inline bool operator>(Tuple<_T, _sizeL, Compressed> const &_left, Tuple<_T, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(515)
template <typename TValue, typename TSpec, typename TRight> inline bool operator> (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(847)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator> (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(858)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator> (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(869)
template <typename TValue, typename TSpec> inline bool operator> (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(881)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator> (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(891)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator> (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(902)
template <typename TContainer> inline bool operator> (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(242)
template <typename TContainer> inline bool operator> (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(271)

//____________________________________________________________________________
// operator>=

template <typename TSpec, typename TRight> inline bool operator>= (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(528)
template <typename TLeft, typename TSpec> inline bool operator>= (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(539)
template <typename TLeftSpec, typename TRightSpec> inline bool operator>= (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(550)
template <typename TSpec> inline bool operator>= (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(562)
template <typename TValue, typename TSpec, typename TRight> inline bool operator>= (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(918)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator>= (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(929)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator>= (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(940)
template <typename TValue, typename TSpec> inline bool operator>= (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(952)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator>= (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(962)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator>= (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(973)
template <typename TContainer> inline bool operator>= (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(268)
template <typename TContainer> inline bool operator>= (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(293)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename TSpec> inline TStream & operator>> (TStream & strm, Proxy<TSpec> & proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(574)
template <typename TStream, typename TSpec> inline TStream & operator>> (TStream & strm, Proxy<TSpec> const& proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(586)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator>> (TStream & stream, SimpleType<TValue, TSpec> & data);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(276)

//____________________________________________________________________________
// parentAllocator

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(147)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(279)
template <size_t SIZE, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<SinglePool<SIZE, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(136)
template <typename TValue, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<SinglePool2<TValue, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(256)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT> inline TParentAllocator & parentAllocator(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(115)
template <typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<SimpleAlloc<TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(103)

//____________________________________________________________________________
// position

template <typename TContainer, typename TSpec, typename TContainer2> inline typename Position<Iter<TContainer, TSpec> const>::Type position(Iter<TContainer, TSpec> const & me, TContainer2 const &);       	// "projects/library/seqan/basic/basic_iterator_base.h"(277)
template <typename TContainer, typename TIterator, typename TSpec> inline typename Position<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(238)
template <typename TContainer, typename TIterator, typename TSpec, typename TContainer2> inline typename Position<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me, TContainer2 const &);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(249)
template <typename TContainer, typename TContainer2> inline typename Position<Iter<TContainer, SimpleIterator> const>::Type position(Iter<TContainer, SimpleIterator> const & me, TContainer2 const & cont);       	// "projects/library/seqan/basic/basic_iterator_simple.h"(108)
template <typename T> inline typename Position<T>::Type position(T * me);       	// "projects/library/seqan/basic/basic_iterator.h"(354)
template <typename TContainer, typename TIterator> inline typename Position<TContainer>::Type position(TIterator const & it, TContainer const & me);       	// "projects/library/seqan/basic/basic_iterator.h"(363)
template <typename TContainer> inline typename Position<TContainer>::Type & position(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(146)
template <typename TContainer> inline typename Position<TContainer>::Type const & position(Iter<TContainer, PositionIterator> const & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(153)

//____________________________________________________________________________
// releaseRef

template <typename T> inline void releaseRef(T & );       	// "projects/library/seqan/basic/basic_holder.h"(73)
template <typename T> inline void releaseRef(T const & );       	// "projects/library/seqan/basic/basic_holder.h"(79)

//____________________________________________________________________________
// resize

template <typename TSize> inline void resize(VoidHolder & me, TSize length);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(120)

//____________________________________________________________________________
// set

template <typename TTarget, typename TSource> inline void set(TTarget & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(160)
template <typename TTarget, typename TSource> inline void set(TTarget const & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(168)
template <typename TTarget, typename TSource> inline void set(TTarget & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(176)
template <typename TTarget, typename TSource> inline void set(TTarget const & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(184)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename TIterator, typename TSpec> inline void setContainer(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, typename _Parameter<TContainer>::Type container_);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(185)
template <typename TContainer> inline void setContainer(Iter<TContainer, PositionIterator> & me, typename _Parameter<TContainer>::Type container_);       	// "projects/library/seqan/basic/basic_iterator_position.h"(133)

//____________________________________________________________________________
// setHost

template <typename T, typename THost> inline void setHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(99)
template <typename T, typename THost> inline void setHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(107)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename TIterator, typename TSpec, typename TPosition> inline void setPosition(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, TPosition pos_);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(262)
template <typename TContainer, typename TPosition> inline void setPosition(Iter<TContainer, PositionIterator> & me, TPosition position_);       	// "projects/library/seqan/basic/basic_iterator_position.h"(162)

//____________________________________________________________________________
// setValue

template <typename TValue> inline void setValue(Holder<TValue, Tristate> & me, TValue & value_);       	// "projects/library/seqan/basic/basic_holder.h"(889)
template <typename TValue> inline void setValue(Holder<TValue const, Tristate> & me, TValue & value_);       	// "projects/library/seqan/basic/basic_holder.h"(903)
template <typename TValue> inline void setValue(Holder<TValue *, Tristate> & me, TValue * & value_);       	// "projects/library/seqan/basic/basic_holder.h"(917)
template <typename TValue> inline void setValue(Holder<TValue *, Tristate> & me, TValue * const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(929)
template <typename TValue> inline void setValue(Holder<TValue * const, Tristate> & me, TValue * & value_);       	// "projects/library/seqan/basic/basic_holder.h"(941)
template <typename TValue> inline void setValue(Holder<TValue * const, Tristate> & me, TValue * const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(953)
template <typename TValue, typename TValue2> inline void setValue(Holder<TValue, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1017)
template <typename TValue, typename TValue2> inline void setValue(Holder<TValue, Tristate> & me, TValue2 const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1026)
template <typename TValue> inline void setValue(Holder<TValue, Simple> & me, TValue const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1281)
template <typename TValue> inline void setValue(Holder<TValue, Tristate2> & me, TValue & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1556)

//____________________________________________________________________________
// shiftLeft

template <typename _T, unsigned _size, typename TCompression> inline void shiftLeft(Tuple<_T, _size, TCompression> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(545)
template <typename _T, unsigned _size> inline void shiftLeft(Tuple<_T, _size, Compressed> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(555)

//____________________________________________________________________________
// shiftRight

template <typename _T, unsigned _size, typename TCompression> inline void shiftRight(Tuple<_T, _size, TCompression> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(550)
template <typename _T, unsigned _size> inline void shiftRight(Tuple<_T, _size, Compressed> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(560)

//____________________________________________________________________________
// supremumValue

template <typename T> inline T const & supremumValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(130)
template <typename T> inline T const & supremumValue(T);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(139)

//____________________________________________________________________________
// supremumValueImpl

template <typename T> inline T const & supremumValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(432)
inline float const & supremumValueImpl(float *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(667)
inline double const & supremumValueImpl(double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(694)
inline long double const & supremumValueImpl(long double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(721)

//____________________________________________________________________________
// value

template <typename TContainer, typename TIterator, typename TSpec> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > >::Type value(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(274)
template <typename TContainer, typename TIterator, typename TSpec> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const>::Type value(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(281)
template <typename TValue> inline TValue & value(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(159)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate> >::Type value(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1039)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate> const>::Type value(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1054)
template <typename TValue> inline typename Reference<Holder<TValue, Simple> >::Type value(Holder<TValue, Simple> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1291)
template <typename TValue> inline typename Reference<Holder<TValue, Simple> const>::Type value(Holder<TValue, Simple> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1298)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate2> >::Type value(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1573)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate2> const>::Type value(Holder<TValue, Tristate2> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1590)
template <typename TContainer> inline typename Reference<Iter<TContainer, StdIteratorAdaptor> >::Type value(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(146)
template <typename TContainer> inline typename Reference<Iter<TContainer, StdIteratorAdaptor> const>::Type value(Iter<TContainer, StdIteratorAdaptor> const & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(152)
template <typename T> inline typename Reference<T>::Type value(T & me);       	// "projects/library/seqan/basic/basic_iterator.h"(171)
template <typename T> inline typename Reference<T const>::Type value(T const & me);       	// "projects/library/seqan/basic/basic_iterator.h"(178)
template <typename T> inline T & value(T * me);       	// "projects/library/seqan/basic/basic_iterator.h"(187)
template <typename TContainer> inline typename Reference<Iter<TContainer, PositionIterator> >::Type value(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(174)
template <typename TContainer> inline typename Reference<Iter<TContainer, PositionIterator> >::Type value(Iter<TContainer, PositionIterator> const & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(181)

//____________________________________________________________________________
// valueConstruct

template <typename TIterator> inline void valueConstruct(TIterator it);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(148)
template <typename TIterator, typename TParam> inline void valueConstruct(TIterator it, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(168)
template <typename TIterator, typename TParam> inline void valueConstruct(TIterator it, TParam const & param_, Move tag);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(189)

//____________________________________________________________________________
// valueConstructMove

template <typename TIterator, typename TValue> inline void valueConstructMove(TIterator it, TValue const & value);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(251)

//____________________________________________________________________________
// valueDestruct

template <typename TIterator> inline void valueDestruct(TIterator it);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(219)

} //namespace SEQAN_NAMESPACE_MAIN

//____________________________________________________________________________
// _compareBinaryFiles

inline bool _compareBinaryFiles(char * file1, char * file2);       	// "projects/library/seqan/basic/basic_debug.h"(119)

//____________________________________________________________________________
// _compareTextFiles

inline bool _compareTextFiles(char * file1, char * file2);       	// "projects/library/seqan/basic/basic_debug.h"(185)

//____________________________________________________________________________
// _compareTextFiles_readChar

inline void _compareTextFiles_readChar(FILE * fl, char & c, int & num_lb, bool & is_eof);       	// "projects/library/seqan/basic/basic_debug.h"(153)

#endif

