#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: sam2matrix
class: CommandLineTool
cwlVersion: v1.0
doc: "This program determines for each read in the reference file if it has an entry\
  \ in the provided sam files stating that it mapped. Afterwards a file is generated\
  \ containing a row for each read which contains the read ID and the index of the\
  \ mapped references.\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- doc: File containing the mappings.
  id: param_mapping
  inputBinding:
    prefix: -mapping
  label: File containing the mappings.
  type: File
- doc: File containing the reads contained in the mapping file(s).
  id: param_reads
  inputBinding:
    prefix: -reads
  label: File containing the reads contained in the mapping file(s).
  type: File
- doc: Name of the file used as reference of the corresponding sam file. If not specified
    the names of the mapping files are taken
  id: param_reference
  inputBinding:
    prefix: -reference
  label: Name of the file used as reference of the corresponding sam file. If not
    specified the names of the mapping files are taken
  type:
  - 'null'
  - string
- doc: Filename for out output file
  id: param_out_filename
  inputBinding:
    prefix: -out
  label: Filename for out output file
  type: string
label: This program outputs for each read the ids of references it maps to.
outputs:
- doc: Output file.
  id: param_out
  label: Output file.
  outputBinding:
    glob: $(inputs.param_out_filename)
  type: File
