/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Written (W) 1999-2008 Soeren Sonnenburg
 * Written (W) 1999-2008 Gunnar Raetsch
 * Copyright (C) 1999-2008 Fraunhofer Institute FIRST and Max-Planck-Society
 */

#ifndef __GUIHMM__H
#define __GUIHMM__H

#include "lib/config.h"

#ifndef HAVE_SWIG
#include "base/SGObject.h"
#include "distributions/hmm/HMM.h"
#include "features/Labels.h"

class CSGInterface;

class CGUIHMM : public CSGObject
{
	public:
		CGUIHMM(CSGInterface* interface);
		~CGUIHMM();

		/** create new HMM */
		bool new_hmm(INT n, INT m);
		/** load HMM from file */
		bool load(CHAR* filename);
		/** save HMM to file */
		bool save(CHAR* filename, bool is_binary=false);

		bool set_num_hmm_tables(CHAR* param) ;
		/** train Baum-Welch */
		bool baum_welch_train();
		/** train Baum-Welch trans */
		bool baum_welch_trans_train();
		bool baum_welch_train_defined();
		/** train Viterbi defined */
		bool viterbi_train_defined();
		/** train Viterbi */
		bool viterbi_train();
		bool linear_train(CHAR align='l');
		bool linear_train_from_file(CHAR* param);
		/** test HMM ONE_CLASS */
		bool one_class_test(
				CHAR* filename_out, CHAR* filename_roc, bool is_linear);
		/** test HMM */
		bool hmm_test(
				CHAR* filename_out, CHAR* filename_roc,
				bool is_pos_linear, bool is_neg_linear);
		bool hmm_classify(CHAR* param);
		/** append HMM/model for CmdlineInterface */
		bool append_model(CHAR* filename, INT base1=-1, INT base2=-1);
		/** add states to HMM */
		bool add_states(INT num_states=1, DREAL value=0);
		/** set HMM as POS/NEG/TEST */
		bool set_hmm_as(CHAR* target);
		/** set HMM pseudo */
		bool set_pseudo(DREAL pseudo);
		/** set convergence criteria */
		bool convergence_criteria(
			INT num_iterations=100, DREAL epsilon=0.001);
		/** output HMM */
		bool output_hmm();
		/** output HMM defined */
		bool output_hmm_defined();
		/** print best path */
		bool best_path(INT from=0, INT to=100);
		bool normalize(bool keep_dead_states=false);
		bool save_path(CHAR* filename, bool is_binary=false);
		/** save HMM likelihood  to file */
		bool save_likelihood(CHAR* filename, bool is_binary=false);
		bool load_definitions(CHAR* filename, bool do_init=false);
		bool set_max_dim(CHAR* param);
		/** HMM likelihood */
		bool likelihood();
		/** chop HMM */
		bool chop(DREAL value);
		bool relative_entropy(DREAL*& values, INT& len);
		bool entropy(DREAL*& values, INT& len);
		/** define permutation entropy */
		bool permutation_entropy(INT width=0, INT seq_num=-1);
		inline CHMM* get_pos() { return pos; }
		inline CHMM* get_neg() { return neg; }
		inline CHMM* get_test() { return test; }
		inline void set_current(CHMM* h) { working=h; }
		inline CHMM* get_current() { return working; }
		inline DREAL get_pseudo() { return PSEUDO; }

		CLabels* classify(CLabels* output=NULL);
		DREAL classify_example(INT idx);
		CLabels* one_class_classify(CLabels* output=NULL);
		CLabels* linear_one_class_classify(CLabels* output=NULL);
		DREAL one_class_classify_example(INT idx);

	protected:
		bool converge(double x, double y);
		void switch_model(CHMM** m1, CHMM** m2);

		CHMM* working;

		CHMM* pos;
		CHMM* neg;
		CHMM* test;

		DREAL PSEUDO;
		INT M;

	protected:
		CSGInterface* ui;
};
#endif //HAVE_SWIG
#endif
