/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    cpu.c

    si - System Information Viewer
    Copyright (C) 1999-2001  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handlecpu ()
// 	determine the correct procedure to use
void handlecpu () {
	//  proc/cpuinfo in kernel 2.4 is compatible with kernel 2.2
	if (KERNEL==VER24) handlecpuv22();
	if (KERNEL==VER22) handlecpuv22();
	//  kernel 2.0
	if (KERNEL==VER20) handlecpuv20();
}

// handlecpuv20 ()
// 	code specific to the Linux Kernel 2.0
void handlecpuv20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int colpos;
	int c=-1;

	sprintf (filename, "%scpuinfo", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strlen(tmpstring) > STORAGE_STRING)
			tmpstring[STORAGE_STRING]=0;
		if (strncmp(tmpstring, "processor", 9)==0) {
			c++;
			if (c==CPU_COUNT_MAX) break;
			CPU[c]=malloc(CPU_STRUCT_SIZE);
			if (CPU[c]==NULL) error_handler(ERROR_MALLOC);
			initializecpu (CPU[c]);
		}
		if (strncmp(tmpstring, "vendor_id", 9)==0) {
			killcrlf(tmpstring, strlen(tmpstring));
			colpos=cinstr(tmpstring, ':');
			rstring(tmpstring, colpos+2, CPU[c]->VENDOR);
		}
		if (strncmp(tmpstring, "model", 5)==0) {
			killcrlf(tmpstring, strlen(tmpstring));
			colpos=cinstr(tmpstring, ':');
			rstring(tmpstring, colpos+2, CPU[c]->MODEL);
		}
	} while (0==0);
	NUM_CPU=c;
	fclose (filep);
	// Check All Values
	for (c=0; c<=NUM_CPU; c++) {
		if (strlen(CPU[c]->VENDOR)==0) sprintf(CPU[c]->VENDOR, "unknown");
		if (strlen(CPU[c]->MODEL)==0)  sprintf(CPU[c]->MODEL, "unknown");
		if (strlen(CPU[c]->SPEED)==0)  sprintf(CPU[c]->SPEED, "unknown");
		if (strlen(CPU[c]->CACHE)==0)  sprintf(CPU[c]->CACHE, "unknown");
	}
	// Return
	return;
}

// handlecpuv22 ()
//	code specific to the Linux Kernel 2.2
void handlecpuv22 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char tmpstring [INPUT_STRING];
	int colpos;
	int c=-1;

	sprintf (filename, "%scpuinfo", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		if (strlen(tmpstring) > STORAGE_STRING)
			tmpstring[STORAGE_STRING]=0;
		killcrlf(tmpstring, strlen(tmpstring));
		colpos=cinstr(tmpstring, ':');
		// on "processor" increment CPU counter
		if (strncmp(tmpstring, "processor", 9)==0) {
			c++;
			if (c==CPU_COUNT_MAX) break;
			CPU[c]=malloc(CPU_STRUCT_SIZE);
			if (CPU[c]==NULL) error_handler(ERROR_MALLOC);
			initializecpu (CPU[c]);
		}
		// "vendor_id" information
		if (strncmp(tmpstring, "vendor_id", 9)==0)
			rstring(tmpstring, colpos+2, CPU[c]->VENDOR);
		// "model name" information
		if (strncmp(tmpstring, "model name", 10)==0)
			rstring(tmpstring, colpos+2, CPU[c]->MODEL);
		// "cpu MHz" information
		if (strncmp(tmpstring, "cpu MHz", 7)==0)
			rstring(tmpstring, colpos+2, CPU[c]->SPEED);
		// "cache size" information
		if (strncmp(tmpstring, "cache size", 10)==0)
			rstring(tmpstring, colpos+2, CPU[c]->CACHE);
	} while (0==0);
	NUM_CPU=c;
	fclose (filep);
	// Check All Values
	for (c=0; c<=NUM_CPU; c++) {
		if (strlen(CPU[c]->VENDOR)==0) sprintf(CPU[c]->VENDOR, "unknown");
		if (strlen(CPU[c]->MODEL)==0)  sprintf(CPU[c]->MODEL, "unknown");
		if (strlen(CPU[c]->SPEED)==0)  sprintf(CPU[c]->SPEED, "unknown");
		if (strlen(CPU[c]->CACHE)==0)  sprintf(CPU[c]->CACHE, "unknown");
	}
	// Return
	return;
}


// initializecpu ()
void initializecpu (struct CPU_STRUCT *cpustr) {
	cpustr->VENDOR[0]=0;
	cpustr->MODEL[0]=0;
	cpustr->SPEED[0]=0;
	cpustr->CACHE[0]=0;
	cpustr->USER[0]=0;
	cpustr->NICE[0]=0;
	cpustr->SYS[0]=0;
	cpustr->IDLE[0]=0;
	return;
}

